/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.views.JspSupportServlet;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityResult
extends WebWorkResultSupport {
    private static final Log log = LogFactory.getLog(VelocityResult.class);

    public void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        JspFactory jspFactory = null;
        ServletContext servletContext = ServletActionContext.getServletContext();
        JspSupportServlet servlet = JspSupportServlet.jspSupportServlet;
        VelocityManager.getInstance().init(servletContext);
        boolean usedJspFactory = false;
        PageContext pageContext = (PageContext)ActionContext.getContext().get((Object)"com.opensymphony.xwork.dispatcher.PageContext");
        if (pageContext == null && servlet != null) {
            jspFactory = JspFactory.getDefaultFactory();
            pageContext = jspFactory.getPageContext((Servlet)servlet, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            ActionContext.getContext().put((Object)"com.opensymphony.xwork.dispatcher.PageContext", (Object)pageContext);
            usedJspFactory = true;
        }
        try {
            String encoding = this.getEncoding(finalLocation);
            String contentType = this.getContentType(finalLocation);
            if (encoding != null) {
                contentType = contentType + ";charset=" + encoding;
            }
            VelocityManager velocityManager = VelocityManager.getInstance();
            Template t = this.getTemplate(stack, velocityManager.getVelocityEngine(), invocation, finalLocation, encoding);
            Context context = this.createContext(velocityManager, stack, request, response, finalLocation);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
            response.setContentType(contentType);
            t.merge(context, writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error("Unable to render Velocity Template, '" + finalLocation + "'", e);
            throw e;
        }
        finally {
            if (usedJspFactory) {
                jspFactory.releasePageContext(pageContext);
            }
        }
    }

    protected String getContentType(String templateLocation) {
        return "text/html";
    }

    protected String getEncoding(String templateLocation) {
        String encoding = (String)Configuration.get("webwork.i18n.encoding");
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected Template getTemplate(OgnlValueStack stack, VelocityEngine velocity, ActionInvocation invocation, String location, String encoding) throws Exception {
        if (!location.startsWith("/")) {
            location = invocation.getProxy().getNamespace() + "/" + location;
        }
        Template template = velocity.getTemplate(location, encoding);
        return template;
    }

    protected Context createContext(VelocityManager velocityManager, OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response, String location) {
        return velocityManager.createContext(stack, request, response);
    }
}

