/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.webwork.components.template.Template;
import com.opensymphony.webwork.components.template.TemplateEngine;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTemplateEngine
implements TemplateEngine {
    private static final Log LOG = LogFactory.getLog(BaseTemplateEngine.class);
    final Map themeProps = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getThemeProps(Template template) {
        Map map = this.themeProps;
        synchronized (map) {
            Properties props = (Properties)this.themeProps.get(template.getTheme());
            if (props == null) {
                String propName = template.getDir() + "/" + template.getTheme() + "/theme.properties";
                InputStream is = ClassLoaderUtil.getResourceAsStream((String)propName, this.getClass());
                props = new Properties();
                if (is != null) {
                    try {
                        props.load(is);
                    }
                    catch (IOException e) {
                        LOG.error("Could not load " + propName, e);
                    }
                }
                this.themeProps.put(template.getTheme(), props);
            }
            return props;
        }
    }

    protected String getFinalTemplateName(Template template) {
        String t = template.toString();
        if (t.indexOf(".") <= 0) {
            return t + "." + this.getSuffix();
        }
        return t;
    }

    protected abstract String getSuffix();
}

