/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.utils;

import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoJSONUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(MoJSONUtils.class);

    public static Map<String, String> convertJsonToMap(String json, Map<String, String> mapToFill) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            Iterator<String> keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                mapToFill.put(key, jsonObject.getString(key));
            }
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while converting json to map ", (Throwable)e);
        }
        return mapToFill;
    }

    public static String convertMapToJSON(Map<String, String> map) {
        try {
            JSONObject jsonObject = new JSONObject();
            for (String key : map.keySet()) {
                jsonObject.put(key, map.get(key));
            }
            return jsonObject.toString();
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while converting map to json ", (Throwable)e);
            return null;
        }
    }

    public static String addKeyValue(String json, String ruleName, String ruleExpression) {
        try {
            JSONObject jsonObject = null;
            jsonObject = StringUtils.isNotBlank((CharSequence)json) ? new JSONObject(json) : new JSONObject();
            jsonObject.put(ruleName, ruleExpression);
            json = jsonObject.toString();
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while adding Key Value pair to JSON Object ", (Throwable)e);
        }
        return json;
    }
}

