/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoRedirectionRules
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoRedirectionRules.class);
    private MoSAMLSettings settings;
    private MoPluginHandler pluginHandler;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private DirectoryManager directoryManager;
    private String ruleName;
    private String decisionFactor;
    private String conditionOperation;
    private String conditionValue;
    private String idp;
    private Boolean addRedirectionRuleSubmitted;
    private Boolean editRedirectionRuleSubmitted;
    private Boolean bambooRulesOrderSubmitted;
    private Map<String, String> bambooRedirectionRulesMap;
    private Map<String, String> idpMap;
    private ArrayList<String> ssoEnabledIdpList;
    private String defaultBambooIDP;
    private String defaultRedirectUrl;
    private Boolean enableAutoRedirectDelay;
    private Boolean enableAutoRedirect;
    private Boolean enableBackdoor;
    private String backdoorKey;
    private String backdoorValue;
    private Boolean restrictBackdoor;
    private List<String> backdoorGroupsList;
    private String backdoorGroups;
    private Boolean backdoorSubmitted;
    private Boolean advancedSettingsSubmitted;
    private String numberOfLoginAttempts;
    private String xsrfToken;
    private List<String> noSsoUrls;

    public MoRedirectionRules(MoSAMLSettings settings, MoPluginHandler pluginHandler, DirectoryManager directoryManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.directoryManager = directoryManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public Boolean doValidate() {
        LOGGER.info("Validating Redirection Rules");
        boolean error = false;
        if (BooleanUtils.toBoolean((Boolean)this.addRedirectionRuleSubmitted) || BooleanUtils.toBoolean((Boolean)this.editRedirectionRuleSubmitted)) {
            Map<String, String> ruleMap;
            if (StringUtils.isBlank((CharSequence)this.ruleName)) {
                this.addActionError(this.getText("samlsso.error.empty.rule.name"));
                error = true;
            }
            if ((ruleMap = this.settings.getBambooRedirectionRulesMap()).containsKey(this.ruleName) && !BooleanUtils.toBoolean((Boolean)this.editRedirectionRuleSubmitted)) {
                this.addActionError(this.getText("samlsso.error.duplicate.rule.name"));
                error = true;
            }
            if (StringUtils.isBlank((CharSequence)this.decisionFactor)) {
                this.addActionError(this.getText("samlsso.error.empty.decisionFactor"));
                error = true;
                return error;
            }
            if (StringUtils.isBlank((CharSequence)this.conditionOperation)) {
                this.addActionError(this.getText("samlsso.error.empty.conditionOperation"));
                error = true;
                return error;
            }
            if (StringUtils.isBlank((CharSequence)this.conditionValue)) {
                error = true;
                switch (this.decisionFactor) {
                    case "domain": {
                        this.addActionError(this.getText("samlsso.error.empty.domain"));
                        break;
                    }
                    case "directory": {
                        this.addActionError(this.getText("samlsso.error.empty.directory"));
                        break;
                    }
                    case "group": {
                        this.addActionError(this.getText("samlsso.error.empty.group"));
                        break;
                    }
                    default: {
                        this.addActionError(this.getText("samlsso.error.unsuppported.decisionfactor"));
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.idp)) {
                this.addActionError(this.getText("samlsso.error.empty.idp"));
                error = true;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)this.advancedSettingsSubmitted) && BooleanUtils.toBoolean((Boolean)this.restrictBackdoor) && this.settings.convertSelect2StringToList(this.backdoorGroups).size() == 0) {
            LOGGER.debug("backdoor restriction enabled but no backdoor groups have been added");
            this.addActionError(this.getText("samlsso.error.empty.backdoor.groups"));
            error = true;
        }
        if (error) {
            this.initializeRedirectionRules();
        }
        return error;
    }

    private Boolean hasError(String backdoorKey, String backdoorValue) {
        if (StringUtils.isBlank((CharSequence)backdoorKey.trim())) {
            this.addActionError("Backdoor query parameter key is invalid. Please make sure it's not empty and doesn't contain spaces.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)backdoorValue.trim())) {
            this.addActionError("Backdoor query parameter value is invalid. Please make sure it's not empty and doesn't contain spaces.");
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.backdoorKey) || this.backdoorKey.split("\\s+").length > 1) {
            this.addActionError(this.getText("samlsso.error.config.backdoorkey.invalid"));
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.backdoorValue) || this.backdoorValue.split("\\s+").length > 1) {
            this.addActionError(this.getText("samlsso.error.config.backdoorvalue.invalid"));
            return true;
        }
        return false;
    }

    public String execute() throws Exception {
        LOGGER.debug("MoRedirection Rules execute called. ");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                boolean error = this.doValidate();
                if (error) {
                    return "input";
                }
                if (BooleanUtils.toBoolean((Boolean)this.addRedirectionRuleSubmitted) || BooleanUtils.toBoolean((Boolean)this.editRedirectionRuleSubmitted)) {
                    LOGGER.debug("addRedirectionRuleSubmitted or editRedirectionRuleSubmitted.. ");
                    MoPluginHandler.saveRedirectionRules(this.ruleName, this.decisionFactor, this.conditionOperation, this.conditionValue, this.idp);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                } else if (BooleanUtils.toBoolean((Boolean)this.bambooRulesOrderSubmitted)) {
                    this.bambooRedirectionRulesMap = this.settings.getBambooRedirectionRulesMap();
                    int size = this.bambooRedirectionRulesMap.size();
                    this.bambooRedirectionRulesMap = new LinkedHashMap<String, String>();
                    for (int i = 0; i < size; ++i) {
                        this.ruleName = request.getParameter("ruleKey_" + i);
                        String ruleExpression = request.getParameter("ruleExpression_" + i);
                        this.bambooRedirectionRulesMap.put(this.ruleName, ruleExpression);
                        this.addActionMessage(this.getText("samlsso.success.config"));
                    }
                } else if (BooleanUtils.toBoolean((Boolean)this.advancedSettingsSubmitted)) {
                    LOGGER.debug("advancedSettingsSubmitted .. ");
                    LOGGER.debug("Saving sign in settings...");
                    if (this.settings.getIdPList().size() == 1) {
                        if (BooleanUtils.toBoolean((Boolean)this.enableAutoRedirect)) {
                            LOGGER.debug("autoRedirect enabled for : " + this.settings.getIdpMap().get(this.settings.getIdPList().get(0)));
                            this.settings.setDefaultBambooIDP(this.settings.getIdPList().get(0));
                        } else {
                            LOGGER.debug("autoRedirect disabled for : " + this.settings.getIdpMap().get(this.settings.getIdPList().get(0)));
                            this.settings.setDefaultBambooIDP("loginPage");
                            this.enableAutoRedirectDelay = Boolean.FALSE;
                        }
                    }
                    int totalNumberOfRoles = Integer.parseInt(request.getParameter("totalNumberOfRoles"));
                    LOGGER.debug("totalNumberOfRoles = " + totalNumberOfRoles);
                    this.noSsoUrls = new ArrayList<String>();
                    for (int i = 0; i < totalNumberOfRoles; ++i) {
                        String value = request.getParameter("userAttrValue[" + i + "]");
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        this.noSsoUrls.add(value);
                    }
                    this.backdoorGroupsList = this.settings.convertSelect2StringToList(this.backdoorGroups);
                    LOGGER.debug("backdoorGroupsList {}", this.backdoorGroupsList);
                    LOGGER.debug("enblebackdoor" + this.enableBackdoor);
                    MoPluginHandler.saveAdvancedRedirectionSettings(this.enableAutoRedirectDelay, this.enableBackdoor, this.restrictBackdoor, this.backdoorGroupsList, this.numberOfLoginAttempts, this.noSsoUrls);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                } else if (BooleanUtils.toBoolean((Boolean)this.backdoorSubmitted)) {
                    LOGGER.debug("backdoorKey: " + this.backdoorKey);
                    LOGGER.debug("backdoorValue: " + this.backdoorValue);
                    this.backdoorKey = MoSAMLUtils.sanitizeText(this.backdoorKey);
                    this.backdoorValue = MoSAMLUtils.sanitizeText(this.backdoorValue);
                    error = this.hasError(this.backdoorKey, this.backdoorValue);
                    if (!error) {
                        MoPluginHandler.saveBackdoorValues(this.backdoorKey, this.backdoorValue);
                        this.addActionMessage(this.getText("samlsso.backdoor.success.config"));
                    }
                }
                this.initializeRedirectionRules();
                if (error) {
                    response.setContentType("application/json");
                    LOGGER.error(" 400.The Entered parameters are  not found or is empty");
                    response.sendError(400, "The requested parameter entered are not found or is empty");
                    return "error";
                }
                return "success";
            }
            catch (JSONException e) {
                LOGGER.error("An error occurred while creating the rule ", (Throwable)e);
                this.addActionError("An Error Occurred while creating the rule " + e.getMessage());
                return "error";
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while saving the rule", (Throwable)e);
                this.addActionError("An Error Occurred while creating the rule. " + e.getMessage());
                return "error";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeRedirectionRules() {
        this.bambooRedirectionRulesMap = this.settings.getBambooRedirectionRulesMap();
        LOGGER.debug("bambooRedirectionRulesMap {}", this.bambooRedirectionRulesMap);
        this.idpMap = this.settings.getIdpMap();
        this.ssoEnabledIdpList = this.settings.getSsoEnabledForIdPList();
        LOGGER.debug("sso enabled list" + this.settings.getSsoEnabledForIdPList());
        this.defaultBambooIDP = this.settings.getDefaultBambooIDP();
        this.defaultRedirectUrl = this.settings.getDefaultRedirectURL();
        this.noSsoUrls = this.settings.getNoSSOUrls();
        if (this.settings.getSsoEnabledForIdPList().size() == 1) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getDefaultBambooIDP(), (CharSequence)this.settings.getSsoEnabledForIdPList().get(0))) {
                LOGGER.debug("initializing autoredirect to FALSE");
                this.enableAutoRedirect = false;
            } else {
                LOGGER.debug("initializing autoRedirect to TRUE");
                this.enableAutoRedirect = true;
            }
        }
        this.enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
        this.restrictBackdoor = this.settings.getRestrictBackdoor();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.backdoorGroupsList = this.settings.getBackdoorGroups();
        this.numberOfLoginAttempts = this.settings.getNumberOfLoginAttempts();
        this.backdoorKey = this.settings.getBackdoorKey();
        this.backdoorValue = this.settings.getBackdoorValue();
        this.backdoorSubmitted = BooleanUtils.toBoolean((Boolean)this.backdoorSubmitted);
        this.advancedSettingsSubmitted = BooleanUtils.toBoolean((Boolean)this.advancedSettingsSubmitted);
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getDecisionFactor() {
        return this.decisionFactor;
    }

    public void setDecisionFactor(String decisionFactor) {
        this.decisionFactor = decisionFactor;
    }

    public String getConditionOperation() {
        return this.conditionOperation;
    }

    public void setConditionOperation(String conditionOperation) {
        this.conditionOperation = conditionOperation;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
    }

    public String getIdp() {
        return this.idp;
    }

    public void setIdp(String idp) {
        this.idp = idp;
    }

    public Boolean getAddRedirectionRuleSubmitted() {
        return this.addRedirectionRuleSubmitted;
    }

    public void setAddRedirectionRuleSubmitted(Boolean addRedirectionRuleSubmitted) {
        this.addRedirectionRuleSubmitted = addRedirectionRuleSubmitted;
    }

    public Boolean getEditRedirectionRuleSubmitted() {
        return this.editRedirectionRuleSubmitted;
    }

    public void setEditRedirectionRuleSubmitted(Boolean editRedirectionRuleSubmitted) {
        this.editRedirectionRuleSubmitted = editRedirectionRuleSubmitted;
    }

    public Boolean getBambooRulesOrderSubmitted() {
        return this.bambooRulesOrderSubmitted;
    }

    public void setBambooRulesOrderSubmitted(Boolean bambooRulesOrderSubmitted) {
        this.bambooRulesOrderSubmitted = bambooRulesOrderSubmitted;
    }

    public Map<String, String> getBambooRedirectionRulesMap() {
        return this.bambooRedirectionRulesMap;
    }

    public void setBambooRedirectionRulesMap(Map<String, String> bambooRedirectionRulesMap) {
        this.bambooRedirectionRulesMap = bambooRedirectionRulesMap;
    }

    public Map<String, String> getIdpMap() {
        return this.idpMap;
    }

    public void setIdpMap(Map<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public ArrayList<String> getSsoEnabledIdpList() {
        return this.ssoEnabledIdpList;
    }

    public void setSsoEnabledIdpList(ArrayList<String> ssoEnabledIdpList) {
        this.ssoEnabledIdpList = ssoEnabledIdpList;
    }

    public String getDefaultBambooIDP() {
        return this.defaultBambooIDP;
    }

    public void setDefaultBambooIDP(String defaultBambooIDP) {
        this.defaultBambooIDP = defaultBambooIDP;
    }

    public String getDefaultRedirectUrl() {
        return this.defaultRedirectUrl;
    }

    public void setDefaultRedirectUrl(String defaultRedirectUrl) {
        this.defaultRedirectUrl = defaultRedirectUrl;
    }

    public Boolean getEnableAutoRedirectDelay() {
        return this.enableAutoRedirectDelay;
    }

    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.enableAutoRedirectDelay = enableAutoRedirectDelay;
    }

    public Boolean getEnableAutoRedirect() {
        return this.enableAutoRedirect;
    }

    public void setEnableAutoRedirect(Boolean enableAutoRedirect) {
        this.enableAutoRedirect = enableAutoRedirect;
    }

    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    public String getBackdoorKey() {
        return this.backdoorKey;
    }

    public void setBackdoorKey(String backdoorKey) {
        this.backdoorKey = backdoorKey;
    }

    public String getBackdoorValue() {
        return this.backdoorValue;
    }

    public void setBackdoorValue(String backdoorValue) {
        this.backdoorValue = backdoorValue;
    }

    public Boolean getRestrictBackdoor() {
        return this.restrictBackdoor;
    }

    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.restrictBackdoor = restrictBackdoor;
    }

    public List<String> getBackdoorGroupsList() {
        return this.backdoorGroupsList;
    }

    public void setBackdoorGroupsList(List<String> backdoorGroupsList) {
        this.backdoorGroupsList = backdoorGroupsList;
    }

    public String getNumberOfLoginAttempts() {
        return this.numberOfLoginAttempts;
    }

    public void setNumberOfLoginAttempts(String numberOfLoginAttempts) {
        this.numberOfLoginAttempts = numberOfLoginAttempts;
    }

    public String getBackdoorGroups() {
        return this.backdoorGroups;
    }

    public void setBackdoorGroups(String backdoorGroups) {
        this.backdoorGroups = backdoorGroups;
    }

    public Boolean getBackdoorSubmitted() {
        return this.backdoorSubmitted;
    }

    public void setBackdoorSubmitted(Boolean backdoorSubmitted) {
        this.backdoorSubmitted = backdoorSubmitted;
    }

    public Boolean getAdvancedSettingsSubmitted() {
        return this.advancedSettingsSubmitted;
    }

    public void setAdvancedSettingsSubmitted(Boolean advancedSettingsSubmitted) {
        this.advancedSettingsSubmitted = advancedSettingsSubmitted;
    }

    public List<Directory> getDirectoryList() {
        List directoryList = this.directoryManager.findAllDirectories();
        LOGGER.debug("Directory list size {}", (Object)directoryList.size());
        return directoryList;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public List<String> getIdpList() {
        return this.settings.getIdPList();
    }

    public List<String> getNoSsoUrls() {
        return this.noSsoUrls;
    }

    public void setNoSsoUrls(List<String> noSsoUrls) {
        this.noSsoUrls = noSsoUrls;
    }
}

