/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoGlobalSSOSettingsAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoGlobalSSOSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoSAMLSettings settings;
    private String xsrfToken;
    private Boolean enableSAMLSSO;
    private Boolean enablePasswordChange;
    private Boolean autoActivateUser;
    private Boolean globalSettingsSubmitted;
    private Boolean pluginApiAccessRestriction;
    private String resetAssertionIDListInterval;
    private Boolean restrictDuplicateAssertion;
    private int customResetInterval;
    private MoPluginHandler pluginHandler;

    public MoGlobalSSOSettingsAction(UserManager userManager, LoginUriProvider loginUriProvider, MoSAMLSettings settings) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
    }

    public void doValidate() {
        LOGGER.info("Look n Feel Action doValidate called");
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (BooleanUtils.toBoolean((Boolean)this.globalSettingsSubmitted)) {
                    MoPluginHandler.saveGlobalSSOSettings(this.enableSAMLSSO, this.enablePasswordChange, this.autoActivateUser, this.pluginApiAccessRestriction, this.restrictDuplicateAssertion, this.resetAssertionIDListInterval, this.customResetInterval);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                }
                this.initializeGlobalSSOSettings();
                return "success";
            }
            catch (MoPluginException e) {
                LOGGER.error(e.getMessage());
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeGlobalSSOSettings() {
        this.enableSAMLSSO = this.settings.getEnableSAMLSSO();
        this.autoActivateUser = this.settings.getAutoActivateUser();
        this.enablePasswordChange = this.settings.getEnablePasswordChange();
        this.pluginApiAccessRestriction = this.settings.getPluginApiAccessRestriction();
        this.resetAssertionIDListInterval = this.settings.getResetAssertionIDListInterval();
        this.customResetInterval = this.settings.getCustomResetInterval();
        this.restrictDuplicateAssertion = this.settings.getRestrictDuplicateAssertion();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public HashMap<String, String> getIdpMap() {
        return this.settings.getIdpMap();
    }

    public ArrayList<String> getIdpList() {
        return this.settings.getIdPList();
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Boolean getEnableSAMLSSO() {
        return this.enableSAMLSSO;
    }

    public void setEnableSAMLSSO(Boolean enableSAMLSSO) {
        this.enableSAMLSSO = enableSAMLSSO;
    }

    public Boolean getEnablePasswordChange() {
        return this.enablePasswordChange;
    }

    public void setEnablePasswordChange(Boolean enablePasswordChange) {
        this.enablePasswordChange = enablePasswordChange;
    }

    public Boolean getGlobalSettingsSubmitted() {
        return this.globalSettingsSubmitted;
    }

    public void setGlobalSettingsSubmitted(Boolean globalSettingsSubmitted) {
        this.globalSettingsSubmitted = globalSettingsSubmitted;
    }

    public Boolean getPluginApiAccessRestriction() {
        return this.pluginApiAccessRestriction;
    }

    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginApiAccessRestriction = pluginApiAccessRestriction;
    }

    public MoPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }
}

