/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.components.Param;
import com.opensymphony.webwork.util.AppendIteratorFilter;
import com.opensymphony.webwork.util.MakeIterator;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppendIterator
extends Component
implements Param.UnnamedParametric {
    private static final Log _log = LogFactory.getLog(AppendIterator.class);
    private AppendIteratorFilter appendIteratorFilter = null;
    private List _parameters;

    public AppendIterator(OgnlValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        this._parameters = new ArrayList();
        this.appendIteratorFilter = new AppendIteratorFilter();
        return super.start(writer);
    }

    public boolean end(Writer writer, String body) {
        Iterator paramEntries = this._parameters.iterator();
        while (paramEntries.hasNext()) {
            Object iteratorEntryObj = paramEntries.next();
            if (!MakeIterator.isIterable(iteratorEntryObj)) {
                _log.warn("param with value resolved as " + iteratorEntryObj + " cannot be make as iterator, it will be ignored and hence will not appear in the merged iterator");
                continue;
            }
            this.appendIteratorFilter.setSource(MakeIterator.convert(iteratorEntryObj));
        }
        this.appendIteratorFilter.execute();
        if (this.getId() != null && this.getId().length() > 0) {
            this.getStack().getContext().put(this.getId(), this.appendIteratorFilter);
        }
        this.appendIteratorFilter = null;
        return super.end(writer, body);
    }

    public void addParameter(Object value) {
        this._parameters.add(value);
    }

    public void setId(String id) {
        super.setId(id);
    }
}

