/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLManager;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoEncryptionUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MoSAMLLogoutServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoSAMLLogoutServlet.class);
    private MoSAMLSettings settings;
    private MoSAMLManager samlManager;
    private final TemplateRenderer renderer;

    public MoSAMLLogoutServlet(MoSAMLSettings settings, MoSAMLManager samlManager, TemplateRenderer renderer) {
        this.settings = settings;
        this.samlManager = samlManager;
        this.renderer = renderer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoSAMLLogoutServlet doGet called");
        try {
            this.clearCookie("numberOfAttempts", request, response);
            Cookie logoutCookie = this.getCookie("LOGOUTCOOKIE", request);
            if (logoutCookie != null) {
                String idpId = logoutCookie.getValue();
                LOGGER.debug("idpId : " + idpId);
                this.clearCookie("PERFORM_LOGOUT", request, response);
                this.clearCookie("seraph.bamboo", request, response);
                if (StringUtils.isNotBlank((CharSequence)idpId) || StringUtils.isNotEmpty((CharSequence)idpId)) {
                    this.handleSAMLLogout(request, response, false, idpId);
                } else {
                    this.clearCookie("LOGOUTCOOKIE", request, response);
                    this.clearCookie("seraph.bamboo", request, response);
                    MoSAMLManager.httpRedirect(response, this.settings.getBaseUrl());
                }
            } else {
                this.clearCookie("LOGOUTCOOKIE", request, response);
                this.clearCookie("seraph.bamboo", request, response);
                MoSAMLManager.httpRedirect(response, this.settings.getBaseUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MoSAMLManager.httpRedirect(response, this.settings.getBaseUrl());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoSAMLLogoutServlet doPost called");
        try {
            Cookie logoutCookie = this.getCookie("LOGOUTCOOKIE", request);
            if (logoutCookie != null) {
                String idpId = logoutCookie.getValue();
                this.clearCookie("PERFORM_LOGOUT", request, response);
                this.clearCookie("seraph.bamboo", request, response);
                if (StringUtils.isNotBlank((CharSequence)idpId) || StringUtils.isNotEmpty((CharSequence)idpId)) {
                    this.handleSAMLLogout(request, response, true, idpId);
                }
            } else {
                this.clearCookie("LOGOUTCOOKIE", request, response);
                this.clearCookie("seraph.bamboo", request, response);
                MoSAMLManager.httpRedirect(response, this.settings.getBaseUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clearCookie("LOGOUTCOOKIE", request, response);
            this.clearCookie("seraph.bamboo", request, response);
            MoSAMLManager.httpRedirect(response, this.settings.getBaseUrl());
        }
    }

    private void handleSAMLLogout(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest, String idpId) throws IOException, DataFormatException, ParserConfigurationException, UnmarshallingException, SAXException {
        HttpSession session = request.getSession();
        MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpId);
        if (idpConfig != null && StringUtils.isNotBlank((CharSequence)idpConfig.getSloUrl())) {
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("SAMLResponse"))) {
                if (StringUtils.isNotBlank((CharSequence)this.settings.getCustomLogoutURL())) {
                    session.invalidate();
                    LOGGER.debug("Here After custom logout URL");
                    this.clearCookie("LOGOUTCOOKIE", request, response);
                    MoSAMLManager.httpRedirect(response, this.settings.getCustomLogoutURL());
                    return;
                }
                if (this.settings.getEnableLogoutTemplate().booleanValue()) {
                    session.invalidate();
                    LOGGER.debug("Here After custom logout template");
                    this.redirectToLogoutTemplate(response);
                    return;
                }
                LOGGER.debug("invalidate session...");
                session.invalidate();
                this.clearCookie("LOGOUTCOOKIE", request, response);
                MoSAMLManager.httpRedirect(response, this.settings.getLoginPageUrl());
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("SAMLRequest"))) {
                try {
                    String nameId = this.getCookie("NAMEIDCOOKIE", request).getValue();
                    String idpNameId = this.getNameIdFromIdpSAMLRequest(request);
                    idpNameId = MoEncryptionUtils.encrypt(this.settings.getCustomerTokenKey(), idpNameId);
                    if (!idpNameId.equals(nameId)) {
                        return;
                    }
                    Authenticator authenticator = SecurityConfigFactory.getInstance().getAuthenticator();
                    authenticator.logout(request, response);
                    this.samlManager.createLogoutResponseAndRedirect(request, response, isPostRequest, idpConfig);
                    return;
                }
                catch (AuthenticatorException e) {
                    e.printStackTrace();
                }
                catch (DataFormatException | ParserConfigurationException | UnmarshallingException | SAXException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)request.getHeader("referer"))) {
                    String nameId = this.getCookie("NAMEIDCOOKIE", request).getValue();
                    nameId = MoEncryptionUtils.decrypt(this.settings.getCustomerTokenKey(), nameId);
                    String sessionIndex = this.getCookie("SESSIONINDEXCOOKIE", request).getValue();
                    this.clearCookie("NAMEIDCOOKIE", request, response);
                    this.clearCookie("SESSIONINDEXCOOKIE", request, response);
                    if (idpConfig.getSignedRequest().booleanValue()) {
                        this.samlManager.createLogoutRequestAndRedirect(request, response, nameId, sessionIndex, idpConfig);
                    } else {
                        this.samlManager.createUnSignedLogoutRequestAndRedirect(request, response, nameId, sessionIndex, idpConfig);
                    }
                    return;
                }
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.settings.getCustomLogoutURL())) {
            session.invalidate();
            this.clearCookie("LOGOUTCOOKIE", request, response);
            MoSAMLManager.httpRedirect(response, this.settings.getCustomLogoutURL());
        } else if (this.settings.getEnableLogoutTemplate().booleanValue()) {
            session.invalidate();
            this.clearCookie("LOGOUTCOOKIE", request, response);
            this.redirectToLogoutTemplate(response);
        } else {
            session.invalidate();
            this.clearCookie("LOGOUTCOOKIE", request, response);
            MoSAMLManager.httpRedirect(response, this.settings.getLoginPageUrl());
        }
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    private void redirectToLogoutTemplate(HttpServletResponse response) throws IOException {
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("baseUrl", this.settings.getLoginPageUrl());
            String result = this.renderer.renderFragment(this.settings.getLogoutTemplate(), context);
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            MoSAMLManager.httpRedirect(response, this.settings.getLoginPageUrl());
        }
    }

    private Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public void clearCookie(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Clearing cookie : " + cookieName);
        Cookie cookie = this.getCookie(cookieName, request);
        if (cookie != null) {
            if (cookieName.equals("numberOfAttempts")) {
                cookie.setPath("/plugins/servlet/saml");
            } else {
                cookie.setPath("/");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public String getNameIdFromIdpSAMLRequest(HttpServletRequest request) throws DataFormatException, ParserConfigurationException, IOException, UnmarshallingException, SAXException {
        try {
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = MoSAMLUtils.readLogoutRequest(logoutRequestStr, true);
            String idpNameId = logoutRequest.getNameID().getValue();
            return idpNameId;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return null;
        }
    }
}

