/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.MoSAMLException;
import com.miniorange.sso.saml.MoSAMLResponse;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.MoSAMLUserManager;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class MoSAMLManager {
    private static Log LOGGER = LogFactory.getLog(MoSAMLManager.class);
    private String certificateexpected = "";
    private long timediff;
    private String replacement = "";
    private MoSAMLUserManager userManager;
    private CrowdService crowdService;
    private CrowdDirectoryService crowdDirectoryService;
    private MoSAMLSettings settings;

    public MoSAMLManager(MoSAMLSettings settings, MoSAMLUserManager userManager, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService) {
        this.settings = settings;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    public void createAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String relayState, MoIDPConfig idpConfig) throws IOException {
        try {
            LOGGER.debug("Creating Signed AuthnRequest...");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.getSPEntityID(idpConfig), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getNameIdFormat(), idpConfig.getForceAuthentication(), idpConfig.getEnablePassiveSso());
            if (StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SSO");
                authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest(authnRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState);
                response.setContentType("text/html");
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SSO");
            String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, false);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedAuthnRequest, relayState);
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = this.createRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false);
            LOGGER.info("redirect url" + redirectUrl);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            PrintWriter writer = response.getWriter();
            writer.print("Please try again.....");
            LOGGER.error("An unknown error occurred while creating the AuthnRequest.", t);
        }
    }

    public String getSignedTestAuthnRequest(MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating AuthnRequest...");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getBaseUrl(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getNameIdFormat(), idpConfig.getForceAuthentication(), idpConfig.getEnablePassiveSso());
            if (idpConfig.getSignedRequest().booleanValue() && StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest(authnRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            }
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public String getUnSignedTestAuthnRequest(MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating AuthnRequest...");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getBaseUrl(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getNameIdFormat(), idpConfig.getForceAuthentication(), idpConfig.getEnablePassiveSso());
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedAuthnRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String relayState, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating AuthnRequest...");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.getSPEntityID(idpConfig), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getNameIdFormat(), idpConfig.getForceAuthentication(), idpConfig.getEnablePassiveSso());
            if (StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SSO");
                String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState);
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SSO");
            String encodedAuthnRequest = MoSAMLUtils.base64EncodeRequest(authnRequest, false);
            String redirectUrl = this.createUnSignedRedirectURL(idpConfig.getSsoUrl(), encodedAuthnRequest, relayState, false);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public MoSAMLResponse readSAMLResponse(HttpServletRequest request, HttpServletResponse response, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Reading SAML Response");
            MoSAMLUtils.doBootstrap();
            String encodedSAMLResponse = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            relayState = MoSAMLUtils.sanitizeText(relayState);
            Response samlResponse = MoSAMLUtils.decodeResponse(encodedSAMLResponse);
            if (!StringUtils.equals((CharSequence)samlResponse.getStatus().getStatusCode().getValue(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
                LOGGER.error("Invalid SAML response. SAML Status Code received: " + samlResponse.getStatus().getStatusCode().getValue());
                String message = "";
                if (samlResponse.getStatus().getStatusMessage() != null) {
                    LOGGER.error("Saml Status Message received: " + samlResponse.getStatus().getStatusMessage().getMessage());
                    message = samlResponse.getStatus().getStatusMessage().getMessage() + ". Status Code received in SAML response: " + samlResponse.getStatus().getStatusCode().getValue().split(":")[7];
                } else {
                    message = "Invalid status code \"" + samlResponse.getStatus().getStatusCode().getValue().split(":")[7] + "\" received in SAML response";
                }
                throw new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_SAML_STATUS);
            }
            Assertion assertion = samlResponse.getAssertions() != null && samlResponse.getAssertions().size() > 0 ? samlResponse.getAssertions().get(0) : MoSAMLUtils.decryptAssertion(samlResponse.getEncryptedAssertions().get(0), this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String acsUrl = this.settings.getLoginServletUrl();
            String idpACSUrl = acsUrl + "?idp=" + idpConfig.getId();
            this.verifyConditions(assertion, this.getSPEntityID(idpConfig));
            this.verifyIssuer(samlResponse, assertion, idpConfig.getIdpEntityId());
            this.verifyDestination(samlResponse, acsUrl, idpACSUrl);
            this.verifyRecipient(assertion, acsUrl, idpACSUrl);
            MoSAMLException t = null;
            Boolean verified = Boolean.FALSE;
            try {
                verified = this.verifyCertificate(samlResponse, assertion, idpConfig.getX509Certificate());
            }
            catch (MoSAMLException e) {
                t = e;
            }
            List<String> certificates = idpConfig.getCertificates();
            if (certificates != null && !verified.booleanValue()) {
                for (int index = 1; index < certificates.size(); ++index) {
                    try {
                        verified = this.verifyCertificate(samlResponse, assertion, certificates.get(index));
                    }
                    catch (MoSAMLException e) {
                        t = e;
                    }
                    if (verified.booleanValue()) break;
                }
            }
            if (!verified.booleanValue()) {
                LOGGER.error(t.getMessage(), t);
                throw t;
            }
            Map<String, String[]> attributes = this.getAttributes(assertion);
            NameID nameId = assertion.getSubject().getNameID();
            String nameIdValue = "";
            String sessionIndex = assertion.getAuthnStatements().get(0).getSessionIndex();
            if (nameId != null) {
                nameIdValue = nameId.getValue();
            }
            attributes.put("NameID", new String[]{nameIdValue});
            MoSAMLResponse samlResponseObj = new MoSAMLResponse(attributes, nameIdValue, sessionIndex, relayState);
            return samlResponseObj;
        }
        catch (MoSAMLException e) {
            LOGGER.error(e.getMessage(), e);
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred while verifying the SAML Response.", e);
            throw new MoSAMLException(e, MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private void verifyIssuer(Response response, Assertion assertion, String idpEntityId) {
        LOGGER.debug("Verifying Issuer in Response and Assertion...");
        String issuerInResponse = response.getIssuer().getValue();
        String issuerInAssertion = assertion.getIssuer().getValue();
        if (!StringUtils.equals((CharSequence)issuerInResponse, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInResponse), errorCode);
            LOGGER.debug(e.getMessage(), e);
            throw e;
        }
        if (!StringUtils.equals((CharSequence)issuerInAssertion, (CharSequence)idpEntityId)) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_ISSUER;
            MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, idpEntityId, issuerInAssertion), errorCode);
            LOGGER.debug(e.getMessage(), e);
            throw e;
        }
    }

    private void verifyDestination(Response response, String acsUrl, String idpAcsUrl) {
        LOGGER.debug("Verifying Destination if present...");
        String destInResponse = response.getDestination();
        if (StringUtils.isBlank((CharSequence)destInResponse) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)destInResponse, (CharSequence)idpAcsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_DESTINATION;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, destInResponse), errorCode);
        LOGGER.debug(e.getMessage(), e);
        throw e;
    }

    private void verifyRecipient(Assertion assertion, String acsUrl, String idpAcsUrl) {
        LOGGER.debug("Verifying Recipient if present...");
        String recipientInResponse = assertion.getSubject().getSubjectConfirmations().get(0).getSubjectConfirmationData().getRecipient();
        if (StringUtils.isBlank((CharSequence)recipientInResponse) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)acsUrl) || StringUtils.equals((CharSequence)recipientInResponse, (CharSequence)idpAcsUrl)) {
            return;
        }
        MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_RECIPIENT;
        MoSAMLException e = new MoSAMLException(errorCode.getMessage(), this.buildResolutionMessage(errorCode, acsUrl, recipientInResponse), errorCode);
        LOGGER.debug(e.getMessage(), e);
        throw e;
    }

    private void verifyConditions(Assertion assertion, String audienceExpected) {
        LOGGER.debug("Verifying Conditions...");
        Date now = new DateTime().toDate();
        Date notBefore = null;
        Date notOnOrAfter = null;
        long timeDifferenceInBefore = 0L;
        long timeDifferenceInAfter = 0L;
        if (assertion.getConditions().getNotBefore() != null && now.before(notBefore = assertion.getConditions().getNotBefore().toDate())) {
            timeDifferenceInBefore = Math.abs(notBefore.getTime() - now.getTime());
        }
        if (assertion.getConditions().getNotOnOrAfter() != null && now.after(notOnOrAfter = assertion.getConditions().getNotOnOrAfter().toDate())) {
            timeDifferenceInAfter = Math.abs(now.getTime() - notOnOrAfter.getTime());
        }
        long userAddeddelay = this.timeInMilliseconds();
        if (notBefore != null && now.before(notBefore) && userAddeddelay - timeDifferenceInBefore < 0L) {
            this.timediff = -(userAddeddelay - timeDifferenceInBefore);
            this.replacement = "Forward";
        } else if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddeddelay - timeDifferenceInAfter < 0L) {
            this.timediff = timeDifferenceInAfter - userAddeddelay;
            this.replacement = "Back";
        }
        long valueinminutes = this.timediff / 60000L % 60L;
        long Exactvalueinminutes = Math.incrementExact(valueinminutes);
        LOGGER.debug("Time in milliseconds = " + this.timeInMilliseconds() + " Time diff before = " + (userAddeddelay - timeDifferenceInBefore) + " Time diff after = " + (userAddeddelay - timeDifferenceInAfter));
        if (notBefore != null && now.before(notBefore) && userAddeddelay - timeDifferenceInBefore < 0L) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.timeDiff(errorCode, Exactvalueinminutes), errorCode);
            LOGGER.error(samlexception.getMessage(), samlexception);
            throw samlexception;
        }
        if (notOnOrAfter != null && (now.after(notOnOrAfter) || now.equals(notOnOrAfter)) && userAddeddelay - timeDifferenceInAfter < 0L) {
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CONDITIONS;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.timeDiff(errorCode, Exactvalueinminutes), errorCode);
            LOGGER.error(samlexception.getMessage(), samlexception);
            throw samlexception;
        }
        List<Audience> audiencesInAssertion = assertion.getConditions().getAudienceRestrictions().get(0).getAudiences();
        for (Audience audience : audiencesInAssertion) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)audience.getAudienceURI(), (CharSequence)audienceExpected)) continue;
            return;
        }
        MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE);
        LOGGER.error(MoSAMLException.SAMLErrorCode.INVALID_AUDIENCE.getMessage(), e);
        throw e;
    }

    private String timeDiff(MoSAMLException.SAMLErrorCode error, long temp) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Set your Server clock " + this.replacement + " by ");
        errorMsg.append(temp);
        errorMsg.append(" minutes  Or you can Increase ");
        errorMsg.append(temp);
        errorMsg.append(" minutes in  validate Saml Response in SSO setting tab.");
        return errorMsg.toString();
    }

    public long timeInMilliseconds() {
        String time = this.settings.getTimeDelay();
        LOGGER.debug("Time is: " + time);
        long timeDelay = Math.abs(Long.valueOf(time));
        timeDelay = timeDelay * 60L * 1000L;
        return timeDelay;
    }

    private Boolean verifyCertificate(Response response, Assertion assertion, String x509Certificate) {
        LOGGER.debug("Verifying Certificate...");
        Boolean noError = true;
        try {
            if (!response.isSigned() && !assertion.isSigned()) {
                MoSAMLException e = new MoSAMLException(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED);
                LOGGER.error(MoSAMLException.SAMLErrorCode.ASSERTION_NOT_SIGNED.getMessage(), e);
                throw e;
            }
            if (response.isSigned()) {
                MoSAMLUtils.verifyCertificate(response, x509Certificate);
            }
            if (assertion.isSigned()) {
                MoSAMLUtils.verifyCertificate(assertion, x509Certificate);
            }
        }
        catch (CertificateException e) {
            noError = false;
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
            LOGGER.error(samlexception.getMessage(), e);
            throw samlexception;
        }
        catch (ValidationException e) {
            noError = false;
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_SIGNATURE;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
            LOGGER.error(samlexception.getMessage(), e);
            throw samlexception;
        }
        catch (NoSuchAlgorithmException e) {
            noError = false;
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
            LOGGER.error(samlexception.getMessage(), e);
            throw samlexception;
        }
        catch (InvalidKeySpecException e) {
            noError = false;
            MoSAMLException.SAMLErrorCode errorCode = MoSAMLException.SAMLErrorCode.INVALID_CERTIFICATE;
            MoSAMLException samlexception = new MoSAMLException(errorCode.getMessage(), this.buildResolutionforcertificate(errorCode, assertion, response), errorCode);
            LOGGER.error(samlexception.getMessage(), e);
            throw samlexception;
        }
        return noError;
    }

    private String buildResolutionforcertificate(MoSAMLException.SAMLErrorCode error, Assertion assertion, Response response) {
        try {
            List<X509Data> x509Datas;
            if (assertion.isSigned()) {
                x509Datas = assertion.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        this.certificateexpected = certificate.getValue();
                    }
                }
            } else if (response.isSigned()) {
                x509Datas = response.getSignature().getKeyInfo().getX509Datas();
                for (X509Data x509Data : x509Datas) {
                    List<X509Certificate> certificates = x509Data.getX509Certificates();
                    for (X509Certificate certificate : certificates) {
                        this.certificateexpected = certificate.getValue();
                    }
                }
            }
        }
        catch (Exception e) {
            error.getResolution();
        }
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Expected certificate : ");
        errorMsg.append("<textarea rows='6' cols='100' word-wrap='break-word;' style='width:580px; margin:0px; height:290px;' id ='errormsg' readonly>-----BEGIN CERTIFICATE-----" + this.certificateexpected + "-----END CERTIFICATE-----</textarea> ");
        errorMsg.append("<div style=\"margin:3%;display:block;text-align:center;\"><input id =\"copy-button\" style=\"padding:1%;width:150px;background: #0091CD none repeat scroll 0% 0%;cursor: pointer;font-size:15px;border-width: 1px;border-style: solid;border-radius: 3px;white-space: nowrap;box-sizing:border-box;border-color: #0073AA;box-shadow:0px 1px 0px rgba(120,200,230,0.6) inset;color: #FFF;\" type=\"button\" value=\"Copy to Clipboard\"></div>");
        errorMsg.append("<script>document.querySelector(\"#copy-button\").onclick = function() {document.querySelector(\"#errormsg\").select();document.execCommand('copy');};</script>");
        return errorMsg.toString();
    }

    private Map<String, String[]> getAttributes(Assertion assertion) {
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        if (assertion.getAttributeStatements().size() > 0) {
            for (Attribute attr : assertion.getAttributeStatements().get(0).getAttributes()) {
                if (attr.getAttributeValues().size() <= 0) continue;
                String[] values = new String[attr.getAttributeValues().size()];
                for (int i = 0; i < attr.getAttributeValues().size(); ++i) {
                    values[i] = attr.getAttributeValues().get(i).getDOM().getTextContent();
                }
                if (attributes.containsKey(attr.getName())) {
                    String[] updatedValues = new String[values.length + ((String[])attributes.get(attr.getName())).length];
                    System.arraycopy(attributes.get(attr.getName()), 0, updatedValues, 0, ((String[])attributes.get(attr.getName())).length);
                    System.arraycopy(values, 0, updatedValues, ((String[])attributes.get(attr.getName())).length, values.length);
                    attributes.put(attr.getName(), updatedValues);
                    continue;
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    public void createLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating LogoutRequest...");
            MoSAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = MoSAMLUtils.buildLogoutRequest(this.getSPEntityID(idpConfig), idpConfig.getSloUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                logoutRequest = (LogoutRequest)MoSAMLUtils.signHttpPostRequest(logoutRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl());
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, false);
            String urlForSignature = this.createRequestQueryParamsForSignature(encodedLogoutRequest, this.settings.getLoginPageUrl());
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = this.createRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, false);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutRequest.", t);
            t.printStackTrace();
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutRequestAndRedirect(HttpServletRequest request, HttpServletResponse response, String nameId, String sessionIndex, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating LogoutRequest...");
            MoSAMLUtils.doBootstrap();
            LogoutRequest logoutRequest = MoSAMLUtils.buildLogoutRequest(this.getSPEntityID(idpConfig), idpConfig.getSloUrl(), nameId, sessionIndex);
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, true);
                String form = this.createHttpPostRequestForm(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl());
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutRequest = MoSAMLUtils.base64EncodeRequest(logoutRequest, false);
            String redirectUrl = this.createUnSignedRedirectURL(idpConfig.getSloUrl(), encodedLogoutRequest, this.settings.getLoginPageUrl(), false);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the UnSigneddLogoutRequestAndRedirect.", t);
            t.printStackTrace();
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest, MoIDPConfig idpConfig) {
        try {
            MoSAMLUtils.doBootstrap();
            String relayState = request.getParameter("RelayState");
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = MoSAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            String sloResponseUrl = StringUtils.isNotBlank((CharSequence)idpConfig.getSloResponseLocationUrl()) ? idpConfig.getSloResponseLocationUrl() : idpConfig.getSloUrl();
            LogoutResponse logoutResponse = MoSAMLUtils.buildLogoutResponse(this.settings.getSpEntityId(), sloResponseUrl, logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                if (idpConfig.getSignedRequest().booleanValue()) {
                    logoutResponse = (LogoutResponse)MoSAMLUtils.signHttpPostRequest(logoutResponse, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
                }
                String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(sloResponseUrl, encodedLogoutResponse, relayState);
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, false);
            String urlForSignature = this.createResponseQueryParamsForSignature(encodedLogoutResponse, request.getParameter("RelayState"));
            String signature = MoSAMLUtils.signHttpRedirectRequest(urlForSignature, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            String redirectUrl = "";
            redirectUrl = idpConfig.getSignedRequest() != false ? this.createRedirectURL(sloResponseUrl, encodedLogoutResponse, relayState, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", signature, true) : this.createUnSignedRedirectURL(sloResponseUrl, encodedLogoutResponse, relayState, true);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the LogoutResponseAndRedirect.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    public void createUnSignedLogoutResponseAndRedirect(HttpServletRequest request, HttpServletResponse response, Boolean isPostRequest, MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating LogoutResponse...");
            MoSAMLUtils.doBootstrap();
            String logoutRequestStr = request.getParameter("SAMLRequest");
            LogoutRequest logoutRequest = MoSAMLUtils.readLogoutRequest(logoutRequestStr, isPostRequest);
            LogoutResponse logoutResponse = MoSAMLUtils.buildLogoutResponse(this.getSPEntityID(idpConfig), idpConfig.getSloUrl(), logoutRequest.getID(), "urn:oasis:names:tc:SAML:2.0:status:Success");
            if (StringUtils.equals((CharSequence)idpConfig.getSloBindingType(), (CharSequence)"HttpPost")) {
                LOGGER.debug("HTTP-POST Binding selected for SLO");
                String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, true);
                String form = this.createHttpPostResponseForm(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"));
                response.getOutputStream().write(form.getBytes(StandardCharsets.UTF_8));
                response.getOutputStream().close();
                return;
            }
            LOGGER.debug("HTTP-Redirect Binding selected for SLO");
            String encodedLogoutResponse = MoSAMLUtils.base64EncodeRequest(logoutResponse, false);
            String redirectUrl = this.createUnSignedRedirectURL(idpConfig.getSloUrl(), encodedLogoutResponse, request.getParameter("RelayState"), true);
            MoSAMLManager.httpRedirect(response, redirectUrl);
        }
        catch (Throwable t) {
            LOGGER.error("An unknown error occurred while creating the UnSigniedLogoutResponseAndRedirect.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String buildResolutionMessage(MoSAMLException.SAMLErrorCode error, String expected, String found) {
        StringBuffer errorMsg = new StringBuffer(error.getResolution());
        errorMsg.append(" Add-on was expecting ");
        errorMsg.append(found);
        errorMsg.append(" but found: ");
        errorMsg.append(expected);
        return errorMsg.toString();
    }

    private String createRedirectURL(String url, String samlRequestOrResponse, String relayState, String sigAlgo, String signature, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        builder.append("&").append("SigAlg").append("=").append(URLEncoder.encode(sigAlgo, "UTF-8")).append("&").append("Signature").append("=").append(URLEncoder.encode(signature, "UTF-8"));
        return builder.toString();
    }

    private String createUnSignedRedirectURL(String url, String samlRequestOrResponse, String relayState, Boolean isResponse) throws UnsupportedEncodingException {
        StringBuilder builder = new StringBuilder(url);
        if (StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"&")) {
            builder.append("&");
        } else if (!StringUtils.contains((CharSequence)url, (CharSequence)"?")) {
            builder.append("?");
        }
        if (isResponse.booleanValue()) {
            builder.append(this.createResponseQueryParamsForSignature(samlRequestOrResponse, relayState));
        } else {
            builder.append(this.createRequestQueryParamsForSignature(samlRequestOrResponse, relayState));
        }
        return builder.toString();
    }

    private String createRequestQueryParamsForSignature(String httpRedirectRequest, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLRequest").append("=").append(URLEncoder.encode(httpRedirectRequest, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createResponseQueryParamsForSignature(String httpRedirectResponse, String relayState) throws UnsupportedEncodingException {
        StringBuffer urlForSignature = new StringBuffer();
        urlForSignature.append("SAMLResponse").append("=").append(URLEncoder.encode(httpRedirectResponse, StandardCharsets.UTF_8.toString()));
        urlForSignature.append("&").append("RelayState").append("=");
        if (StringUtils.isNotBlank((CharSequence)relayState)) {
            urlForSignature.append(URLEncoder.encode(relayState, StandardCharsets.UTF_8.toString()));
        } else {
            urlForSignature.append(URLEncoder.encode("/", StandardCharsets.UTF_8.toString()));
        }
        return urlForSignature.toString();
    }

    private String createHttpPostRequestForm(String ssoUrl, String encodedRequest, String relayState) {
        String form = "<html><head><span style='font-size: 10pt; font-family: Verdana'>Please wait.....</span><script type=\"text/javascript\">window.onload = function() { document.forms['saml-request-form'].submit(); }</script></head><body><form action=\"" + ssoUrl + "\" method=\"post\" id=\"saml-request-form\"><input type=\"hidden\" name=\"SAMLRequest\" value=\"" + MoSAMLUtils.htmlEncode(encodedRequest) + "\" /><input type=\"hidden\" name=\"RelayState\" value=\"" + MoSAMLUtils.htmlEncode(relayState) + "\" /></form></body></html>";
        return form;
    }

    public String processRedirectionRulesAndReturnIDP(String username) {
        JSONArray rules = this.settings.getRedirectionRules();
        LOGGER.debug("Redirection Rules " + rules.toString());
        String idp = null;
        ArrayList<String> ssoEnabledIdpList = this.settings.getSsoEnabledForIdPList();
        try {
            if (rules == null) {
                return null;
            }
            BambooUser user = this.userManager.getUserByUsernameOrEmail(username);
            for (int i = 0; i < rules.length(); ++i) {
                String decisionFactor;
                JSONObject rule = rules.optJSONObject(i);
                JSONObject condition = rule.getJSONObject("condition");
                switch (decisionFactor = condition.getString("decisionFactor")) {
                    case "domain": {
                        idp = this.matchUserDomain(user, username, rule);
                        break;
                    }
                    case "group": {
                        if (user == null) break;
                        idp = this.matchUserGroup(user, rule);
                        break;
                    }
                    case "directory": {
                        if (user == null) break;
                        idp = this.matchUserDirectory(user, rule);
                        break;
                    }
                    default: {
                        LOGGER.error("Malformed Rule. Skipping this one");
                    }
                }
                LOGGER.debug("IDP is " + idp);
                if (!StringUtils.isNotBlank((CharSequence)idp)) continue;
                if (StringUtils.equalsIgnoreCase((CharSequence)idp, (CharSequence)"loginPage") || StringUtils.equalsIgnoreCase((CharSequence)idp, (CharSequence)"redirectUrl")) {
                    return idp;
                }
                if (!ssoEnabledIdpList.contains(idp)) continue;
                return idp;
            }
            LOGGER.debug("This is the defaule one " + this.settings.getDefaultBambooIDP());
            return this.settings.getDefaultBambooIDP();
        }
        catch (JSONException e) {
            LOGGER.error("An error occurred while trying to process redirection rules ", e);
            return null;
        }
    }

    public String getTestAuthnRequest(MoIDPConfig idpConfig) {
        try {
            LOGGER.debug("Creating Authentication Request.");
            MoSAMLUtils.doBootstrap();
            AuthnRequest authnRequest = MoSAMLUtils.buildAuthnRequest(this.settings.getBaseUrl(), this.settings.getLoginServletUrl(), idpConfig.getSsoUrl(), idpConfig.getNameIdFormat(), idpConfig.getForceAuthentication(), idpConfig.getEnablePassiveSso());
            if (idpConfig.getSignedRequest().booleanValue() && StringUtils.equals((CharSequence)idpConfig.getSsoBindingType(), (CharSequence)"HttpPost")) {
                authnRequest = (AuthnRequest)MoSAMLUtils.signHttpPostRequest(authnRequest, this.settings.getPublicSPCertificate(), this.settings.getPrivateSPCertificate());
            }
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(authnRequest);
            Element authDOM = marshaller.marshall(authnRequest);
            Document doc = authDOM.getOwnerDocument();
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            String requestMessage = ((Object)out).toString();
            return requestMessage;
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while creating the AuthnRequest.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
    }

    private String matchUserDomain(BambooUser user, String username, JSONObject rule) throws JSONException {
        if (user != null) {
            username = user.getEmail();
        }
        String domain = username.substring(username.indexOf("@") + 1);
        JSONObject condition = rule.getJSONObject("condition");
        JSONObject domainObject = condition.getJSONObject("domain");
        String conditionOperation = domainObject.getString("conditionOperation");
        LOGGER.debug("conditionOperation " + conditionOperation);
        String ruleDomain = domainObject.getString(conditionOperation);
        LOGGER.debug("ruleDomain " + ruleDomain);
        switch (conditionOperation) {
            case "equals": {
                if (!StringUtils.equals((CharSequence)ruleDomain, (CharSequence)domain)) break;
                return rule.getString("idp");
            }
            case "regex": {
                LOGGER.debug("Domain regex =" + ruleDomain);
                if (!StringUtils.containsIgnoreCase((CharSequence)domain, (CharSequence)ruleDomain)) break;
                LOGGER.debug("Username matched configured regex");
                return rule.getString("idp");
            }
        }
        return null;
    }

    private String matchUserGroup(BambooUser user, JSONObject rule) throws JSONException {
        JSONObject condition = rule.getJSONObject("condition");
        JSONObject groupObect = condition.getJSONObject("group");
        String conditionOperation = groupObect.getString("conditionOperation");
        LOGGER.debug("conditionOperation " + conditionOperation);
        String ruleGroup = groupObect.getString(conditionOperation);
        LOGGER.debug("ruleGroup " + ruleGroup);
        switch (conditionOperation) {
            case "equals": {
                if (!this.userManager.isUserPresentInGroups(user.getName(), Collections.singletonList(ruleGroup)).booleanValue()) break;
                return rule.getString("idp");
            }
            case "regex": {
                List<String> userGroups = this.userManager.getUserGroupName(user.getName());
                for (String userGroup : userGroups) {
                    if (!StringUtils.containsIgnoreCase((CharSequence)userGroup, (CharSequence)ruleGroup)) continue;
                    return rule.getString("idp");
                }
                break;
            }
        }
        return null;
    }

    private String matchUserDirectory(BambooUser bambooUser, JSONObject rule) throws JSONException {
        JSONObject condition = rule.getJSONObject("condition");
        LOGGER.debug("condition " + condition);
        JSONObject groupObect = condition.getJSONObject("directory");
        LOGGER.debug("groupObject " + groupObect);
        String conditionOperation = groupObect.getString("conditionOperation");
        LOGGER.debug("conditionOperation " + conditionOperation);
        String ruleDirectory = "";
        if (StringUtils.equals((CharSequence)conditionOperation, (CharSequence)"regex")) {
            LOGGER.debug("Under regex condition");
            ruleDirectory = groupObect.getString("regex");
        } else {
            LOGGER.debug("Under equals condition");
            ruleDirectory = groupObect.getString("equals");
        }
        LOGGER.debug("Rule Directory : " + ruleDirectory);
        User user = this.crowdService.getUser(bambooUser.getName());
        LOGGER.debug("Directory name : " + this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName());
        switch (conditionOperation) {
            case "equals": {
                if (!StringUtils.equals((CharSequence)ruleDirectory, (CharSequence)this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName())) break;
                return rule.getString("idp");
            }
            case "regex": {
                if (!StringUtils.containsIgnoreCase((CharSequence)this.crowdDirectoryService.findDirectoryById(user.getDirectoryId()).getName(), (CharSequence)ruleDirectory)) break;
                return rule.getString("idp");
            }
        }
        return null;
    }

    private String createHttpPostResponseForm(String ssoUrl, String encodedResponse, String relayState) {
        String form = "<html><head><script type=\"text/javascript\">window.onload = function() { document.forms['saml-request-form'].submit(); }</script></head><body>Please wait...<form action=\"" + ssoUrl + "\" method=\"post\" id=\"saml-request-form\"><input type=\"hidden\" name=\"SAMLResponse\" value=\"" + MoSAMLUtils.htmlEncode(encodedResponse) + "\" /><input type=\"hidden\" name=\"RelayState\" value=\"" + MoSAMLUtils.htmlEncode(relayState) + "\" /></form></body></html>";
        return form;
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        LOGGER.debug("Redirecting user to " + redirectUrl);
        response.sendRedirect(redirectUrl);
    }

    public String formatXML(String xml) {
        String responseMessage = xml;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            StringWriter out = new StringWriter();
            tf.transform(new DOMSource(doc), new StreamResult(out));
            responseMessage = ((Object)out).toString();
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while parsing the response.", t);
            throw new MoSAMLException(MoSAMLException.SAMLErrorCode.UNKNOWN);
        }
        return responseMessage;
    }

    public static String getIssuerFromResponse(HttpServletRequest request) throws ConfigurationException {
        MoSAMLUtils.doBootstrap();
        String encodedSAMLResponse = request.getParameter("SAMLResponse");
        try {
            Response samlResponse = MoSAMLUtils.decodeResponse(encodedSAMLResponse);
            return samlResponse.getIssuer().getValue();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while extracting issuer from SAML Response", e);
            return null;
        }
    }

    public String getSPEntityID(MoIDPConfig idpConfig) {
        try {
            return idpConfig.getCustomSPEntityID().isEmpty() ? this.settings.getSpEntityId() : idpConfig.getCustomSPEntityID();
        }
        catch (Exception e) {
            return this.settings.getSpEntityId();
        }
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoSAMLUserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(MoSAMLUserManager userManager) {
        this.userManager = userManager;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

