/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.bamboo.MoPluginConstants;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.MoSAMLUserManager;
import com.miniorange.sso.saml.bamboo.schedulers.MoMetadataJobRunnerImpl;
import com.miniorange.sso.saml.dto.MoIDPConfig;
import com.miniorange.sso.saml.dto.MoIDPMetadata;
import com.miniorange.sso.saml.utils.MoHttpUtils;
import com.miniorange.sso.saml.utils.MoJSONUtils;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoPluginHandler.class);
    private static MoSAMLSettings settings;
    private static MoPluginConfigurationsHandler moPluginConfigurationsHandler;
    static MoMetadataJobRunnerImpl metadataJobRunnerImpl;
    public static DirectoryManager directoryManager;
    private UserManager userManager;

    public MoPluginHandler(MoSAMLSettings settings, MoPluginConfigurationsHandler moPluginConfigurationsHandler, MoMetadataJobRunnerImpl metadataJobRunnerImpl, DirectoryManager directoryManager, UserManager userManager) {
        MoPluginHandler.settings = settings;
        MoPluginHandler.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
        MoPluginHandler.metadataJobRunnerImpl = metadataJobRunnerImpl;
        MoPluginHandler.directoryManager = directoryManager;
        this.userManager = userManager;
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    private static Boolean isJSONString(String string) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.readTree(string);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void saveIdPConfiguration(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, String sloResponseLocationUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, Boolean enableSsoForIdp) {
        LOGGER.debug("saveIdPConfiguration Saving IDP Info, EntityID: " + idpEntityId);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            settings.setIdpName(MoSAMLUtils.sanitizeText(idpName));
            settings.setIdpEntityId(MoSAMLUtils.sanitizeText(idpEntityId));
            settings.setSsoServiceUrl(MoSAMLUtils.sanitizeText(ssoUrl));
            settings.setSsoBindingType(ssoBinding);
            settings.setSloServiceUrl(MoSAMLUtils.sanitizeText(sloUrl));
            settings.setSloResponseLocationUrl(MoSAMLUtils.sanitizeText(sloResponseLocationUrl));
            settings.setSloBindingType(sloBinding);
            settings.setNameIdFormat(nameIdFormat);
            if (x509Certificate != null) {
                settings.setX509Certificate(x509Certificate);
            } else {
                settings.setX509Certificate(x509AllCertificates.get(0));
            }
            settings.setAllX509Certificates(x509AllCertificates);
            settings.setSignedRequest(signedRequest);
            settings.setNameIdFormat(nameIdFormat);
        } else {
            JSONObject idpConfigObj = MoPluginHandler.constructIdpConfig(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, sloResponseLocationUrl, x509AllCertificates, x509Certificate, signedRequest, nameIdFormat, enableSsoForIdp);
            LOGGER.debug("saveIdPConfigurations idpConfigObj: " + idpConfigObj.toString() + "sloresponselocationurl " + sloResponseLocationUrl);
            HashMap<String, String> idpMap = settings.getIdpMap();
            ArrayList<String> idpList = settings.getIdPList();
            HashMap<String, String> issuerMap = settings.getIssuerMap();
            ArrayList<String> ssoEnabledForIdPList = settings.getSsoEnabledForIdPList();
            LOGGER.debug("Before Saving IDP Map: " + idpMap.toString());
            idpMap.put(idpID, idpName);
            issuerMap.put(idpID, idpEntityId);
            LOGGER.debug("After saving IDP Map: " + idpMap.toString());
            if (!idpList.contains(idpID)) {
                MoPluginHandler.saveDefaultAttributeAndGroupMapping(idpID);
                MoPluginHandler.saveDefaultAdvancedSSOSetting(idpID);
                idpList.add(idpID);
                ssoEnabledForIdPList.add(idpID);
            } else if (settings.checkIfTestConfig(idpID)) {
                try {
                    JSONObject existingConfigObj = settings.getIdpConfig(idpID);
                    JSONObject testConfigObject = (JSONObject)existingConfigObj.get("testConfig");
                    idpConfigObj.put("testConfig", testConfigObject);
                }
                catch (Exception e) {
                    LOGGER.debug("Existing idpConfig Object not found");
                }
            }
            settings.setIdpMap(idpMap);
            settings.setIssuerMap(issuerMap);
            settings.setIdPList(idpList);
            settings.setSsoEnabledForIdPList(ssoEnabledForIdPList);
            LOGGER.debug("After Saving" + settings.getIdpMap().toString());
            settings.setIdpConfig(idpConfigObj, idpID);
        }
    }

    public static void saveSPConfiguration(String spBaseUrl, String spEntityId) {
        LOGGER.debug("saveSPConfiguration Saving SP Info, SPBaseUrl: " + spBaseUrl + ", SPEntityID: " + spEntityId);
        settings.setSpBaseUrl(StringUtils.stripEnd((String)MoSAMLUtils.sanitizeText(spBaseUrl), (String)"/"));
        settings.setSpEntityId(StringUtils.stripEnd((String)MoSAMLUtils.sanitizeText(spEntityId), (String)"/"));
    }

    public static void saveCustomMetadata(String customOrganizationName, String customOrganizationDisplayName, String customOrganizationUrl, String technicalContactName, String technicalContactEmail, String supportContactName, String supportContactEmail) {
        LOGGER.debug("Saving Custom metadata - customOrganizationName:" + customOrganizationName + ",customOrganizationDisplayname:" + customOrganizationDisplayName + ",customOrganizationUrl:" + customOrganizationUrl + ",technicalContactName:" + technicalContactName + ",technicalContactEmail:" + technicalContactEmail + ",supportContactName:" + supportContactName + ",supportContactEmail:" + supportContactEmail);
        settings.setOrganizationName(customOrganizationName);
        settings.setOrganizationDisplayName(customOrganizationDisplayName);
        settings.setOrganizationUrl(customOrganizationUrl);
        settings.setTechnicalContactName(technicalContactName);
        settings.setTechnicalContactEmail(technicalContactEmail);
        settings.setSupportContactName(supportContactName);
        settings.setSupportContactEmail(supportContactEmail);
    }

    public static String getGroupNameFromRegex(Matcher matcher, String replaceWith) {
        LOGGER.debug("forming String According To Groupname and replaceWith");
        StringBuffer groupname = new StringBuffer("");
        try {
            String[] groupPositions;
            for (String position : groupPositions = StringUtils.split((String)replaceWith, (char)'$')) {
                LOGGER.debug("position " + position);
                LOGGER.debug("Group name " + matcher.group(Integer.parseInt(position.trim())));
                groupname.append(matcher.group(Integer.parseInt(position.trim())));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while applying regex on username. Kindly check Regex configuration.", e);
        }
        return groupname.toString();
    }

    public static void saveSPCertificates(Boolean signing, Boolean encryption) {
        LOGGER.debug("saveSPCertificates Saving SP Info, Signing: " + signing + ", Encryption: " + encryption);
        settings.setSigning(signing);
        settings.setEncryption(encryption);
    }

    public static void saveSPCertificates(String publicCertificate, String privateCertificate) {
        LOGGER.debug("saveSPCertificates Saving certificates " + publicCertificate);
        settings.setPublicSPCertificate(MoSAMLUtils.serializePublicCertificate(publicCertificate));
        settings.setPrivateSPCertificate(MoSAMLUtils.serializePrivateCertificate(privateCertificate));
    }

    public static void saveAttributeMapping(String idpID, String usernameAttr, String emailAttr, String fullNameAttr, Boolean useSeparateNameAttribute, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String regexPattern, Boolean regexPatternEnabled, String loginUserAttribute) {
        LOGGER.debug("saveAttributeMapping Saving Attribute Mapping: UsernameAttr: " + usernameAttr + ", EmailAttr: " + emailAttr + ", NameAttr: " + fullNameAttr + ", useSeparateName: " + useSeparateNameAttribute + ", firstName: " + firstNameAttribute + ", lastName: " + lastNameAttribute + ", keepExistingUserAttributes " + keepExistingUserAttributes + ", regexPattern: " + regexPattern + ", regexPatternEnabled: " + regexPatternEnabled + ", loginUserAttribute: " + loginUserAttribute);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            settings.setLoginUserAttribute(loginUserAttribute);
            settings.setUsernameAttribute(MoSAMLUtils.sanitizeText(usernameAttr));
            settings.setEmailAttribute(MoSAMLUtils.sanitizeText(emailAttr));
            if (BooleanUtils.toBoolean((Boolean)useSeparateNameAttribute)) {
                settings.setFirstNameAttribute(MoSAMLUtils.sanitizeText(firstNameAttribute));
                settings.setLastNameAttribute(MoSAMLUtils.sanitizeText(lastNameAttribute));
            } else {
                settings.setFullNameAttribute(MoSAMLUtils.sanitizeText(fullNameAttr));
            }
            settings.setRegexPatternEnabled(BooleanUtils.toBoolean((Boolean)regexPatternEnabled));
            if (BooleanUtils.toBoolean((Boolean)regexPatternEnabled)) {
                settings.setRegexPattern(MoSAMLUtils.sanitizeText(regexPattern));
            }
            settings.setKeepExistingUserAttributes(keepExistingUserAttributes);
            settings.setUseSeparateNameAttributes(BooleanUtils.toBoolean((Boolean)useSeparateNameAttribute));
        } else {
            JSONObject attributeConfig = MoPluginHandler.constructAttributeConfig(usernameAttr, emailAttr, fullNameAttr, useSeparateNameAttribute, firstNameAttribute, lastNameAttribute, keepExistingUserAttributes, regexPattern, regexPatternEnabled, loginUserAttribute);
            settings.setAttributeMappingConfig(attributeConfig, idpID);
        }
    }

    public static void saveBackdoorValues(String backdoorKey, String backdoorValue) {
        LOGGER.debug("saveBackdoorValues backdoorKey= " + backdoorKey + ", backdoorValue= " + backdoorValue);
        settings.setBackdoorKey(backdoorKey);
        settings.setBackdoorValue(backdoorValue);
    }

    public static void saveSigninSettings(Boolean disableDefaultLogin, Boolean enableBackdoor, String loginButtonText, String relayState, String relayStateRedirectionType, String customLogoutURL, Boolean enablelogoutTemplate, String timeDelay, String logoutTemplate, Boolean enableErrorMsgTemplate, String errorMsgTemplate, Boolean enableSAMLSSO, Boolean enableAutoRedirectDelay, String numberOfLoginAttempts, Boolean restrictBackdoor, List<String> backdoorGroupsList, Boolean enableLoginTemplate, String loginTemplate, Boolean enableRememberMeCookie, Boolean enablePasswordChange, Boolean headerAuthentication, String headerAuthenticationAttribute, Boolean pluginApiAccessRestriction) {
        LOGGER.debug("Saving the Sign in Settings : disableDefaultLogin: " + disableDefaultLogin + ", enableBackdoor: " + enableBackdoor + ", LoginButtonText: " + loginButtonText + " timeDelay: " + timeDelay + ",enableSAMLSSO :" + enableSAMLSSO + " enableLoginTemplate: " + enableLoginTemplate + " numberOfLoginAttempts: " + numberOfLoginAttempts + " enableRememberMeCookie: " + enableRememberMeCookie + " headerAuthentication: " + headerAuthentication + " headerAuthenticationAttribute: " + headerAuthenticationAttribute + " pluginApiAccessRestriction : " + pluginApiAccessRestriction);
        settings.setDefaultLoginDisabled(BooleanUtils.toBoolean((Boolean)disableDefaultLogin));
        settings.setBackdoorEnabled(BooleanUtils.toBoolean((Boolean)enableBackdoor));
        settings.setLoginButtonText(MoSAMLUtils.sanitizeText(loginButtonText));
        settings.setRelayState(MoSAMLUtils.sanitizeText(relayState));
        settings.setRelayStateRedirectionType(relayStateRedirectionType);
        settings.setTimeDelay(timeDelay);
        settings.setEnableLogoutTemplate(BooleanUtils.toBoolean((Boolean)enablelogoutTemplate));
        if (pluginApiAccessRestriction == null) {
            pluginApiAccessRestriction = false;
        }
        settings.setPluginApiAccessRestriction(BooleanUtils.toBoolean((Boolean)pluginApiAccessRestriction));
        if (!BooleanUtils.toBoolean((Boolean)enablelogoutTemplate)) {
            settings.setCustomLogoutURL(MoSAMLUtils.sanitizeText(customLogoutURL));
        } else {
            settings.setCustomLogoutURL("");
        }
        settings.setLogoutTemplate(logoutTemplate);
        settings.setEnableErrorMsgTemplate(BooleanUtils.toBoolean((Boolean)enableErrorMsgTemplate));
        settings.setErrorMsgTemplate(errorMsgTemplate);
        settings.setEnableSAMLSSO(BooleanUtils.toBoolean((Boolean)enableSAMLSSO));
        settings.setEnableAutoRedirectDelay(enableAutoRedirectDelay);
        settings.setNumberOfLoginAttempts(numberOfLoginAttempts);
        settings.setRestrictBackdoor(restrictBackdoor);
        settings.setBackdoorGroups(backdoorGroupsList);
        settings.setEnableLoginTemplate(enableLoginTemplate);
        settings.setLoginTemplate(loginTemplate);
        settings.setRememberMeCookieEnabled(enableRememberMeCookie);
        settings.setEnablePasswordChange(enablePasswordChange);
        settings.setHeaderAuthenticationSettings(BooleanUtils.toBoolean((Boolean)headerAuthentication));
        settings.setHeaderAuthenticationAttribute(headerAuthenticationAttribute);
    }

    public static void saveRoleMapping(String idpID, String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, String defaultGroup, List<String> defaultGroupList, Boolean restrictUserCreation, String enableDefaultGroupsFor, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroupsList, Boolean onTheFlyAssignNewGroupsOnly, Boolean createNewGroups, Boolean groupRegexPatternEnabled, String regexPatternForGroup, String regexGroups, String testRegex) {
        LOGGER.info("Saving Group Mapping Configuration ");
        LOGGER.debug("roleAttribute = " + roleAttribute + " createUsersIfRoleMapped = " + createUsersIfRoleMapped + " keepExistingUserRoles = " + keepExistingUserRoles + " roleMapping = " + roleMapping + " defaultGroup = " + defaultGroup + " defaultGroupList = " + defaultGroupList + " restrictUserCreation = " + restrictUserCreation + " enableDefaultGroupsFor = " + enableDefaultGroupsFor + " onTheFlyGroupCreation = " + onTheFlyGroupCreation + " onTheFlyDoNotRemoveGroupsList = " + onTheFlyDoNotRemoveGroupsList + " onTheFlyAssignNewGroupsOnly = " + onTheFlyAssignNewGroupsOnly + "createNewGroups = " + createNewGroups + " groupRegexPatternEnabled = " + groupRegexPatternEnabled + " regexPatternForGroup = " + regexPatternForGroup + " regexGroups " + regexGroups + " testRegex " + testRegex);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            settings.setRoleAttribute(MoSAMLUtils.sanitizeText(roleAttribute));
            settings.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
            settings.setKeepExistingUserRoles(BooleanUtils.toBoolean((Boolean)keepExistingUserRoles));
            settings.setRoleMapping(roleMapping);
            settings.setRestrictUserCreation(restrictUserCreation);
            settings.setEnableDefaultGroupsFor(enableDefaultGroupsFor);
            settings.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
            settings.setDefaultGroup(defaultGroup);
            settings.setDefaultGroups(defaultGroupList);
            settings.setOnTheFlyGroupMapping(onTheFlyGroupCreation);
            if (BooleanUtils.toBoolean((Boolean)onTheFlyGroupCreation)) {
                settings.setOnTheFlyDoNotRemoveGroups(onTheFlyDoNotRemoveGroupsList);
                settings.setOnTheFlyAssignNewGroupsOnly(onTheFlyAssignNewGroupsOnly);
                settings.setCreateNewGroups(createNewGroups);
                settings.setGroupRegexPatternEnabled(groupRegexPatternEnabled);
                settings.setRegexPatternForGroup(regexPatternForGroup);
                settings.setRegexGroups(regexGroups);
                settings.setTestRegex(testRegex);
            }
        } else {
            JSONObject groupMappingObject = MoPluginHandler.constructGroupMappingConfigObj(roleAttribute, createUsersIfRoleMapped, keepExistingUserRoles, roleMapping, defaultGroup, defaultGroupList, restrictUserCreation, enableDefaultGroupsFor, onTheFlyGroupCreation, onTheFlyDoNotRemoveGroupsList, onTheFlyAssignNewGroupsOnly, createNewGroups, groupRegexPatternEnabled, regexPatternForGroup, regexGroups, testRegex);
            LOGGER.debug("[saveRoleMapping] Group Mapping Config " + groupMappingObject.toString());
            settings.setGroupMappingConfig(groupMappingObject, idpID);
        }
    }

    public static void saveAdvancedOption(String idpID, Boolean allowUserCreation, Boolean forceAuthentication, String url, String timeDelay, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit, String relayState, String relayStateRedirectionType, Boolean enablePassiveSso, String customSPEntityID) {
        settings.setAllowUserCreation(allowUserCreation);
        settings.setForceAuthentication(forceAuthentication);
        settings.setTimeDelay(timeDelay);
        settings.setEnablePassiveSso(enablePassiveSso);
        if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
            if (BooleanUtils.toBoolean((Boolean)refreshMetadata)) {
                MoPluginHandler.saveImportMetadata(idpID, StringUtils.trim((String)url), StringUtils.trim((String)url), refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit, customSPEntityID);
            } else {
                MoPluginHandler.saveImportMetadata(idpID, url, url, false, "hourly", 60, "minutes", customSPEntityID);
            }
        } else {
            JSONObject advancedSSOConfig = MoPluginHandler.constructAdvancedSSOConfig(allowUserCreation, forceAuthentication, url, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit, relayState, relayStateRedirectionType, timeDelay, enablePassiveSso, customSPEntityID);
            settings.setAdvancedSSOConfig(advancedSSOConfig, idpID);
        }
        MoPluginHandler.toggleSchedulerService(idpID);
    }

    public Map<String, String> getIdpGuides() {
        TreeMap<String, String> idp = new TreeMap<String, String>();
        for (MoPluginConstants.idpGuides idpGuide : MoPluginConstants.idpGuides.values()) {
            idp.put(idpGuide.name(), idpGuide.getKey());
        }
        return idp;
    }

    private static JSONObject constructAdvancedSSOConfig(Boolean allowUserCreation, Boolean forceAuthentication, String url, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit, String relayState, String relayStateRedirectionType, String timeDelay, Boolean enablePassiveSso, String customSPEntityID) {
        JSONObject advancedSSOConfigObj = new JSONObject();
        try {
            advancedSSOConfigObj.put("miniorange.saml.ALLOW_USER_CREATION", BooleanUtils.toBoolean((Boolean)allowUserCreation));
            advancedSSOConfigObj.put("miniorange.saml.FORCE_AUTHENTICATION", BooleanUtils.toBoolean((Boolean)forceAuthentication));
            advancedSSOConfigObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)url, (CharSequence)""));
            advancedSSOConfigObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBoolean((Boolean)refreshMetadata));
            advancedSSOConfigObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            advancedSSOConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            advancedSSOConfigObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
            advancedSSOConfigObj.put("miniorange.saml.RELAY_STATE", StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)relayState, (CharSequence)""))));
            advancedSSOConfigObj.put("miniorange.saml.RELAY_STATE_REDIRECTION_TYPE", StringUtils.defaultIfBlank((CharSequence)relayStateRedirectionType, (CharSequence)"forceRedirect"));
            advancedSSOConfigObj.put("miniorange.saml.TIME_DELAY", StringUtils.defaultIfBlank((CharSequence)timeDelay, (CharSequence)"01"));
            advancedSSOConfigObj.put("miniorange.saml.ENABLE_PASSIVE_SSO", BooleanUtils.toBoolean((Boolean)enablePassiveSso));
            advancedSSOConfigObj.put("miniorange.saml.CUSTOM_SP_ENTITY_ID", StringUtils.defaultIfBlank((CharSequence)customSPEntityID, (CharSequence)""));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing Advanced SSO configurations", e);
        }
        return advancedSSOConfigObj;
    }

    private static void insertAdvancedSSOConfig(MoIDPConfig idpConfig, JSONObject importAdvancedSSOConfig) {
        if (importAdvancedSSOConfig != null) {
            idpConfig.setAllowUserCreation(importAdvancedSSOConfig.optBoolean("miniorange.saml.ALLOW_USER_CREATION", true));
            idpConfig.setForceAuthentication(importAdvancedSSOConfig.optBoolean("miniorange.saml.FORCE_AUTHENTICATION", false));
            idpConfig.setRefreshMetadata(importAdvancedSSOConfig.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setInputUrl(importAdvancedSSOConfig.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setRefreshInterval(importAdvancedSSOConfig.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(importAdvancedSSOConfig.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(importAdvancedSSOConfig.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
            idpConfig.setRelayState(importAdvancedSSOConfig.optString("miniorange.saml.RELAY_STATE", ""));
            idpConfig.setRelayStateRedirectionType(importAdvancedSSOConfig.optString("miniorange.saml.RELAY_STATE_REDIRECTION_TYPE", "forceRedirect"));
            idpConfig.setTimeDelay(importAdvancedSSOConfig.optString("miniorange.saml.TIME_DELAY", "01"));
            idpConfig.setEnablePassiveSso(importAdvancedSSOConfig.optBoolean("miniorange.saml.ENABLE_PASSIVE_SSO", false));
            idpConfig.setCustomSPEntityID(importAdvancedSSOConfig.optString("miniorange.saml.CUSTOM_SP_ENTITY_ID", ""));
        } else {
            idpConfig.setAllowUserCreation(Boolean.TRUE);
            idpConfig.setForceAuthentication(Boolean.FALSE);
            idpConfig.setRefreshMetadata(Boolean.FALSE);
            idpConfig.setInputUrl("");
            idpConfig.setRefreshInterval("hourly");
            idpConfig.setCustomRefreshInterval(60);
            idpConfig.setCustomRefreshIntervalUnit("minutes");
            idpConfig.setRelayState("");
            idpConfig.setRelayStateRedirectionType("forceRedirect");
            idpConfig.setTimeDelay("01");
            idpConfig.setEnablePassiveSso(Boolean.FALSE);
            idpConfig.setCustomSPEntityID("");
        }
    }

    public static void submitSupportQuery(String email, String phone, String query) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("company", settings.getSpBaseUrl());
            jsonObject.put("email", email);
            jsonObject.put("phone", phone);
            jsonObject.put("query", StringUtils.prependIfMissing((String)query, (CharSequence)"[Bamboo SAML SSO Plugin] ", (CharSequence[])new CharSequence[0]));
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://auth.miniorange.com/moas/rest/customer/contact-us", json, "application/json", MoPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            LOGGER.debug("Submit Query response: " + response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details.", e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "An error occurred while saving your details. Please check logs for more info.", e);
        }
    }

    public void setSettings(MoSAMLSettings settings) {
        MoPluginHandler.settings = settings;
    }

    public MoMetadataJobRunnerImpl getMoJobRunnerImpl() {
        return metadataJobRunnerImpl;
    }

    public static void saveCustomTemplate(String errorMsgTemplate, String logoutTemplate, Boolean enableErrorMsgTemplate) {
        LOGGER.info("Saving Custom Template");
        settings.setErrorMsgTemplate(StringUtils.trimToEmpty((String)errorMsgTemplate));
        settings.setLogoutTemplate(StringUtils.trimToEmpty((String)logoutTemplate));
        settings.setEnableErrorMsgTemplate(enableErrorMsgTemplate);
    }

    public static void uploadMetadata(String idpID, String idpName, File xmlFile, String metadataOption) {
        LOGGER.debug("uploadMetadata called ");
        try {
            String metadata = IOUtils.toString((InputStream)new FileInputStream(xmlFile));
            LOGGER.debug("Metadata String from file = " + metadata);
            MoPluginHandler.configureFromMetadata(idpID, idpName, metadata, false);
            MoPluginHandler.saveMetadataOption(idpID, metadataOption);
            MoPluginHandler.saveAdvancedOption(idpID, true, false, "", "", false, "hourly", 60, "minutes", "", "forceRedirect", false, "");
            MoPluginHandler.toggleSchedulerService(idpID);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while parsing IDP Metadata XML.");
            LOGGER.error(MoPluginException.PluginErrorCode.METADATA_PARSE.getMessage(), e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.METADATA_PARSE, e.getMessage(), e);
        }
    }

    public static void saveMetadataOption(String idpID, String metadataOption) {
        LOGGER.info("Saving Metadata Options");
        settings.setMetadataOption(idpID, metadataOption);
    }

    public static void fetchMetadata(String idpID, String idpName, String metadataUrlString, String effectiveUrl, String metadataOption) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)effectiveUrl)) {
            String metadata = MoHttpUtils.sendGetRequest(effectiveUrl);
            MoPluginHandler.configureFromMetadata(idpID, idpName, metadata, false);
        }
        settings.setMetadataOption(idpID, metadataOption);
        MoPluginHandler.saveAdvancedOption(idpID, true, false, effectiveUrl, "", false, "hourly", 60, "minutes", "", "forceRedirect", false, "");
        MoPluginHandler.toggleSchedulerService(idpID);
    }

    public static void savePostLogoutSettings(String customLogoutURL, Boolean enableLogoutTemplate, String logoutTemplate) {
        LOGGER.info("Saving Post Logout Settings Configuration");
        settings.setCustomLogoutURL(customLogoutURL);
        settings.setLogoutTemplate(logoutTemplate);
        settings.setEnableLogoutTemplate(enableLogoutTemplate);
    }

    public void saveHeaderBasedAuthSettings(Boolean headerAuthentication, String headerAuthenticationAttribute) {
        settings.setHeaderAuthenticationSettings(headerAuthentication);
        settings.setHeaderAuthenticationAttribute(headerAuthenticationAttribute);
    }

    public static void toggleSchedulerService(String idpID) {
        try {
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
            if (idpConfig != null) {
                if (BooleanUtils.toBoolean((Boolean)idpConfig.getRefreshMetadata())) {
                    int interval = MoSAMLUtils.getMetadataRefreshInterval(idpConfig.getRefreshInterval(), idpConfig.getCustomRefreshInterval(), idpConfig.getCustomRefreshIntervalUnit());
                    metadataJobRunnerImpl.schedule(interval, idpConfig);
                } else {
                    metadataJobRunnerImpl.deleteSchedule(idpID);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while scheduling metadata refresh: " + e.getMessage());
        }
    }

    public static void configureFromMetadata(String idpID, String idpName, String metadata, Boolean isRefreshTask) {
        metadata = metadata.replaceAll("[^\\x20-\\x7e]", "");
        MoIDPMetadata idpMetadata = new MoIDPMetadata(metadata);
        String idpEntityId = idpMetadata.getEntityId();
        String ssoBinding = "HttpRedirect";
        String ssoUrl = "";
        String sloBinding = "HttpRedirect";
        String sloUrl = "";
        String sloResponseLocationUrl = "";
        String nameIdFormat = "";
        Boolean isRequestSigned = Boolean.TRUE;
        Boolean enableSsoForIdp = Boolean.TRUE;
        if (!BooleanUtils.toBoolean((Boolean)isRefreshTask)) {
            nameIdFormat = (String)StringUtils.defaultIfBlank((CharSequence)MoIDPMetadata.nameIdFormat, (CharSequence)"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            if (idpMetadata.getSingleSignOnServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                ssoBinding = "HttpRedirect";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            } else {
                ssoBinding = "HttpPost";
                ssoUrl = idpMetadata.getSingleSignOnServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            }
            if (idpMetadata.getSingleLogoutServices().size() > 0) {
                if (idpMetadata.getSingleLogoutServices().containsKey("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                    sloBinding = "HttpRedirect";
                    sloUrl = (String)idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect").get("location");
                    sloResponseLocationUrl = (String)idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect").get("responseLocation");
                } else {
                    sloBinding = "HttpPost";
                    sloUrl = (String)idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST").get("location");
                    sloResponseLocationUrl = (String)idpMetadata.getSingleLogoutServices().get("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST").get("responseLocation");
                }
            }
        } else {
            MoIDPConfig idpConfig = MoPluginHandler.constructIdpConfigObject(idpID);
            nameIdFormat = idpConfig.getNameIdFormat();
            ssoBinding = idpConfig.getSsoBindingType();
            ssoUrl = idpConfig.getSsoUrl();
            sloUrl = idpConfig.getSloUrl();
            sloResponseLocationUrl = idpConfig.getSloResponseLocationUrl();
            sloBinding = idpConfig.getSloBindingType();
            isRequestSigned = idpConfig.getSignedRequest();
            enableSsoForIdp = idpConfig.getEnableSsoForIdp();
        }
        String x509Certificate = idpMetadata.getSigningCertificates().get(0);
        List<String> x509AllCertificates = idpMetadata.getSigningCertificates();
        MoPluginHandler.saveIdPConfiguration(idpID, idpName, idpEntityId, ssoBinding, ssoUrl, sloBinding, sloUrl, sloResponseLocationUrl, x509AllCertificates, x509Certificate, isRequestSigned, nameIdFormat, enableSsoForIdp);
    }

    public static void importConfigurations(String pluginConfigurations) throws IOException {
        LOGGER.debug("Importing app's configuration from config file");
        try {
            LOGGER.debug("importConfigurations :  pluginConfigurations  = " + pluginConfigurations);
            MoPluginHandler.stopAllSchedulers();
            settings.clearOldConfiguration();
            settings.clearPluginSettings();
            moPluginConfigurationsHandler.importPluginConfigurations(pluginConfigurations);
        }
        catch (JSONException e) {
            LOGGER.error(e.getMessage());
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "Invalid file uploaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "An error occurred while saving the configuration.");
        }
    }

    public MoPluginConfigurationsHandler getMoPluginConfigurationsHandler() {
        return moPluginConfigurationsHandler;
    }

    public void setMoPluginConfigurationsHandler(MoPluginConfigurationsHandler moPluginConfigurationsHandler) {
        MoPluginHandler.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
    }

    public void setMetadataJobRunnerImpl(MoMetadataJobRunnerImpl metadataJobRunnerImpl) {
        MoPluginHandler.metadataJobRunnerImpl = metadataJobRunnerImpl;
    }

    public MoSAMLSettings getSettings() {
        return settings;
    }

    private static JSONObject constructIdpConfig(String idpID, String idpName, String idpEntityId, String ssoBinding, String ssoUrl, String sloBinding, String sloUrl, String sloResponseLocationUrl, List<String> x509AllCertificates, String x509Certificate, Boolean signedRequest, String nameIdFormat, Boolean enableSSOForIDP) {
        JSONObject idpConfigObj = new JSONObject();
        try {
            idpConfigObj.put("miniorange.saml.IDP_ID", idpID);
            idpConfigObj.put("miniorange.saml.IDP_NAME", StringUtils.trimToEmpty((String)MoSAMLUtils.sanitizeText(idpName)));
            idpConfigObj.put("miniorange.saml.IDP_ENTITY_ID", StringUtils.trimToEmpty((String)MoSAMLUtils.sanitizeText(idpEntityId)));
            idpConfigObj.put("miniorange.saml.SSO_URL", StringUtils.trimToEmpty((String)MoSAMLUtils.sanitizeText(ssoUrl)));
            idpConfigObj.put("miniorange.saml.SLO_URL", StringUtils.trimToEmpty((String)MoSAMLUtils.sanitizeText(sloUrl)));
            idpConfigObj.put("miniorange.saml.SLO_RESPONSE_LOCATION_URL", StringUtils.trimToEmpty((String)sloResponseLocationUrl));
            idpConfigObj.put("miniorange.saml.SSO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)ssoBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.put("miniorange.saml.SLO_BINDING_TYPE", StringUtils.defaultIfBlank((CharSequence)sloBinding, (CharSequence)"HttpRedirect"));
            idpConfigObj.putOpt("miniorange.saml.X509_CERTIFICATE", StringUtils.trimToEmpty((String)Objects.toString(MoSAMLUtils.serializePublicCertificate(x509Certificate), "")));
            idpConfigObj.put("miniorange.saml.NAME_ID_FORMAT", StringUtils.trimToEmpty((String)nameIdFormat));
            idpConfigObj.put("miniorange.saml.ENABLE_SSO_FOR_IDP", BooleanUtils.toBooleanDefaultIfNull((Boolean)enableSSOForIDP, (boolean)true));
            idpConfigObj.put("miniorange.saml.SIGNED_REQUEST", BooleanUtils.toBooleanDefaultIfNull((Boolean)signedRequest, (boolean)false));
            for (String certificate : x509AllCertificates) {
                idpConfigObj.append("miniorange.saml.ALL_X509_CERTIFICATES", StringUtils.trimToEmpty((String)MoSAMLUtils.serializePublicCertificate(certificate)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(e.getMessage());
        }
        return idpConfigObj;
    }

    public static MoIDPConfig constructIdpConfigObject(String idpID) {
        LOGGER.debug("constructIdPConfigObject called");
        MoIDPConfig idpConfig = null;
        try {
            if (StringUtils.equals((CharSequence)idpID, (CharSequence)"miniorange.saml.DEFAULT_IDP_ID")) {
                JSONObject idpConfigObj = MoPluginHandler.constructIdpConfig(idpID, "IDP", settings.getIdpEntityId(), settings.getSsoBindingType(), settings.getSsoServiceUrl(), settings.getSloBindingType(), settings.getSloServiceUrl(), settings.getSloResponseLocationUrl(), (List)settings.getAllX509Certificates(), settings.getX509Certificate(), settings.getSignedRequest(), settings.getNameIdFormat(), settings.getEnableSsoForIdp());
                if (idpConfigObj != null) {
                    JSONObject advancedSettings;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new MoIDPConfig();
                    MoPluginHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = MoPluginHandler.constructAttributeConfig(settings.getUsernameAttribute(), settings.getEmailAttribute(), settings.getFullNameAttribute(), settings.getUseSeparateNameAttributes(), settings.getFirstNameAttribute(), settings.getLastNameAttribute(), settings.getKeepExistingUserAttributes(), settings.getRegexPattern(), settings.getRegexPatternEnabled(), settings.getLoginUserAttribute());
                    if (attributeMappingConfigObj != null) {
                        MoPluginHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = MoPluginHandler.constructGroupMappingConfigObj(settings.getRoleAttribute(), settings.getCreateUsersIfRoleMapped(), settings.getKeepExistingUserRoles(), settings.getRoleMapping(), settings.getDefaultGroup(), (List)settings.getDefaultGroups(), settings.getRestrictUserCreation(), settings.getEnableDefaultGroupsFor(), settings.getOnTheFlyGroupMapping(), (List)settings.getOnTheFlyDoNotRemoveGroups(), settings.getOnTheFlyAssignNewGroupsOnly(), settings.getCreateNewGroups(), settings.getGroupRegexPatternEnabled(), settings.getRegexPatternForGroup(), settings.getRegexPattern(), settings.getTestRegex())) != null) {
                        MoPluginHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj);
                    }
                    if ((advancedSettings = settings.getAdvancedSSOConfig(idpID)) != null) {
                        MoPluginHandler.insertAdvancedSSOConfig(idpConfig, advancedSettings);
                    }
                    idpConfig.setMetadataOption(settings.getMetadataOption(idpID));
                    JSONObject importMetadataConfigObj = MoPluginHandler.constructImportMetadataObj(settings.getInputMetadataUrl(), settings.getIdpMetadataURL(), settings.getRefreshMetadata(), settings.getRefreshInterval(), settings.getCustomRefreshInterval(), settings.getCustomRefreshIntervalUnit(), "");
                    MoPluginHandler.insertImportMetadataConfig(idpConfig, importMetadataConfigObj);
                }
            } else {
                LOGGER.debug("[constructIdPConfigObject]IDP ID: " + idpID);
                JSONObject idpConfigObj = settings.getIdpConfig(idpID);
                if (idpConfigObj != null) {
                    JSONObject advancedSettings;
                    JSONObject groupMappingConfigObj;
                    idpConfig = new MoIDPConfig();
                    MoPluginHandler.insertIDPConfig(idpConfig, idpConfigObj);
                    JSONObject attributeMappingConfigObj = settings.getAttributeMappingConfig(idpID);
                    if (attributeMappingConfigObj != null) {
                        MoPluginHandler.insertAttributeMappingConfig(idpConfig, attributeMappingConfigObj);
                    }
                    if ((groupMappingConfigObj = settings.getGroupMappingConfig(idpID)) != null) {
                        MoPluginHandler.insertGroupMappingConfig(idpConfig, groupMappingConfigObj);
                    }
                    if ((advancedSettings = settings.getAdvancedSSOConfig(idpID)) != null) {
                        MoPluginHandler.insertAdvancedSSOConfig(idpConfig, advancedSettings);
                    }
                    idpConfig.setMetadataOption(settings.getMetadataOption(idpID));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOGGER.error("An exception occurred while initializing IDP Configurations " + t.getMessage());
        }
        return idpConfig;
    }

    public static void saveAdvancedRedirectionSettings(Boolean enableAutoRedirectDelay, Boolean enableBackdoor, Boolean restrictBackdoor, List<String> backdoorGroupsList, String numberOfLoginAttempts, List<String> noSSOUrls) {
        settings.setEnableAutoRedirectDelay(enableAutoRedirectDelay);
        settings.setBackdoorEnabled(enableBackdoor);
        settings.setRestrictBackdoor(restrictBackdoor);
        settings.setBackdoorGroups(backdoorGroupsList);
        settings.setNumberOfLoginAttempts(numberOfLoginAttempts);
        settings.setNoSSOUrls(noSSOUrls);
    }

    public void saveBambooRedirectionRules(Map<String, String> bambooRedirectionRulesMap) {
        String bambooRedirectionRules = MoJSONUtils.convertMapToJSON(bambooRedirectionRulesMap);
        settings.setBambooRedirectionRulesMap(bambooRedirectionRules);
    }

    public static void saveRedirectionRules(String ruleName, String decisionFactor, String conditionOperation, String conditionValue, String idp) throws JSONException {
        JSONObject rule = new JSONObject();
        rule.put("name", ruleName);
        rule.put("idp", idp);
        JSONObject condition = new JSONObject();
        JSONObject value = new JSONObject();
        value.put("conditionOperation", conditionOperation);
        value.put(conditionOperation, conditionValue);
        condition.put("decisionFactor", decisionFactor);
        condition.put(decisionFactor, value);
        rule.put("condition", condition);
        settings.setRedirectionRule(rule.toString(), ruleName);
        String ruleExpression = MoPluginHandler.createExpression(decisionFactor, conditionOperation, conditionValue, idp);
        String bambooRedirectionRules = settings.getBambooRedirectionRuleJson();
        bambooRedirectionRules = MoJSONUtils.addKeyValue(bambooRedirectionRules, ruleName, ruleExpression);
        settings.setBambooRedirectionRulesMap(bambooRedirectionRules);
    }

    private static String createExpression(String decisionFactor, String conditionOperation, String conditionValue, String idp) {
        StringBuilder expression = new StringBuilder("<label><b>If user's</b></label> ");
        expression.append("<em>" + decisionFactor + "</em>");
        expression.append(" <label><b>" + MoPluginHandler.conditionDisplayValue(conditionOperation) + "</b></label> ");
        if (StringUtils.equals((CharSequence)decisionFactor, (CharSequence)"directory")) {
            try {
                if (!StringUtils.equalsIgnoreCase((CharSequence)conditionOperation, (CharSequence)"regex")) {
                    conditionValue = directoryManager.findDirectoryByName(conditionValue).getName();
                }
            }
            catch (DirectoryNotFoundException e) {
                LOGGER.error("Error Occurred while creating Rule Expression ", e);
            }
        }
        expression.append("<em>" + conditionValue + "</em> ");
        expression.append("<label><b>then redirect to</b></label> ");
        if (StringUtils.equalsIgnoreCase((CharSequence)idp, (CharSequence)"loginpage")) {
            expression.append("<em>Login Page</em>");
        } else {
            expression.append("<em>" + settings.getIdpMap().get(idp) + "</em>");
        }
        LOGGER.debug(expression.toString());
        return expression.toString();
    }

    public static String conditionDisplayValue(String conditionOperation) {
        LOGGER.debug("Condition Operation : " + conditionOperation);
        switch (conditionOperation) {
            case "equals": {
                return "equals";
            }
            case "regex": {
                return "contains";
            }
        }
        return null;
    }

    private static void insertIDPConfig(MoIDPConfig idpConfig, JSONObject idpConfigObj) {
        try {
            idpConfig.setId(idpConfigObj.optString("miniorange.saml.IDP_ID", ""));
            idpConfig.setIdpName(idpConfigObj.optString("miniorange.saml.IDP_NAME", ""));
            idpConfig.setIdpEntityId(idpConfigObj.optString("miniorange.saml.IDP_ENTITY_ID", ""));
            idpConfig.setSsoUrl(idpConfigObj.optString("miniorange.saml.SSO_URL", ""));
            idpConfig.setSsoBindingType(idpConfigObj.optString("miniorange.saml.SSO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setSloUrl(idpConfigObj.optString("miniorange.saml.SLO_URL", ""));
            idpConfig.setSloResponseLocationUrl(idpConfigObj.optString("miniorange.saml.SLO_RESPONSE_LOCATION_URL", ""));
            idpConfig.setSloBindingType(idpConfigObj.optString("miniorange.saml.SLO_BINDING_TYPE", "HttpRedirect"));
            idpConfig.setX509Certificate(idpConfigObj.optString("miniorange.saml.X509_CERTIFICATE", ""));
            JSONArray certificates = idpConfigObj.optJSONArray("miniorange.saml.ALL_X509_CERTIFICATES");
            ArrayList<String> x509AllCertificates = new ArrayList<String>();
            if (certificates != null) {
                for (int i = 0; i < certificates.length(); ++i) {
                    x509AllCertificates.add(certificates.getString(i));
                }
            }
            idpConfig.setCertificates(x509AllCertificates);
            idpConfig.setSignedRequest(idpConfigObj.optBoolean("miniorange.saml.SIGNED_REQUEST", true));
            idpConfig.setNameIdFormat(idpConfigObj.optString("miniorange.saml.NAME_ID_FORMAT", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            idpConfig.setEnableSsoForIdp(idpConfigObj.optBoolean("miniorange.saml.ENABLE_SSO_FOR_IDP", true));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating IDP configurations", e);
        }
    }

    public static Boolean isValidDomainMapping(String[] domains, Boolean useDomainMapping) {
        int count = 0;
        if (useDomainMapping != null && useDomainMapping.booleanValue()) {
            if (domains != null && domains.length > 0) {
                for (String domain : domains) {
                    if (StringUtils.isBlank((CharSequence)domain)) {
                        return false;
                    }
                    ++count;
                }
                if (domains.length == count) {
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public Boolean isValidDomainEntered(String[] domains, Boolean useDomainMapping) {
        int count = 0;
        if (useDomainMapping != null && useDomainMapping.booleanValue()) {
            if (domains != null && domains.length > 0) {
                for (String domain : domains) {
                    String[] subDomains;
                    if (StringUtils.isBlank((CharSequence)domain) && StringUtils.endsWith((CharSequence)domain, (CharSequence)";")) {
                        return false;
                    }
                    for (String subDomain : subDomains = domain.trim().split(";")) {
                        LOGGER.debug("Sub Domain name : " + subDomain);
                        if (this.isValidDomain(subDomain)) continue;
                        return false;
                    }
                    ++count;
                }
                if (domains.length == count) {
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isValidDomain(String domainName) {
        boolean ret = true;
        if ("".equals(domainName) || domainName == null) {
            ret = false;
        } else if (domainName.startsWith("-") || domainName.endsWith("-")) {
            ret = false;
        } else if (!domainName.contains(".")) {
            ret = false;
        } else if (StringUtils.endsWith((CharSequence)domainName.trim(), (CharSequence)".")) {
            ret = false;
        } else {
            for (String domainEleStr : domainName.split("\\.")) {
                if (!StringUtils.isEmpty((CharSequence)domainEleStr.trim()) && !StringUtils.isBlank((CharSequence)domainEleStr.trim())) continue;
                return false;
            }
            for (char eleChar : domainName.toCharArray()) {
                String charStr = String.valueOf(eleChar);
                if (".".equals(charStr) || "-".equals(charStr) || charStr.matches("[a-zA-Z]") || charStr.matches("[0-9]")) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static void saveListIDPConfigurations(String idpID, Boolean isChecked) {
        JSONObject idpConfigObj = settings.getIdpConfig(idpID);
        idpConfigObj.put("miniorange.saml.ENABLE_SSO_FOR_IDP", BooleanUtils.toBooleanDefaultIfNull((Boolean)isChecked, (boolean)false));
        settings.setIdpConfig(idpConfigObj, idpID);
        ArrayList<String> ssoEnabledForIdpList = settings.getSsoEnabledForIdPList();
        if (isChecked.booleanValue()) {
            ssoEnabledForIdpList.add(idpID);
        } else {
            ssoEnabledForIdpList.remove(idpID);
            if (StringUtils.equals((CharSequence)settings.getDefaultBambooIDP(), (CharSequence)idpID)) {
                settings.setDefaultBambooIDP("loginPage");
            }
        }
        LOGGER.debug("ssoEnabled IDPs: " + ssoEnabledForIdpList);
        settings.setSsoEnabledForIdPList(ssoEnabledForIdpList);
    }

    private static void saveDomainMapping(String[] domains) {
        HashMap<String, String> domainMapping = new HashMap<String, String>();
        ArrayList<String> idpList = settings.getIdPList();
        LOGGER.debug("idpList " + idpList.toString());
        LOGGER.debug("domains: " + Arrays.asList(domains).toString());
        for (int i = 0; i < domains.length; ++i) {
            String[] multipleDomains;
            if (!StringUtils.isNotBlank((CharSequence)domains[i])) continue;
            for (String domain : multipleDomains = domains[i].trim().split(";")) {
                if (domainMapping.containsKey(domain) && !StringUtils.equalsIgnoreCase((CharSequence)idpList.get(i), (CharSequence)domainMapping.get(domain))) {
                    throw new MoPluginException(MoPluginException.PluginErrorCode.SAVING_DETAILS, "Domain names must be unique");
                }
                domainMapping.put(StringUtils.trimToEmpty((String)domain), idpList.get(i));
            }
        }
        LOGGER.debug("Domain Mapping: " + domainMapping.toString());
        settings.setDomains(domains);
        settings.setDomainMapping(domainMapping);
    }

    public static JSONObject constructImportMetadataObj(String inputUrl, String idpMetadataUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit, String customSPEntityID) {
        JSONObject importMetadataObj = new JSONObject();
        try {
            importMetadataObj.put("miniorange.saml.INPUT_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)inputUrl, (CharSequence)""));
            importMetadataObj.put("miniorange.saml.IDP_METADATA_URL", StringUtils.defaultIfBlank((CharSequence)idpMetadataUrl, (CharSequence)""));
            importMetadataObj.put("miniorange.saml.REFRESH_METADATA", BooleanUtils.toBoolean((Boolean)refreshMetadata));
            importMetadataObj.put("miniorange.saml.METADATA_REFRESH_INTERVAL", StringUtils.defaultIfBlank((CharSequence)refreshInterval, (CharSequence)"hourly"));
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL", customRefreshInterval != null ? customRefreshInterval : 60);
            importMetadataObj.put("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", StringUtils.defaultIfBlank((CharSequence)customRefreshIntervalUnit, (CharSequence)"minutes"));
            importMetadataObj.put("miniorange.saml.CUSTOM_SP_ENTITY_ID", StringUtils.defaultIfBlank((CharSequence)customSPEntityID, (CharSequence)""));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            LOGGER.error("An error occurred while initializing import metadata configurations");
        }
        return importMetadataObj;
    }

    public static void saveImportMetadata(String idpID, String inputUrl, String idpMetadataUrl, Boolean refreshMetadata, String refreshInterval, Integer customRefreshInterval, String customRefreshIntervalUnit, String customSPEntityID) {
        LOGGER.info("Saving Configuration for Import Metadata");
        LOGGER.debug("inputUrl = " + inputUrl + " idpMetadataUrl = " + idpMetadataUrl + " refreshMetadata = " + refreshMetadata + "refreshInterval = " + refreshInterval + " customRefreshInterval = " + customRefreshInterval + " customRefreshIntervalUnit = " + customRefreshIntervalUnit + "customSPEntityID = " + customSPEntityID);
        JSONObject importMetadataObj = MoPluginHandler.constructImportMetadataObj(inputUrl, idpMetadataUrl, refreshMetadata, refreshInterval, customRefreshInterval, customRefreshIntervalUnit, customSPEntityID);
        settings.setImportMetadataConfig(importMetadataObj, idpID);
    }

    public static void saveLookAndFeelSettings(String loginButtonText, String errorMsgTemplate, Boolean enableErrorMsgTemplate, Boolean enableLoginTemplate, String loginTemplate, Boolean showLoginButtons, Boolean hideDefaultLogin) {
        LOGGER.info("Saving Look And Feel Configuration");
        settings.setLoginButtonText(loginButtonText);
        settings.setEnableLoginTemplate(enableLoginTemplate);
        settings.setLoginTemplate(loginTemplate);
        settings.setErrorMsgTemplate(StringUtils.trimToEmpty((String)errorMsgTemplate));
        settings.setEnableErrorMsgTemplate(enableErrorMsgTemplate);
        settings.setShowLoginButtons(showLoginButtons);
        settings.setHideDefaultLogin(hideDefaultLogin);
    }

    public static void saveGlobalSSOSettings(Boolean enableSAMLSSO, Boolean enablePasswordChange, Boolean autoActivateUser, Boolean pluginApiAccessRestriction, Boolean restrictDuplicateAssertion, String resetAssertionIDListInterval, int customResetInterval) {
        settings.setEnableSAMLSSO(enableSAMLSSO);
        settings.setEnablePasswordChange(enablePasswordChange);
        settings.setAutoActivateUser(autoActivateUser);
        settings.setPluginApiAccessRestriction(pluginApiAccessRestriction);
        settings.setRestrictDuplicateAssertion(restrictDuplicateAssertion);
        settings.setResetAssertionIDListInterval(resetAssertionIDListInterval);
        settings.setCustomResetInterval(customResetInterval);
        if (BooleanUtils.toBoolean((Boolean)restrictDuplicateAssertion)) {
            settings.setResetAssertionIDListInterval(resetAssertionIDListInterval);
            settings.setCustomResetInterval(customResetInterval);
            if (StringUtils.equals((CharSequence)resetAssertionIDListInterval, (CharSequence)settings.getResetAssertionIDListInterval())) {
                if (StringUtils.equals((CharSequence)resetAssertionIDListInterval, (CharSequence)"daily")) {
                    return;
                }
                if (customResetInterval == settings.getCustomResetInterval()) {
                    return;
                }
            }
        }
    }

    public static void replaceOldSettingsWithNew(String idpID, String idpName) throws Exception {
        if (settings.getIdPList().size() == 0) {
            MoSAMLUserManager.replaceOldSettingsWithNew(settings.getReplaceOldSettingWithNewUrl(), idpID, idpName);
        }
    }

    private static void insertImportMetadataConfig(MoIDPConfig idpConfig, JSONObject importMetadataConfigObj) {
        if (importMetadataConfigObj != null) {
            idpConfig.setRefreshMetadata(importMetadataConfigObj.optBoolean("miniorange.saml.REFRESH_METADATA", false));
            idpConfig.setRefreshInterval(importMetadataConfigObj.optString("miniorange.saml.METADATA_REFRESH_INTERVAL", "hourly"));
            idpConfig.setCustomRefreshInterval(importMetadataConfigObj.optInt("miniorange.saml.CUSTOM_REFRESH_INTERVAL", 60));
            idpConfig.setCustomRefreshIntervalUnit(importMetadataConfigObj.optString("miniorange.saml.CUSTOM_REFRESH_INTERVAL_UNIT", "minutes"));
            idpConfig.setInputUrl(importMetadataConfigObj.optString("miniorange.saml.INPUT_METADATA_URL", ""));
            idpConfig.setIdpMetadataUrl(importMetadataConfigObj.optString("miniorange.saml.IDP_METADATA_URL", ""));
        } else {
            idpConfig.setRefreshMetadata(Boolean.FALSE);
            idpConfig.setRefreshInterval("hourly");
            idpConfig.setCustomRefreshInterval(60);
            idpConfig.setCustomRefreshIntervalUnit("minutes");
            idpConfig.setInputUrl("");
            idpConfig.setIdpMetadataUrl("");
        }
    }

    private static JSONObject constructAttributeConfig(String usernameAttribute, String emailAttribute, String fullNameAttribute, Boolean useSeparateNameAttributes, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String regexPattern, Boolean regexPatternEnabled, String loginUserAttribute) {
        JSONObject attributeMappingConfigObj = new JSONObject();
        try {
            attributeMappingConfigObj.put("miniorange.saml.USERNAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(usernameAttribute), (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.EMAIL_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(emailAttribute), (CharSequence)"NameID"));
            attributeMappingConfigObj.put("miniorange.saml.ENABLE_REGEX_PATTERN", BooleanUtils.toBooleanDefaultIfNull((Boolean)regexPatternEnabled, (boolean)false));
            attributeMappingConfigObj.put("miniorange.saml.REGEX_PATTERN", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(regexPattern), (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserAttributes, (boolean)Boolean.FALSE));
            attributeMappingConfigObj.put("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE", BooleanUtils.toBooleanDefaultIfNull((Boolean)useSeparateNameAttributes, (boolean)false));
            attributeMappingConfigObj.put("miniorange.saml.FIRST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(firstNameAttribute), (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.LAST_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(lastNameAttribute), (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.FULL_NAME_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(fullNameAttribute), (CharSequence)""));
            attributeMappingConfigObj.put("miniorange.saml.LOGIN_USER_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(loginUserAttribute), (CharSequence)"username"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            LOGGER.error("An error occurred while initializing attribute mapping configurations");
        }
        return attributeMappingConfigObj;
    }

    private static void insertAttributeMappingConfig(MoIDPConfig idpConfig, JSONObject attributeMappingConfigObj) {
        LOGGER.debug("insertAttributeMappingConfig called");
        idpConfig.setUsernameAttribute(attributeMappingConfigObj.optString("miniorange.saml.USERNAME_ATTRIBUTE", "NameID"));
        idpConfig.setEmailAttribute(attributeMappingConfigObj.optString("miniorange.saml.EMAIL_ATTRIBUTE", "NameID"));
        idpConfig.setFullNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FULL_NAME_ATTRIBUTE", ""));
        idpConfig.setUseSeparateNameAttributes(attributeMappingConfigObj.optBoolean("miniorange.saml.USE_SEPARATE_NAME_ATTRIBUTE", false));
        idpConfig.setFirstNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.FIRST_NAME_ATTRIBUTE", ""));
        idpConfig.setLastNameAttribute(attributeMappingConfigObj.optString("miniorange.saml.LAST_NAME_ATTRIBUTE", ""));
        idpConfig.setKeepExistingUserAttributes(attributeMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_ATTRIBUTE", Boolean.TRUE));
        idpConfig.setRegexPattern(attributeMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN", ""));
        idpConfig.setRegexPatternEnabled(attributeMappingConfigObj.optBoolean("miniorange.saml.ENABLE_REGEX_PATTERN", false));
        idpConfig.setLoginUserAttribute(attributeMappingConfigObj.optString("miniorange.saml.LOGIN_USER_ATTRIBUTE", "username"));
    }

    private static void saveDefaultAttributeAndGroupMapping(String idpID) {
        MoPluginHandler.saveAttributeMapping(idpID, "NameID", "NameID", "", Boolean.FALSE, "", "", Boolean.FALSE, "", Boolean.FALSE, "username");
        MoPluginHandler.saveRoleMapping(idpID, "", Boolean.FALSE, Boolean.FALSE, new HashMap<String, String>(), settings.getDefaultGroup(), new ArrayList<String>(), Boolean.FALSE, "newUsers", Boolean.FALSE, new ArrayList<String>(), Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, "", "", "");
    }

    private static void saveDefaultAdvancedSSOSetting(String idpID) {
        MoPluginHandler.saveAdvancedOption(idpID, Boolean.TRUE, Boolean.FALSE, "", "01", Boolean.FALSE, "", 60, "Minutes", "", "forceRedirect", Boolean.FALSE, "");
    }

    private static JSONObject constructGroupMappingConfigObj(String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, String defaultGroup, List<String> defaultGroupList, Boolean restrictUserCreation, String enableDefaultGroupsFor, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroupsList, Boolean onTheFlyAssignNewGroupsOnly, Boolean createNewGroups, Boolean groupRegexPatternEnabled, String regexPatternForGroup, String regexGroups, String testRegex) {
        LOGGER.debug("constructGroupMappingConfigObj called roleAttribute=" + roleAttribute + ", createUsersIfRoleMapped=" + createUsersIfRoleMapped + ", keepExistingUserRoles=" + keepExistingUserRoles + ", roleMapping=" + roleMapping + ", defaultGroup=" + defaultGroup + ", defaultGroups=" + defaultGroupList + ",restrictUserCreation = " + restrictUserCreation + ", enableDefaultGroupsFor = " + enableDefaultGroupsFor + ", onTheFlyGroupCreation = " + onTheFlyGroupCreation + ", onTheFlyDoNotRemoveGroupsList = " + onTheFlyDoNotRemoveGroupsList + ", onTheFlyAssignNewGroupsOnly = " + onTheFlyAssignNewGroupsOnly + ", createNewGroups = " + createNewGroups + " regexPatternForGroup " + regexPatternForGroup + " regexGroups " + regexGroups + " testRegex " + testRegex + "]");
        JSONObject groupMappingConfigObj = new JSONObject();
        try {
            groupMappingConfigObj.put("miniorange.saml.ROLE_ATTRIBUTE", StringUtils.defaultIfBlank((CharSequence)MoSAMLUtils.sanitizeText(roleAttribute), (CharSequence)""));
            groupMappingConfigObj.put("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", BooleanUtils.toBooleanDefaultIfNull((Boolean)createUsersIfRoleMapped, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.KEEP_EXISTING_USER_ROLES", BooleanUtils.toBooleanDefaultIfNull((Boolean)keepExistingUserRoles, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_GROUP", StringUtils.defaultIfBlank((CharSequence)defaultGroup, (CharSequence)settings.getDefaultGroup()));
            JSONArray defaultGroupsObj = new JSONArray();
            groupMappingConfigObj.put("miniorange.saml.DEFAULT_GROUPs", defaultGroupsObj);
            if (defaultGroupList.size() == 0) {
                defaultGroupList.add(settings.getDefaultGroup());
            }
            for (String group : defaultGroupList) {
                groupMappingConfigObj.append("miniorange.saml.DEFAULT_GROUPs", group);
            }
            JSONObject groupMappingObj = new JSONObject();
            if (roleMapping != null) {
                for (String bambooGroup : roleMapping.keySet()) {
                    groupMappingObj.putOpt(bambooGroup, roleMapping.get(bambooGroup));
                }
            }
            groupMappingConfigObj.put("miniorange.saml.ROLE_MAPPING", groupMappingObj);
            groupMappingConfigObj.put("miniorange.saml.GROUP_REGEX_PATTERN_ENABLED", groupRegexPatternEnabled);
            groupMappingConfigObj.put("miniorange.saml.REGEX_PATTERN_FOR_GROUP", regexPatternForGroup);
            groupMappingConfigObj.put("miniorange.saml.REGEX_GROUPS", regexGroups);
            groupMappingConfigObj.put("miniorange.saml.TEST_REGEX", testRegex);
            groupMappingConfigObj.put("miniorange.saml.RESTRICT_USER_CREATION", BooleanUtils.toBoolean((Boolean)restrictUserCreation));
            groupMappingConfigObj.put("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", enableDefaultGroupsFor);
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyGroupCreation, (boolean)false));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", BooleanUtils.toBooleanDefaultIfNull((Boolean)onTheFlyAssignNewGroupsOnly, (boolean)Boolean.FALSE));
            groupMappingConfigObj.put("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", BooleanUtils.toBooleanDefaultIfNull((Boolean)createNewGroups, (boolean)Boolean.FALSE));
            if (onTheFlyDoNotRemoveGroupsList != null) {
                for (String group : onTheFlyDoNotRemoveGroupsList) {
                    groupMappingConfigObj.append("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS", group);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
            LOGGER.error("An error occurred while initializing group mapping configurations");
        }
        return groupMappingConfigObj;
    }

    private static void insertGroupMappingConfig(MoIDPConfig idpConfig, JSONObject groupMappingConfigObj) {
        LOGGER.debug("insertGroupMappingConfig called");
        idpConfig.setRoleAttribute(groupMappingConfigObj.optString("miniorange.saml.ROLE_ATTRIBUTE", ""));
        idpConfig.setCreateUsersIfRoleMapped(groupMappingConfigObj.optBoolean("miniorange.saml.CREATE_USER_IF_ROLE_MAPPED", false));
        idpConfig.setKeepExistingUserRoles(groupMappingConfigObj.optBoolean("miniorange.saml.KEEP_EXISTING_USER_ROLES", Boolean.TRUE));
        idpConfig.setDefaultGroup(groupMappingConfigObj.optString("miniorange.saml.DEFAULT_GROUP", settings.getDefaultGroup()));
        JSONArray defaultGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.DEFAULT_GROUPs");
        ArrayList<String> defaultGroupsList = new ArrayList<String>();
        if (defaultGroups != null) {
            for (int i = 0; i < defaultGroups.length(); ++i) {
                defaultGroupsList.add(defaultGroups.getString(i));
            }
        }
        idpConfig.setDefaultGroupsList(defaultGroupsList.isEmpty() ? (List)settings.getDefaultGroups() : defaultGroupsList);
        JSONObject groupMapping = groupMappingConfigObj.optJSONObject("miniorange.saml.ROLE_MAPPING");
        HashMap<String, String> roleMapping = new HashMap<String, String>();
        if (groupMapping != null) {
            Iterator<String> bambooGroups = groupMapping.keys();
            while (bambooGroups.hasNext()) {
                String bambooGroup = bambooGroups.next();
                if (!StringUtils.isNotBlank((CharSequence)groupMapping.getString(bambooGroup))) continue;
                roleMapping.put(bambooGroup, groupMapping.getString(bambooGroup));
            }
        }
        idpConfig.setRoleMapping(roleMapping);
        idpConfig.setRestrictUserCreation(groupMappingConfigObj.optBoolean("miniorange.saml.RESTRICT_USER_CREATION", false));
        idpConfig.setEnableDefaultGroupsFor(groupMappingConfigObj.optString("miniorange.saml.ENABLE_DEFAULT_GROUPS_FOR", "newUsers"));
        idpConfig.setOnTheFlyGroupCreation(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_GROUP_MAPPING", false));
        idpConfig.setOnTheFlyAssignNewGroupsOnly(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_ASSIGN_NEW_GROUPS_ONLY", Boolean.TRUE));
        idpConfig.setGroupRegexPatternEnabled(groupMappingConfigObj.optBoolean("miniorange.saml.GROUP_REGEX_PATTERN_ENABLED", false));
        idpConfig.setRegexPatternForGroup(groupMappingConfigObj.optString("miniorange.saml.REGEX_PATTERN_FOR_GROUP", ""));
        idpConfig.setRegexGroups(groupMappingConfigObj.optString("miniorange.saml.REGEX_GROUPS", ""));
        idpConfig.setTestRegex(groupMappingConfigObj.optString("miniorange.saml.TEST_REGEX", ""));
        idpConfig.setCreateNewGroups(groupMappingConfigObj.optBoolean("miniorange.saml.ON_THE_FLY_CREATE_NEW_GROUPS", Boolean.TRUE));
        JSONArray doNotRemoveGroups = groupMappingConfigObj.optJSONArray("miniorange.saml.ON_THE_FLY_DO_NOT_REMOVE_GROUPS");
        ArrayList<String> doNotRemoveGroupsList = new ArrayList<String>();
        if (doNotRemoveGroups != null) {
            for (int i = 0; i < doNotRemoveGroups.length(); ++i) {
                doNotRemoveGroupsList.add(doNotRemoveGroups.getString(i));
            }
        }
        idpConfig.setOnTheFlyDoNotRemoveGroups(doNotRemoveGroupsList.isEmpty() ? (List)settings.getOnTheFlyDoNotRemoveGroups() : doNotRemoveGroupsList);
    }

    public static void stopAllSchedulers() throws Exception {
        ArrayList<String> idpList = settings.getIdPList();
        for (String idp : idpList) {
            metadataJobRunnerImpl.deleteSchedule(idp);
        }
        metadataJobRunnerImpl.deleteSchedule("miniorange.saml.DEFAULT_IDP_ID");
    }

    public static ArrayList<String> dynamicSearchAttributes(List<String> attributesList, String searchPattern) {
        String startsWith = searchPattern;
        if (StringUtils.equalsIgnoreCase((CharSequence)searchPattern, (CharSequence)"*")) {
            startsWith = "";
        }
        ArrayList<String> searchedAttributes = new ArrayList<String>();
        for (String attribute : attributesList) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)attribute, (CharSequence)startsWith)) continue;
            searchedAttributes.add(attribute);
        }
        return searchedAttributes;
    }

    public boolean checkForAdminSession() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null) {
            return this.userManager.isAdmin(user.getUserKey());
        }
        return false;
    }

    public static boolean isParsable(String totalNumberOfRolesStr) {
        boolean isParsable = true;
        try {
            Integer.parseInt(totalNumberOfRolesStr);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Error occurred while parsing string ", e);
            isParsable = false;
        }
        return isParsable;
    }
}

