/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.listeners;

import com.opensymphony.webwork.util.classloader.ReloadingClassLoader;
import com.opensymphony.webwork.util.classloader.compilers.JavaCompiler;
import com.opensymphony.webwork.util.classloader.monitor.FilesystemAlterationListener;
import com.opensymphony.webwork.util.classloader.problems.CompilationProblem;
import com.opensymphony.webwork.util.classloader.problems.ConsoleCompilationProblemHandler;
import com.opensymphony.webwork.util.classloader.problems.DefaultCompilationProblemHandler;
import com.opensymphony.webwork.util.classloader.readers.ResourceReader;
import com.opensymphony.webwork.util.classloader.stores.TransactionalResourceStore;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompilingListener
implements FilesystemAlterationListener {
    private static final Log log = LogFactory.getLog(CompilingListener.class);
    private final Collection created = new ArrayList();
    private final Collection changed = new ArrayList();
    private final Collection deleted = new ArrayList();
    private final JavaCompiler compiler;
    private final ResourceReader reader;
    private final TransactionalResourceStore transactionalStore;
    private final DefaultCompilationProblemHandler problemHandler = new ConsoleCompilationProblemHandler();

    public CompilingListener(ResourceReader pReader, JavaCompiler pCompiler, TransactionalResourceStore pTransactionalStore) {
        this.compiler = pCompiler;
        this.reader = pReader;
        this.transactionalStore = pTransactionalStore;
    }

    public DefaultCompilationProblemHandler getCompilationProblemHandler() {
        return this.problemHandler;
    }

    public void onStart(File pRepository) {
        this.created.clear();
        this.changed.clear();
        this.deleted.clear();
        this.transactionalStore.onStart();
    }

    public void onStop(File pRepository) {
        log.debug("resources " + this.created.size() + " created, " + this.changed.size() + " changed, " + this.deleted.size() + " deleted");
        boolean reload = false;
        if (this.deleted.size() > 0) {
            Iterator it = this.deleted.iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                this.transactionalStore.remove(ReloadingClassLoader.clazzName(pRepository, file));
            }
            reload = true;
        }
        ArrayList compileables = new ArrayList();
        compileables.addAll(this.created);
        compileables.addAll(this.changed);
        String[] clazzes = new String[compileables.size()];
        if (compileables.size() > 0) {
            int i = 0;
            Iterator it = compileables.iterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                clazzes[i] = ReloadingClassLoader.clazzName(pRepository, file);
                ++i;
            }
            this.compiler.compile(clazzes, this.reader, this.transactionalStore, this.problemHandler);
            CompilationProblem[] errors = this.problemHandler.getErrors();
            CompilationProblem[] warnings = this.problemHandler.getWarnings();
            log.debug(errors.length + " errors, " + warnings.length + " warnings");
            if (errors.length > 0) {
                for (int j = 0; j < clazzes.length; ++j) {
                    this.transactionalStore.remove(clazzes[j]);
                }
            }
            reload = true;
        }
        this.transactionalStore.onStop();
        if (reload) {
            this.reload();
        }
    }

    public void onCreateFile(File file) {
        if (file.getName().endsWith(".java")) {
            this.created.add(file);
        }
    }

    public void onChangeFile(File file) {
        if (file.getName().endsWith(".java")) {
            this.changed.add(file);
        }
    }

    public void onDeleteFile(File file) {
        if (file.getName().endsWith(".java")) {
            this.deleted.add(file);
        }
    }

    public void onCreateDirectory(File file) {
    }

    public void onChangeDirectory(File file) {
    }

    public void onDeleteDirectory(File file) {
    }

    protected void reload() {
        log.debug("reload");
    }
}

