/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.util.ClassLoaderUtils;
import com.opensymphony.webwork.util.ListEntry;
import com.opensymphony.webwork.views.jsp.ui.OgnlTool;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebWorkUtil {
    protected static final Log log = LogFactory.getLog(WebWorkUtil.class);
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Map classes = new Hashtable();
    protected OgnlTool ognl = OgnlTool.getInstance();
    protected OgnlValueStack stack;

    public WebWorkUtil(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        this.stack = stack;
        this.request = request;
        this.response = response;
    }

    public Object bean(Object aName) throws Exception {
        String name = aName.toString();
        Class c = (Class)this.classes.get(name);
        if (c == null) {
            c = ClassLoaderUtils.loadClass(name, WebWorkUtil.class);
            this.classes.put(name, c);
        }
        return ObjectFactory.getObjectFactory().buildBean(c, this.stack.getContext());
    }

    public boolean isTrue(String expression) {
        Boolean retVal = (Boolean)this.stack.findValue(expression, Boolean.class);
        if (retVal == null) {
            return false;
        }
        return retVal;
    }

    public Object findString(String name) {
        return this.stack.findValue(name, String.class);
    }

    public String include(Object aName) throws Exception {
        return this.include(aName, this.request, this.response);
    }

    public String include(Object aName, HttpServletRequest aRequest, HttpServletResponse aResponse) throws Exception {
        try {
            RequestDispatcher dispatcher = aRequest.getRequestDispatcher(aName.toString());
            if (dispatcher == null) {
                throw new IllegalArgumentException("Cannot find included file " + aName);
            }
            ResponseWrapper responseWrapper = new ResponseWrapper(aResponse);
            dispatcher.include((ServletRequest)aRequest, (ServletResponse)responseWrapper);
            return responseWrapper.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String textToHtml(String s) {
        return TextUtils.plainTextToHtml((String)s);
    }

    public String urlEncode(String s) {
        return URLEncoder.encode(s);
    }

    public String buildUrl(String url) {
        return UrlHelper.buildUrl(url, this.request, this.response, null);
    }

    public Object findValue(String expression, String className) throws ClassNotFoundException {
        return this.stack.findValue(expression, Class.forName(className));
    }

    public String getText(String text) {
        return (String)this.stack.findValue("getText('" + text + "')");
    }

    public String getContext() {
        return this.request == null ? "" : this.request.getContextPath();
    }

    public List makeSelectList(String selectedList, String list, String listKey, String listValue) {
        Collection items;
        ArrayList<ListEntry> selectList = new ArrayList<ListEntry>();
        Collection<Object> selectedItems = null;
        Object i = this.stack.findValue(selectedList);
        if (i != null) {
            if (i.getClass().isArray()) {
                selectedItems = Arrays.asList((Object[])i);
            } else if (i instanceof Collection) {
                selectedItems = (Collection)i;
            } else {
                selectedItems = new ArrayList<Object>();
                selectedItems.add(i);
            }
        }
        if ((items = (Collection)this.stack.findValue(list)) != null) {
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object key = null;
                key = listKey == null || listKey.length() == 0 ? (Object)element : this.ognl.findValue(listKey, element);
                Object value = null;
                value = listValue == null || listValue.length() == 0 ? (Object)element : this.ognl.findValue(listValue, element);
                boolean isSelected = false;
                if (value != null && selectedItems != null && selectedItems.contains(value)) {
                    isSelected = true;
                }
                selectList.add(new ListEntry(key, value, isSelected));
            }
        }
        return selectList;
    }

    public String htmlEncode(Object obj) {
        if (obj == null) {
            return null;
        }
        return TextUtils.htmlEncode((String)obj.toString());
    }

    public int toInt(long aLong) {
        return (int)aLong;
    }

    public long toLong(int anInt) {
        return anInt;
    }

    public long toLong(String aLong) {
        if (aLong == null) {
            return 0L;
        }
        return Long.parseLong(aLong);
    }

    public String toString(long aLong) {
        return Long.toString(aLong);
    }

    public String toString(int anInt) {
        return Integer.toString(anInt);
    }

    static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        StringWriter writer;

        ServletOutputStreamWrapper(StringWriter aWriter) {
            this.writer = aWriter;
        }

        public void write(int aByte) {
            this.writer.write(aByte);
        }
    }

    static class ResponseWrapper
    extends HttpServletResponseWrapper {
        StringWriter strout = new StringWriter();
        PrintWriter writer;
        ServletOutputStream sout = new ServletOutputStreamWrapper(this.strout);

        ResponseWrapper(HttpServletResponse aResponse) {
            super(aResponse);
            this.writer = new PrintWriter(this.strout);
        }

        public String getData() {
            this.writer.flush();
            return this.strout.toString();
        }

        public ServletOutputStream getOutputStream() {
            return this.sout;
        }

        public PrintWriter getWriter() throws IOException {
            return this.writer;
        }
    }
}

