/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util;

import com.opensymphony.util.GUID;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenHelper {
    public static final String DEFAULT_TOKEN_NAME = "webwork.token";
    public static final String TOKEN_NAME_FIELD = "webwork.token.name";
    private static final Log LOG = LogFactory.getLog(TokenHelper.class);

    public static String setToken(HttpServletRequest request) {
        return TokenHelper.setToken(DEFAULT_TOKEN_NAME, request);
    }

    public static String setToken(String tokenName, HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String token = GUID.generateGUID();
        session.setAttribute(tokenName, (Object)token);
        return token;
    }

    public static String getToken(String tokenName, HttpServletRequest request) {
        Map params = request.getParameterMap();
        String[] tokens = (String[])params.get(tokenName);
        if (tokens == null || tokens.length < 1) {
            LOG.warn("Could not find token mapped to token name " + tokenName);
            return null;
        }
        String token = tokens[0];
        return token;
    }

    public static String getTokenName(HttpServletRequest request) {
        Map params = request.getParameterMap();
        if (!params.containsKey(TOKEN_NAME_FIELD)) {
            LOG.warn("Could not find token name in params.");
            return null;
        }
        String[] tokenNames = (String[])params.get(TOKEN_NAME_FIELD);
        if (tokenNames == null || tokenNames.length < 1) {
            LOG.warn("Got a null or empty token name.");
            return null;
        }
        String tokenName = tokenNames[0];
        return tokenName;
    }

    public static boolean validToken(HttpServletRequest request) {
        String tokenName = TokenHelper.getTokenName(request);
        if (tokenName == null) {
            return false;
        }
        String token = TokenHelper.getToken(tokenName, request);
        if (token == null) {
            return false;
        }
        HttpSession session = request.getSession(true);
        String sessionToken = (String)session.getAttribute(tokenName);
        if (!token.equals(sessionToken)) {
            LOG.warn(LocalizedTextUtil.findText((Class)TokenHelper.class, (String)"webwork.invalid.token", (Locale)request.getLocale(), (String)"Form token {0} does not match the session token {1}.", (Object[])new Object[]{token, sessionToken}));
            return false;
        }
        session.removeAttribute(tokenName);
        return true;
    }
}

