/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.portlet.util.AbstractUnzipper;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUnzipper
extends AbstractUnzipper {
    private File zipFile;

    public FileUnzipper(File zipFile, File destDir) {
        this.zipFile = zipFile;
        this.destDir = destDir;
    }

    public void unzip() throws Exception {
        if (this.zipFile == null || !this.zipFile.isFile()) {
            return;
        }
        ZipFile zf = new ZipFile(this.zipFile);
        Enumeration<? extends ZipEntry> zipEntries = zf.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            this.saveEntry(zf.getInputStream(zipEntry), zipEntry);
        }
        zf.close();
    }

    public File unzipFileInArchive(String fileName) throws Exception {
        File result = null;
        if (this.zipFile == null || !this.zipFile.isFile() || !TextUtils.stringSet((String)fileName)) {
            return result;
        }
        boolean fileFound = false;
        ZipFile zf = new ZipFile(this.zipFile);
        Enumeration<? extends ZipEntry> zipEntries = zf.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            if (TextUtils.stringSet((String)entryName) && entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            if (!fileName.equals(entryName)) continue;
            fileFound = true;
            result = this.saveEntry(zf.getInputStream(entry), entry);
        }
        if (!fileFound) {
            AbstractUnzipper.log.error("The file: " + fileName + " could not be found in the archive: " + this.zipFile.getAbsolutePath());
        }
        zf.close();
        return result;
    }
}

