/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.multipart;

import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DefaultFileItem;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;

public class JakartaMultiPartRequest
extends MultiPartRequest {
    private Map files = new HashMap();
    private Map params = new HashMap();
    private List errors = new ArrayList();

    public JakartaMultiPartRequest(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        DiskFileUpload upload = new DiskFileUpload();
        upload.setSizeThreshold(0);
        upload.setSizeMax((long)maxSize);
        upload.setHeaderEncoding(servletRequest.getCharacterEncoding());
        if (saveDir != null) {
            upload.setRepositoryPath(saveDir);
        }
        try {
            List items = upload.parseRequest(servletRequest);
            for (int i = 0; i < items.size(); ++i) {
                List values;
                FileItem item = (FileItem)items.get(i);
                log.debug("Found item " + item.getFieldName());
                if (item.isFormField()) {
                    log.debug("Item is a normal form field");
                    values = this.params.get(item.getFieldName()) != null ? (List)this.params.get(item.getFieldName()) : new ArrayList();
                    String charset = servletRequest.getCharacterEncoding();
                    if (charset != null) {
                        values.add(item.getString(charset));
                    } else {
                        values.add(item.getString());
                    }
                    this.params.put(item.getFieldName(), values);
                    continue;
                }
                if (item.getSize() == 0L) {
                    log.debug("Item is a file upload of 0 size, ignoring");
                    continue;
                }
                log.debug("Item is a file upload");
                values = this.files.get(item.getFieldName()) != null ? (List)this.files.get(item.getFieldName()) : new ArrayList();
                values.add(item);
                this.files.put(item.getFieldName(), values);
            }
        }
        catch (FileUploadException e) {
            log.error((Object)e);
            this.errors.add(e.getMessage());
        }
    }

    public Enumeration getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    public String[] getContentType(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            FileItem fileItem = (FileItem)items.get(i);
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    public File[] getFile(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DefaultFileItem fileItem = (DefaultFileItem)items.get(i);
            fileList.add(fileItem.getStoreLocation());
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    public String[] getFileNames(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DefaultFileItem fileItem = (DefaultFileItem)items.get(i);
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String[] getFilesystemName(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (int i = 0; i < items.size(); ++i) {
            DefaultFileItem fileItem = (DefaultFileItem)items.get(i);
            fileNames.add(fileItem.getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String getParameter(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return (String)v.get(0);
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    public List getErrors() {
        return this.errors;
    }
}

