/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.utils.MoSAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import sun.security.x509.X500Name;

public class MoGenerateCert
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoGenerateCert.class);
    private MoSAMLSettings settings;

    public MoGenerateCert(MoSAMLSettings settings) {
        this.settings = settings;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        switch (action = req.getParameter("action")) {
            case "gennewcert": {
                this.generateNewCertificates(req, resp);
                break;
            }
            case "revertoldcert": {
                this.revertOldCertificate(req, resp);
                break;
            }
            case "revertnewcert": {
                this.revertNewCertificate(req, resp);
                break;
            }
            case "revertoldconfiguredcert": {
                this.revertOldConfiguredCertificate(req, resp);
                break;
            }
            case "getdays": {
                this.certExpireIN(req, resp);
                break;
            }
            case "setCert": {
                this.setCertificates(req, resp);
                break;
            }
            case "setExpirayDate": {
                this.setSPCertExpirayDate(req, resp);
            }
            default: {
                resp.setContentType("application/json");
                resp.sendError(405, "The requested action is not allowed. Choose valid Action.");
            }
        }
    }

    private void generateNewCertificates(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Generating new SP Key pairs");
        String companyName = request.getParameter("companyName");
        String locationName = request.getParameter("locationName");
        String countryCode = request.getParameter("countryCode");
        String orgUnit = request.getParameter("orgUnit");
        String emailAdsress = request.getParameter("emailAdsress");
        int validityDays = Integer.parseInt(request.getParameter("validityDays"));
        JSONObject jsonObject = new JSONObject();
        boolean resultStatus = false;
        if (!(StringUtils.isNotBlank((CharSequence)emailAdsress) && StringUtils.isNotBlank((CharSequence)companyName) && StringUtils.isNotBlank((CharSequence)locationName) && StringUtils.isNotBlank((CharSequence)countryCode) && StringUtils.isNotBlank((CharSequence)orgUnit) && validityDays > 0)) {
            this.sendErrorMessage(response, "Error");
            return;
        }
        String distinguishedName = "email=" + emailAdsress + ", CN=" + companyName + ", OU=" + orgUnit + ", L=" + locationName + " , C=" + countryCode;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(2048);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            String algorithm = "SHA256withRSA";
            PrivateKey privateKey = keyPair.getPrivate();
            Date from = new Date();
            Date to = new Date(from.getTime() + (long)validityDays * 86400000L);
            BigInteger sn = new BigInteger(64, new SecureRandom());
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            X500Name x500Name = new X500Name(companyName, orgUnit, orgUnit, countryCode);
            X500Principal dnName = new X500Principal(x500Name.toString());
            certGen.setSerialNumber(sn);
            certGen.setIssuerDN(dnName);
            certGen.setNotBefore(from);
            certGen.setNotAfter(to);
            certGen.setSubjectDN(dnName);
            certGen.setPublicKey(keyPair.getPublic());
            certGen.setSignatureAlgorithm(algorithm);
            X509Certificate cert = certGen.generate(keyPair.getPrivate(), new SecureRandom());
            byte[][] keyPairBytes = new byte[][]{keyPair.getPrivate().getEncoded(), cert.getEncoded()};
            Base64.Encoder encoder = Base64.getEncoder();
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate(MoSAMLUtils.serializePrivateCertificate(encoder.encodeToString(keyPairBytes[0])));
            this.settings.setPublicSPCertificate(MoSAMLUtils.serializePublicCertificate(encoder.encodeToString(keyPairBytes[1])));
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            jsonObject.put("resultStatus", true);
            resultStatus = true;
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while generating new cert", e);
        }
        if (resultStatus) {
            this.sendSuccessResponse(jsonObject.toString(), response);
            return;
        }
        this.sendErrorMessage(response, "Error");
    }

    private void revertOldCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate("");
            this.settings.setPublicSPCertificate("");
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reverting old Certificates", e);
        }
    }

    private void revertNewCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setOldConfiguredPrivateSPCertificate(this.settings.getPrivateSPCertificate());
            this.settings.setOldConfiguredPublicSPCertificate(this.settings.getPublicSPCertificate());
            this.settings.setPrivateSPCertificate(this.settings.getNewPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getNewPublicSPCertificate());
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reverting old Certificates", e);
        }
    }

    private void revertOldConfiguredCertificate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.settings.setPrivateSPCertificate(this.settings.getOldConfiguredPrivateSPCertificate());
            this.settings.setPublicSPCertificate(this.settings.getOldConfiguredPublicSPCertificate());
            this.setExpiryDate(this.settings.getPublicSPCertificate());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while reverting old Certificates", e);
        }
    }

    private void certExpireIN(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("Getting days remaining to expire Plugin Certificate");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("days", this.settings.getSPCertExpireOn());
            response.setContentType("application/json");
            response.setStatus(200);
            response.getOutputStream().write(jsonObject.toString().getBytes(StandardCharsets.UTF_8));
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.debug("An error occurred while getting days due to expire certificate", e);
        }
    }

    private void sendErrorMessage(HttpServletResponse resp, String errorMessages) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        if (errorMessages != null) {
            resp.getOutputStream().write(errorMessages.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendSuccessResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void setExpiryDate(String publicCertificate) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(publicCertificate.getBytes(StandardCharsets.UTF_8)));
            this.settings.setSPCertExpireOn(cert.getNotAfter().toString());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while setting cert last date", e);
        }
    }

    private void setCertificates(HttpServletRequest request, HttpServletResponse response) {
        try {
            String privateCertificate = request.getParameter("privateCertificate");
            String publicCertificate = request.getParameter("publicCertificate");
            this.settings.setPrivateSPCertificate(privateCertificate);
            this.settings.setPublicSPCertificate(publicCertificate);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while setting Certificates", e);
        }
    }

    private void setSPCertExpirayDate(HttpServletRequest request, HttpServletResponse response) {
        try {
            String validTo = request.getParameter("validTo");
            this.settings.setSPCertExpireOn(validTo);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", true);
            this.sendSuccessResponse(jsonObject.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while setting Certificates", e);
        }
    }
}

