/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.views.xslt.AdapterNode;
import com.opensymphony.webwork.views.xslt.DOMAdapter;
import com.opensymphony.webwork.views.xslt.DefaultElementAdapter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanAdapter
extends DefaultElementAdapter {
    private static final Object[] NULLPARAMS = new Object[0];
    private static Map propertyDescriptorCache;
    private Log log = LogFactory.getLog(this.getClass());

    public BeanAdapter(DOMAdapter rootAdapter, AdapterNode parent, String propertyName, Object value) {
        super(rootAdapter, parent, propertyName, value);
    }

    public String getTagName() {
        return this.getPropertyName();
    }

    protected List buildChildrenAdapters() {
        ArrayList<AdapterNode> newAdapters = new ArrayList<AdapterNode>();
        Class<?> type = this.getValue().getClass();
        PropertyDescriptor[] props = this.getPropertyDescriptors(this.getValue());
        if (props.length > 0) {
            for (int i = 0; i < props.length; ++i) {
                Method m = props[i].getReadMethod();
                if (m == null) continue;
                String propertyName = props[i].getName();
                if (!this.getRootAdapter().isAdaptable(this.getRootAdapter(), this, propertyName)) continue;
                Object propertyValue = null;
                try {
                    propertyValue = m.invoke(this.getValue(), NULLPARAMS);
                }
                catch (Exception e) {
                    this.log.error("Exception when checking property " + propertyName, e);
                    continue;
                }
                AdapterNode childAdapter = propertyValue == null ? this.getRootAdapter().adaptNullValue(this.getRootAdapter(), this, propertyName) : this.getRootAdapter().adapt(this.getRootAdapter(), this, propertyName, propertyValue);
                if (childAdapter != null) {
                    newAdapters.add(childAdapter);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(this + " adding adapter: " + childAdapter);
            }
        } else {
            this.log.info("Class " + type.getName() + " has no readable properties, " + " trying to adapt " + this.getPropertyName() + " with ToStringAdapter...");
        }
        return newAdapters;
    }

    private synchronized PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        try {
            PropertyDescriptor[] props;
            if (propertyDescriptorCache == null) {
                propertyDescriptorCache = new HashMap();
            }
            if ((props = (PropertyDescriptor[])propertyDescriptorCache.get(bean.getClass())) == null) {
                this.log.debug("Caching property descriptor for " + bean.getClass().getName());
                props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
                propertyDescriptorCache.put(bean.getClass(), props);
            }
            return props;
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            throw new RuntimeException("Error getting property descriptors for " + bean + " : " + e.getMessage());
        }
    }
}

