/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.velocity.components;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.parser.FastPageParser;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import com.opensymphony.webwork.portlet.context.PortletContext;
import com.opensymphony.webwork.portlet.sitemesh.VelocityUtils;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public final class ApplyDecoratorDirective
extends Directive {
    private static final Log log = LogFactory.getLog(ApplyDecoratorDirective.class);
    public static final String STACK_KEY = DirectiveStack.class.getName();
    private DirectiveStack stack;
    private Map params = new HashMap();

    public String getName() {
        return "applyDecorator";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices services, InternalContextAdapter adapter, Node node) throws Exception {
        super.init(services, adapter, node);
        int numArgs = node.jjtGetNumChildren();
        if (numArgs < 2) {
            services.error("#applyDecorator error: You need a decorator name in order to use this tag");
        } else if (numArgs > 3) {
            services.error("#applyDecorator error: Too many parameters");
        }
    }

    public boolean render(InternalContextAdapter adapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        this.stack = (DirectiveStack)adapter.get(STACK_KEY);
        if (this.stack == null) {
            this.stack = new DirectiveStack();
            adapter.put(STACK_KEY, this.stack);
        }
        this.stack.push(this);
        HttpServletRequest request = (HttpServletRequest)adapter.get("req");
        if (request == null) {
            throw new IOException("No request object in context.");
        }
        HttpServletResponse response = (HttpServletResponse)adapter.get("res");
        if (response == null) {
            throw new IOException("No response object in context.");
        }
        try {
            Context context;
            HTMLPage page;
            String decoratorName = (String)node.jjtGetChild(0).value(adapter);
            StringWriter bodyContent = new StringWriter(1024);
            int bodyNode = 1;
            if (node.jjtGetNumChildren() == 3) {
                bodyNode = 2;
            }
            node.jjtGetChild(bodyNode).render(adapter, bodyContent);
            Factory factory = PortletContext.getContext().getSiteMeshFactory();
            Decorator decorator = factory.getDecoratorMapper().getNamedDecorator(request, decoratorName);
            if (decorator != null) {
                PageParser parser = factory.getPageParser("text/html");
                page = (HTMLPage)((FastPageParser)parser).parse((Reader)new StringReader(bodyContent.toString()));
                context = VelocityManager.getInstance().createContext(ActionContext.getContext().getValueStack(), request, response);
                context.put("page", page);
                if (node.jjtGetNumChildren() == 3) {
                    context.put("title", (String)node.jjtGetChild(1).value(adapter));
                } else {
                    context.put("title", page.getTitle());
                }
            } else {
                throw new IOException("could not find decorator with name: " + decoratorName);
            }
            StringWriter buffer = new StringWriter();
            page.writeBody(OutputConverter.getWriter((Writer)buffer));
            context.put("body", buffer.toString());
            buffer = new StringWriter();
            page.writeHead(OutputConverter.getWriter((Writer)buffer));
            context.put("head", buffer.toString());
            context.put("params", this.params);
            writer.write(VelocityUtils.getRenderedTemplate(decorator.getPage(), context));
            boolean flag = true;
            this.stack.pop();
            return flag;
        }
        catch (Exception exception) {
            this.stack.pop();
            throw new IOException(exception.toString());
        }
    }

    public void addParameter(String paramName, Object paramValue) {
        this.params.put(paramName, paramValue);
    }

    public class DirectiveStack {
        Stack stack = new Stack();

        public ApplyDecoratorDirective pop() {
            try {
                return (ApplyDecoratorDirective)this.stack.pop();
            }
            catch (EmptyStackException e) {
                log.info("Someone's been popping out of order! " + e.getMessage(), e);
                return null;
            }
        }

        public void push(ApplyDecoratorDirective directive) {
            this.stack.push(directive);
        }

        public ApplyDecoratorDirective peek() {
            if (this.stack.size() > 0) {
                return (ApplyDecoratorDirective)this.stack.peek();
            }
            return null;
        }
    }
}

