/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.views;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import com.opensymphony.module.sitemesh.util.Container;
import com.opensymphony.module.sitemesh.util.OutputConverter;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.portlet.context.PortletContext;
import com.opensymphony.webwork.portlet.util.FileUtils;
import com.opensymphony.webwork.portlet.util.GeneralUtil;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class AbstractResult
extends HttpServlet
implements RequestConstants {
    protected Configuration configuration;
    private VelocityManager velocityManager = VelocityManager.getInstance();
    private Factory factory = null;
    private ServletConfig servletConfig = null;
    private static final TextUtils TEXT_UTILS = new TextUtils();
    private static final FileUtils FILE_UTILS = new FileUtils();
    private static final GeneralUtil GENERAL_UTIL = new GeneralUtil();

    protected abstract void doRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletConfig = servletConfig;
        this.factory = Factory.getInstance((Config)new Config(servletConfig));
        servletConfig.getServletContext().setAttribute("webwork.servlet", (Object)this);
        VelocityManager.getInstance().init(this.getServletContext());
        try {
            this.configuration = this.createConfiguration();
        }
        catch (TemplateException e) {
            throw new ServletException("could not configure Freemarker", (Throwable)e);
        }
    }

    protected Configuration createConfiguration() throws TemplateException {
        return FreemarkerManager.getInstance().getConfiguration(this.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doFilter(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doFilter(request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doFilter(request, response);
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortletContext.getContext().setSiteMeshFactory(this.factory);
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        request.setAttribute("webwork.valueStack", (Object)stack);
        stack.getContext().put("com.opensymphony.xwork.dispatcher.HttpServletRequest", request);
        stack.getContext().put("com.opensymphony.xwork.dispatcher.HttpServletResponse", response);
        stack.getContext().put("com.opensymphony.xwork.dispatcher.ServletContext", this.getServletContext());
        if (this.factory.isPathExcluded(this.extractRequestPath(request))) {
            this.doRequest(request, response);
        } else {
            Page page;
            if (Container.get() == 1) {
                request.getSession(true);
            }
            if ((page = this.parsePage(request, response)) != null) {
                page.setRequest(request);
                Decorator decorator = this.factory.getDecoratorMapper().getDecorator(request, page);
                if (decorator != null && decorator.getPage() != null) {
                    this.applyDecorator(page, decorator, request, response);
                    page = null;
                    return;
                }
                this.writeOriginal(request, response, page);
                page = null;
            }
        }
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String decoratorPageName = decorator.getPage();
        if (decoratorPageName.lastIndexOf(".jsp") >= 0) {
            this.applyDecoratorUsingJSP(page, decorator, request, response);
        } else if (decoratorPageName.lastIndexOf(".vm") >= 0) {
            this.applyDecoratorUsingVelocity(request, page, response, decorator);
        }
    }

    private String extractRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo) + (query == null ? "" : "?" + query);
    }

    protected Page parsePage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            PageResponseWrapper pageResponse = new PageResponseWrapper(response, this.factory);
            this.doRequest(request, (HttpServletResponse)pageResponse);
            Page result = (Page)request.getAttribute("__sitemesh__page");
            if (result == null) {
                result = pageResponse.getPage();
            }
            request.setAttribute("__sitemesh__using_stream", (Object)new Boolean(pageResponse.isUsingStream()));
            return result;
        }
        catch (IllegalStateException e) {
            if (Container.get() != 4) {
                throw e;
            }
            return null;
        }
    }

    private void writeOriginal(HttpServletRequest request, HttpServletResponse response, Page page) throws IOException {
        response.setContentLength(page.getContentLength());
        if (request.getAttribute("__sitemesh__using_stream").equals(Boolean.TRUE)) {
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            page.writePage((Writer)writer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            page.writePage((Writer)response.getWriter());
            response.getWriter().flush();
        }
    }

    protected void applyDecoratorUsingJSP(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setAttribute("__sitemesh__page", (Object)page);
            ServletContext context = this.getServletContext();
            if (decorator.getURIPath() != null && context.getContext(decorator.getURIPath()) != null) {
                context = context.getContext(decorator.getURIPath());
            }
            RequestDispatcher dispatcher = context.getRequestDispatcher(decorator.getPage());
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            while (decorator.getInitParameterNames().hasNext()) {
                String initParam = (String)decorator.getInitParameterNames().next();
                if (!initParam.startsWith("header.")) continue;
                response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
            }
            request.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException e) {
            if (Container.get() == 1) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    protected void applyDecoratorUsingVelocity(HttpServletRequest request, Page page, HttpServletResponse response, Decorator decorator) throws IOException {
        try {
            request.setAttribute("__sitemesh__page", (Object)page);
            Context context = VelocityManager.getInstance().createContext(ActionContext.getContext().getValueStack(), request, response);
            context.put("textUtils", TEXT_UTILS);
            context.put("fileUtil", FILE_UTILS);
            context.put("generalUtil", GENERAL_UTIL);
            context.put("page", page);
            context.put("title", page.getTitle());
            StringWriter buffer = new StringWriter();
            page.writeBody(OutputConverter.getWriter((Writer)buffer));
            context.put("body", buffer.toString());
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                buffer = new StringWriter();
                htmlPage.writeHead(OutputConverter.getWriter((Writer)buffer));
                context.put("head", buffer.toString());
            }
            VelocityEngine velocityEngine = VelocityManager.getInstance().getVelocityEngine();
            Template template = velocityEngine.getTemplate(decorator.getPage());
            StringWriter tempWriter = new StringWriter();
            template.merge(context, tempWriter);
            String renderResult = tempWriter.toString();
            response.getWriter().print(renderResult);
            while (decorator.getInitParameterNames().hasNext()) {
                String initParam = (String)decorator.getInitParameterNames().next();
                if (!initParam.startsWith("header.")) continue;
                response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
            }
            request.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException e) {
            if (Container.get() == 1) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

