/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.portlet.util.ClassLoaderUtils;
import com.opensymphony.webwork.portlet.util.FolderArchiver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static Log log = LogFactory.getLog(FileUtils.class);
    private static final int BUFFER_SIZE = 1024;

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, false);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        File[] files = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            log.debug(destDir.getAbsolutePath() + " already exists");
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File dest = new File(destDir, file.getName());
            if (file.isFile()) {
                FileUtils.copyFile(new FileInputStream(file), dest, overwrite);
                continue;
            }
            FileUtils.copyDirectory(file, dest, overwrite);
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream input = new FileInputStream(srcFile);
        FileUtils.copyFile(input, destFile);
    }

    public static void copyFile(InputStream srcStream, File destFile) throws IOException {
        FileUtils.copyFile(srcStream, destFile, false);
    }

    public static void copyFile(InputStream srcStream, File destFile, boolean overwrite) throws IOException {
        File parentFile = destFile.getParentFile();
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        if (destFile.exists()) {
            if (overwrite) {
                log.debug("Overwriting file at: " + destFile.getAbsolutePath());
                FileUtils.writeStreamToFile(srcStream, destFile);
            } else {
                log.warn(destFile.getAbsolutePath() + " already exists");
            }
        } else {
            destFile.createNewFile();
            FileUtils.writeStreamToFile(srcStream, destFile);
        }
    }

    private static void writeStreamToFile(InputStream srcStream, File destFile) throws IOException {
        InputStream input = null;
        BufferedOutputStream output = null;
        try {
            int ch;
            input = new BufferedInputStream(srcStream);
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            while ((ch = input.read()) != -1) {
                ((OutputStream)output).write(ch);
            }
        }
        catch (IOException e) {
            log.error("Error writing stream to file: " + destFile.getAbsolutePath());
            throw e;
        }
        finally {
            input.close();
        }
        ((OutputStream)output).close();
    }

    public static void saveTextFile(String stringContent, File destFile) throws IOException {
        FileUtils.ensureFileAndPathExist(destFile);
        FileWriter writer = new FileWriter(destFile);
        writer.write(stringContent);
        writer.close();
    }

    public static void ensureFileAndPathExist(File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    public static void createZipFile(File baseDir, File zipFile) throws Exception {
        FolderArchiver compressor = new FolderArchiver(baseDir, zipFile);
        compressor.doArchive();
    }

    public static List readResourcesAsList(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String s;
            InputStream is = ClassLoaderUtils.getResourceAsStream(resource, FileUtils.class);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((s = in.readLine()) != null) {
                String niceS = TextUtils.noNull((String)s).trim();
                if (!TextUtils.stringSet((String)niceS) || niceS.charAt(0) == '#') continue;
                result.add(s);
            }
            is.close();
        }
        catch (IOException e) {
            log.error("IOException reading stream: " + e, e);
        }
        return result;
    }

    public static String getResourceContent(String resource) {
        InputStream is = ClassLoaderUtils.getResourceAsStream(resource, FileUtils.class);
        return FileUtils.getInputStreamTextContent(is);
    }

    public static String getResourceContent(HttpServletRequest req, String resource) {
        InputStream is = req.getSession().getServletContext().getResourceAsStream(resource);
        String result = FileUtils.getInputStreamTextContent(is);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getInputStreamTextContent(InputStream is) {
        if (is == null) {
            return null;
        }
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
            FileUtils.pump(is, baos);
            result = new String(baos.toByteArray());
            is.close();
        }
        catch (IOException e) {
            log.error("IOException reading stream: " + e, e);
        }
        return result;
    }

    private static void pump(InputStream is, OutputStream os) throws IOException {
        int lengthRead;
        byte[] buffer = new byte[1024];
        while ((lengthRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, lengthRead);
        }
    }

    public static boolean deleteDir(File dir) {
        File candir;
        if (dir == null) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                File file = files[i];
                boolean bl = deleted = !file.delete();
                if (!deleted || !file.isDirectory()) continue;
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }
}

