/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.ServletRedirectResult;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.util.PrefixTrie;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DefaultActionMapper
implements ActionMapper {
    static final String METHOD_PREFIX = "method:";
    static final String ACTION_PREFIX = "action:";
    static final String REDIRECT_PREFIX = "redirect:";
    static final String REDIRECT_ACTION_PREFIX = "redirect-action:";
    static PrefixTrie prefixTrie = new PrefixTrie(){
        {
            this.put(DefaultActionMapper.METHOD_PREFIX, new ParameterAction(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void execute(String key, ActionMapping mapping) {
                    mapping.setMethod(key.substring("method:".length()));
                }
            });
            this.put(DefaultActionMapper.ACTION_PREFIX, new ParameterAction(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void execute(String key, ActionMapping mapping) {
                    mapping.setName(key.substring("action:".length()));
                }
            });
            this.put(DefaultActionMapper.REDIRECT_PREFIX, new ParameterAction(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void execute(String key, ActionMapping mapping) {
                    ServletRedirectResult redirect = new ServletRedirectResult();
                    redirect.setLocation(key.substring("redirect:".length()));
                    mapping.setResult(redirect);
                }
            });
            this.put(DefaultActionMapper.REDIRECT_ACTION_PREFIX, new ParameterAction(this){
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                }

                public void execute(String key, ActionMapping mapping) {
                    String location = key.substring("redirect-action:".length());
                    ServletRedirectResult redirect = new ServletRedirectResult();
                    String extension = DefaultActionMapper.getExtension();
                    if (extension != null) {
                        location = location + "." + extension;
                    }
                    redirect.setLocation(location);
                    mapping.setResult(redirect);
                }
            });
        }
    };

    public ActionMapping getMapping(HttpServletRequest request) {
        ActionMapping mapping = new ActionMapping();
        String uri = this.getUri(request);
        this.parseNameAndNamespace(uri, mapping);
        Map parameterMap = request.getParameterMap();
        Iterator iterator = parameterMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ParameterAction parameterAction = (ParameterAction)prefixTrie.get(key);
            if (parameterAction == null) continue;
            parameterAction.execute(key, mapping);
            break;
        }
        if (mapping.getName() == null) {
            return null;
        }
        String name = mapping.getName();
        int exclamation = name.lastIndexOf("!");
        if (exclamation != -1) {
            mapping.setName(name.substring(0, exclamation));
            mapping.setMethod(name.substring(exclamation + 1));
        }
        return mapping;
    }

    void parseNameAndNamespace(String uri, ActionMapping mapping) {
        String name;
        String namespace;
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == -1) {
            namespace = "";
            name = uri;
        } else if (lastSlash == 0) {
            namespace = "/";
            name = uri.substring(lastSlash + 1);
        } else {
            namespace = uri.substring(0, lastSlash);
            name = uri.substring(lastSlash + 1);
        }
        mapping.setNamespace(namespace);
        mapping.setName(this.dropExtension(name));
    }

    String dropExtension(String name) {
        String extension = DefaultActionMapper.getExtension();
        if (extension == null) {
            return name;
        }
        extension = "." + extension;
        return name.endsWith(extension) ? name.substring(0, name.length() - extension.length()) : null;
    }

    static String getExtension() {
        String extension = (String)Configuration.get("webwork.action.extension");
        return extension.equals("") ? null : extension;
    }

    String getUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            return uri;
        }
        uri = request.getServletPath();
        if (uri != null && !"".equals(uri)) {
            return uri;
        }
        uri = request.getRequestURI();
        return uri.substring(request.getContextPath().length());
    }

    public String getUriFromActionMapping(ActionMapping mapping) {
        String extension;
        StringBuffer uri = new StringBuffer();
        uri.append(mapping.getNamespace());
        if (!"/".equals(mapping.getNamespace())) {
            uri.append("/");
        }
        uri.append(mapping.getName());
        if (null != mapping.getMethod() && !"".equals(mapping.getMethod())) {
            uri.append("!").append(mapping.getMethod());
        }
        if ((extension = DefaultActionMapper.getExtension()) != null) {
            uri.append(".").append(extension);
        }
        return uri.toString();
    }

    static interface ParameterAction {
        public void execute(String var1, ActionMapping var2);
    }
}

