/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.webwork.components.template.BaseTemplateEngine;
import com.opensymphony.webwork.components.template.Template;
import com.opensymphony.webwork.components.template.TemplateRenderingContext;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerTemplateEngine
extends BaseTemplateEngine {
    static Class bodyContent = null;
    private static final Log LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        ActionInvocation ai;
        OgnlValueStack stack = templateContext.getStack();
        Map context = stack.getContext();
        ServletContext servletContext = (ServletContext)context.get("com.opensymphony.xwork.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)context.get("com.opensymphony.xwork.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)context.get("com.opensymphony.xwork.dispatcher.HttpServletResponse");
        FreemarkerManager freemarkerManager = FreemarkerManager.getInstance();
        Configuration config = freemarkerManager.getConfiguration(servletContext);
        List templates = templateContext.getTemplate().getPossibleTemplates(this);
        freemarker.template.Template template = null;
        String templateName = null;
        IOException exception = null;
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            Template t = (Template)iterator.next();
            templateName = this.getFinalTemplateName(t);
            try {
                template = config.getTemplate(templateName);
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            LOG.error("Could not load template " + templateContext.getTemplate());
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rendering template " + templateName);
        }
        Object action = (ai = ActionContext.getContext().getActionInvocation()) == null ? null : ai.getAction();
        SimpleHash model = freemarkerManager.buildTemplateModel(stack, action, servletContext, req, res, config.getObjectWrapper());
        model.put("tag", (Object)templateContext.getTag());
        Writer writer = templateContext.getWriter();
        if (bodyContent != null && bodyContent.isAssignableFrom(writer.getClass())) {
            final Writer wrapped = writer;
            writer = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    wrapped.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                    wrapped.close();
                }
            };
        }
        try {
            stack.push((Object)templateContext.getTag());
            template.process((Object)model, writer);
        }
        finally {
            stack.pop();
        }
    }

    protected String getSuffix() {
        return "ftl";
    }

    static {
        try {
            bodyContent = ClassLoaderUtil.loadClass((String)"javax.servlet.jsp.tagext.BodyContent", (Class)FreemarkerTemplateEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOG = LogFactory.getLog(FreemarkerTemplateEngine.class);
    }
}

