/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.components.Param;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Text
extends Component
implements Param.UnnamedParametric {
    private static final Log LOG = LogFactory.getLog(Text.class);
    protected List values = Collections.EMPTY_LIST;
    protected String actualName;
    protected String name;

    public Text(OgnlValueStack stack) {
        super(stack);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean end(Writer writer, String body) {
        this.actualName = this.findString(this.name, "name", "You must specify the i18n key. Example: welcome.header");
        String defaultMessage = TextUtils.stringSet((String)body) ? body : this.actualName;
        String msg = null;
        OgnlValueStack stack = this.getStack();
        Iterator iterator = this.getStack().getRoot().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!(o instanceof TextProvider)) continue;
            TextProvider tp = (TextProvider)o;
            msg = tp.getText(this.actualName, defaultMessage, this.values, stack);
            break;
        }
        if (msg != null) {
            try {
                if (this.getId() == null) {
                    writer.write(msg);
                } else {
                    stack.getContext().put(this.getId(), msg);
                }
            }
            catch (IOException e) {
                LOG.error("Could not write out URL tag", e);
            }
        }
        return super.end(writer, "");
    }

    public void addParameter(String key, Object value) {
        this.addParameter(value);
    }

    public void addParameter(Object value) {
        if (this.values.isEmpty()) {
            this.values = new ArrayList(4);
        }
        this.values.add(value);
    }
}

