/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.components.ClosingUIBean;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.portlet.context.PortletContext;
import com.opensymphony.webwork.portlet.util.PortalContainer;
import com.opensymphony.xwork.util.OgnlValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class RemoteCallUIBean
extends ClosingUIBean {
    protected String href;
    protected String errorText;
    protected String showErrorTransportText;
    protected String afterLoading;

    public RemoteCallUIBean(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.href != null) {
            String hrefValue = this.findString(this.href);
            String actionUrl = PortletContext.getContext().getActionURL();
            if (!TextUtils.stringSet((String)actionUrl)) {
                this.addParameter("href", hrefValue);
            } else {
                String actionExtension = (String)Configuration.get("webwork.action.extension");
                actionExtension = actionExtension == null || "".equals(actionExtension) ? ".action" : "." + actionExtension;
                boolean isWebWorkAction = hrefValue.indexOf(actionExtension) >= 0;
                StringBuffer sb = new StringBuffer();
                if (isWebWorkAction) {
                    if (3 == PortalContainer.get()) {
                        int catIndex = actionUrl.lastIndexOf("&#p_");
                        String liferay_actionUrl = actionUrl.substring(0, catIndex == -1 ? actionUrl.length() : catIndex);
                        sb.append(liferay_actionUrl).append("&wwXAction=").append(hrefValue);
                    } else if (4 == PortalContainer.get()) {
                        sb.append(actionUrl).append("&wwXAction=").append(hrefValue);
                    } else {
                        sb.append(actionUrl).append("?wwXAction=").append(hrefValue);
                    }
                } else if (3 == PortalContainer.get()) {
                    int catIndex = actionUrl.lastIndexOf("&#p_");
                    String liferay_actionUrl = actionUrl.substring(0, catIndex == -1 ? actionUrl.length() : catIndex);
                    sb.append(liferay_actionUrl).append("&wwLink=").append(hrefValue);
                } else if (4 == PortalContainer.get()) {
                    sb.append(actionUrl).append("&wwLink=").append(hrefValue);
                } else {
                    sb.append(actionUrl).append("?wwLink=").append(hrefValue);
                }
                this.addParameter("href", sb.toString());
            }
        }
        if (this.showErrorTransportText != null) {
            this.addParameter("showErrorTransportText", this.findValue(this.showErrorTransportText, Boolean.class));
        }
        if (this.errorText != null) {
            this.addParameter("errorText", this.findString(this.errorText));
        }
        if (this.afterLoading != null) {
            this.addParameter("afterLoading", this.findString(this.afterLoading));
        }
    }

    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public void setShowErrorTransportText(String showErrorTransportText) {
        this.showErrorTransportText = showErrorTransportText;
    }

    public void setAfterLoading(String afterLoading) {
        this.afterLoading = afterLoading;
    }
}

