/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.scheduler.config.JobId;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import com.miniorange.sso.saml.bamboo.schedulers.MoMetadataJobRunnerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoDeleteIdpServlet
extends HttpServlet {
    private MoSAMLSettings settings;
    MoMetadataJobRunnerImpl metadataJobRunnerImpl;
    private String xsrfToken;
    private ArrayList<String> idpList;
    private HashMap<String, String> idpMap;
    private Boolean useDomainMapping;
    private List<String> domainsList;
    private static Log LOGGER = LogFactory.getLog(MoDeleteIdpServlet.class);

    public MoDeleteIdpServlet(MoSAMLSettings settings, MoMetadataJobRunnerImpl metadataJobRunnerImpl) {
        this.settings = settings;
        this.metadataJobRunnerImpl = metadataJobRunnerImpl;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoDeleteIdpServlet : execute called");
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        try {
            String idpID = request.getParameter("idpID");
            String status = "";
            if (StringUtils.isNotBlank((CharSequence)idpID)) {
                HashMap<String, String> idpMap = this.settings.getIdpMap();
                if (idpMap == null || !idpMap.containsKey(idpID)) {
                    status = "missing";
                } else {
                    this.settings.removeIdp(idpID);
                    this.settings.removeRedirectionRulesForIdp(idpID);
                    if (StringUtils.equals((CharSequence)this.settings.getDefaultBambooIDP(), (CharSequence)idpID)) {
                        this.settings.setDefaultBambooIDP("loginPage");
                    }
                    this.metadataJobRunnerImpl.deleteSchedule(idpID);
                    status = "success";
                }
            } else {
                status = "empty";
            }
            if (this.settings.getIdPList().size() == 1) {
                this.settings.setUseDomainMapping(Boolean.FALSE);
            }
            LOGGER.debug("MoDeleteIdpServlet : Before Redirecting to listidp");
            response.sendRedirect("listidp.action?operation=delete&status=" + status);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            request.getSession().setAttribute("error", (Object)"There is some problem for deleting IDP. Please contact to administrator.");
            response.sendRedirect("listidp.action?operation=delete&status=error");
            return;
        }
    }

    private static JobId toJobId(String jobID) {
        return JobId.of((String)("Job ID =" + jobID));
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public MoMetadataJobRunnerImpl getMetadataJobRunnerImpl() {
        return this.metadataJobRunnerImpl;
    }

    public void setMetadataJobRunnerImpl(MoMetadataJobRunnerImpl metadataJobRunnerImpl) {
        this.metadataJobRunnerImpl = metadataJobRunnerImpl;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public ArrayList<String> getIdpList() {
        this.idpList = this.settings.getIdPList();
        return this.idpList;
    }

    public void setIdpList(ArrayList<String> idpList) {
        this.idpList = idpList;
    }

    public HashMap<String, String> getIdpMap() {
        this.idpMap = this.settings.getIdpMap();
        return this.idpMap;
    }

    public void setIdpMap(HashMap<String, String> idpMap) {
        this.idpMap = idpMap;
    }

    public Boolean getUseDomainMapping() {
        this.useDomainMapping = this.settings.getUseDomainMapping();
        return this.useDomainMapping;
    }

    public void setUseDomainMapping(Boolean useDomainMapping) {
        this.useDomainMapping = useDomainMapping;
    }

    public List<String> getDomainsList() {
        this.domainsList = this.settings.getDomains();
        return this.domainsList;
    }

    public void setDomainsList(List<String> domainsList) {
        this.domainsList = domainsList;
    }
}

