/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.velocity;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.portlet.context.PortletContext;
import com.opensymphony.webwork.util.VelocityWebWorkUtil;
import com.opensymphony.webwork.views.util.ContextUtil;
import com.opensymphony.webwork.views.velocity.WebWorkVelocityContext;
import com.opensymphony.webwork.views.velocity.components.ActionDirective;
import com.opensymphony.webwork.views.velocity.components.ActionErrorDirective;
import com.opensymphony.webwork.views.velocity.components.ActionMessageDirective;
import com.opensymphony.webwork.views.velocity.components.AnchorDirective;
import com.opensymphony.webwork.views.velocity.components.ApplyDecoratorDirective;
import com.opensymphony.webwork.views.velocity.components.BeanDirective;
import com.opensymphony.webwork.views.velocity.components.CheckBoxDirective;
import com.opensymphony.webwork.views.velocity.components.CheckBoxListDirective;
import com.opensymphony.webwork.views.velocity.components.ComboBoxDirective;
import com.opensymphony.webwork.views.velocity.components.ComponentDirective;
import com.opensymphony.webwork.views.velocity.components.DatePickerDirective;
import com.opensymphony.webwork.views.velocity.components.DecoratorParamDirective;
import com.opensymphony.webwork.views.velocity.components.DivDirective;
import com.opensymphony.webwork.views.velocity.components.DoubleSelectDirective;
import com.opensymphony.webwork.views.velocity.components.FieldErrorDirective;
import com.opensymphony.webwork.views.velocity.components.FileDirective;
import com.opensymphony.webwork.views.velocity.components.FormDirective;
import com.opensymphony.webwork.views.velocity.components.HeadDirective;
import com.opensymphony.webwork.views.velocity.components.HiddenDirective;
import com.opensymphony.webwork.views.velocity.components.I18nDirective;
import com.opensymphony.webwork.views.velocity.components.IncludeDirective;
import com.opensymphony.webwork.views.velocity.components.LabelDirective;
import com.opensymphony.webwork.views.velocity.components.OptionTransferSelectDirective;
import com.opensymphony.webwork.views.velocity.components.PanelDirective;
import com.opensymphony.webwork.views.velocity.components.ParamDirective;
import com.opensymphony.webwork.views.velocity.components.PasswordDirective;
import com.opensymphony.webwork.views.velocity.components.PropertyDirective;
import com.opensymphony.webwork.views.velocity.components.PushDirective;
import com.opensymphony.webwork.views.velocity.components.RadioDirective;
import com.opensymphony.webwork.views.velocity.components.SelectDirective;
import com.opensymphony.webwork.views.velocity.components.SetDirective;
import com.opensymphony.webwork.views.velocity.components.SubmitDirective;
import com.opensymphony.webwork.views.velocity.components.TabbedPanelDirective;
import com.opensymphony.webwork.views.velocity.components.TextAreaDirective;
import com.opensymphony.webwork.views.velocity.components.TextDirective;
import com.opensymphony.webwork.views.velocity.components.TextFieldDirective;
import com.opensymphony.webwork.views.velocity.components.TokenDirective;
import com.opensymphony.webwork.views.velocity.components.URLDirective;
import com.opensymphony.webwork.views.velocity.components.WebTableDirective;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.ToolboxManager;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.servlet.ServletToolboxManager;

public class VelocityManager {
    private static final Log log = LogFactory.getLog(VelocityManager.class);
    private static VelocityManager instance;
    public static final String WEBWORK = "webwork";
    public static final String ACTION_URL = "actionURL";
    public static final String ACTION_XURL = "actionXURL";
    public static final String PARENT = "parent";
    public static final String TAG = "tag";
    private VelocityEngine velocityEngine;
    protected ToolboxManager toolboxManager = null;
    private String toolBoxLocation;
    private String[] chainedContextNames;

    protected VelocityManager() {
        this.init();
    }

    public static synchronized VelocityManager getInstance() {
        if (instance == null) {
            String classname = VelocityManager.class.getName();
            if (Configuration.isSet("webwork.velocity.manager.classname")) {
                classname = Configuration.getString("webwork.velocity.manager.classname").trim();
            }
            if (!classname.equals(VelocityManager.class.getName())) {
                try {
                    log.info("Instantiating VelocityManager!, " + classname);
                    instance = (VelocityManager)ObjectFactory.getObjectFactory().buildBean(Class.forName(classname), null);
                }
                catch (Exception e) {
                    log.fatal("Fatal exception occurred while trying to instantiate a VelocityManager instance, " + classname, e);
                    instance = new VelocityManager();
                }
            } else {
                instance = new VelocityManager();
            }
        }
        return instance;
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public Context createContext(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        VelocityContext[] chainedContexts = this.prepareChainedContexts(req, res, stack.getContext());
        WebWorkVelocityContext context = new WebWorkVelocityContext(chainedContexts, stack);
        Map standardMap = ContextUtil.getStandardContext(stack, req, res);
        Iterator iterator = standardMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            context.put((String)entry.getKey(), entry.getValue());
        }
        context.put(WEBWORK, new VelocityWebWorkUtil(context, stack, req, res));
        String actionURL = PortletContext.getContext().getActionURL();
        String actionXURL = actionURL + "?wwXAction=";
        context.put(ACTION_URL, actionURL);
        context.put(ACTION_XURL, actionXURL);
        ServletContext ctx = null;
        try {
            ctx = ServletActionContext.getServletContext();
        }
        catch (NullPointerException npe) {
            log.debug("internal toolbox context ignored");
        }
        if (this.toolboxManager != null && ctx != null) {
            ChainedContext chained = new ChainedContext((Context)context, req, res, ctx);
            chained.setToolbox(this.toolboxManager.getToolboxContext((Object)chained));
            return chained;
        }
        return context;
    }

    protected VelocityContext[] prepareChainedContexts(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map extraContext) {
        if (this.chainedContextNames == null) {
            return null;
        }
        ArrayList<VelocityContext> contextList = new ArrayList<VelocityContext>();
        for (int i = 0; i < this.chainedContextNames.length; ++i) {
            String className = this.chainedContextNames[i];
            try {
                VelocityContext velocityContext = (VelocityContext)ObjectFactory.getObjectFactory().buildBean(className, null);
                contextList.add(velocityContext);
                continue;
            }
            catch (Exception e) {
                log.warn("Warning.  " + e.getClass().getName() + " caught while attempting to instantiate a chained VelocityContext, " + className + " -- skipping");
            }
        }
        if (contextList.size() > 0) {
            VelocityContext[] extraContexts = new VelocityContext[contextList.size()];
            contextList.toArray(extraContexts);
            return extraContexts;
        }
        return null;
    }

    public synchronized void init(ServletContext context) {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.newVelocityEngine(context);
        }
        this.initToolbox(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Properties loadConfiguration(ServletContext context) {
        block19: {
            if (context == null) {
                gripe = "Error attempting to create a loadConfiguration from a null ServletContext!";
                VelocityManager.log.error(gripe);
                throw new IllegalArgumentException(gripe);
            }
            properties = new Properties();
            this.applyDefaultConfiguration(context, properties);
            defaultUserDirective = properties.getProperty("userdirective");
            configfile = Configuration.isSet("webwork.velocity.configfile") != false ? Configuration.getString("webwork.velocity.configfile") : "velocity.properties";
            configfile = configfile.trim();
            in = null;
            resourceLocation = null;
            try {
                block18: {
                    if (context.getRealPath(configfile) != null && (filename = context.getRealPath(configfile)) != null) {
                        file = new File(filename);
                        if (file.isFile()) {
                            resourceLocation = file.getCanonicalPath() + " from file system";
                            in = new FileInputStream(file);
                        }
                        if (in == null && (file = new File(context.getRealPath("/WEB-INF/" + configfile))).isFile()) {
                            resourceLocation = file.getCanonicalPath() + " from file system";
                            in = new FileInputStream(file);
                        }
                    }
                    if (in == null && (in = VelocityManager.class.getClassLoader().getResourceAsStream(configfile)) != null) {
                        resourceLocation = configfile + " from classloader";
                    }
                    if (in == null) break block18;
                    VelocityManager.log.info("Initializing velocity using " + resourceLocation);
                    properties.load(in);
                }
                var10_11 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var9_15) {
                var10_12 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var9_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (IOException e) {
                    VelocityManager.log.warn("Unable to load velocity configuration " + resourceLocation, e);
                    var10_11 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        userdirective = (userdirective = properties.getProperty("userdirective")) == null || userdirective.trim().equals("") != false ? defaultUserDirective : userdirective.trim() + "," + defaultUserDirective;
        properties.setProperty("userdirective", userdirective);
        if (VelocityManager.log.isDebugEnabled()) {
            VelocityManager.log.debug("Initializing Velocity with the following properties ...");
            iter = properties.keySet().iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                value = properties.getProperty(key);
                if (!VelocityManager.log.isDebugEnabled()) continue;
                VelocityManager.log.debug("    '" + key + "' = '" + value + "'");
            }
        }
        return properties;
    }

    protected void init() {
        this.initChainedContexts();
        if (Configuration.isSet("webwork.velocity.toolboxlocation")) {
            this.toolBoxLocation = Configuration.get("webwork.velocity.toolboxlocation").toString();
        }
    }

    protected void initToolbox(ServletContext context) {
        if (this.toolBoxLocation != null) {
            this.toolboxManager = ServletToolboxManager.getInstance((ServletContext)context, (String)this.toolBoxLocation);
        } else {
            Velocity.info("VelocityViewServlet: No toolbox entry in configuration.");
        }
    }

    protected void initChainedContexts() {
        if (Configuration.isSet("webwork.velocity.contexts")) {
            String contexts = Configuration.get("webwork.velocity.contexts").toString();
            StringTokenizer st = new StringTokenizer(contexts, ",");
            ArrayList<String> contextList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String classname = st.nextToken();
                contextList.add(classname);
            }
            if (contextList.size() > 0) {
                String[] chainedContexts = new String[contextList.size()];
                contextList.toArray(chainedContexts);
                this.chainedContextNames = chainedContexts;
            }
        }
    }

    protected VelocityEngine newVelocityEngine(ServletContext context) {
        if (context == null) {
            String gripe = "Error attempting to create a new VelocityEngine from a null ServletContext!";
            log.error(gripe);
            throw new IllegalArgumentException(gripe);
        }
        Properties p = this.loadConfiguration(context);
        VelocityEngine velocityEngine = new VelocityEngine();
        try {
            velocityEngine.init(p);
        }
        catch (Exception e) {
            String gripe = "Unable to instantiate VelocityEngine!";
            log.error(gripe, e);
            throw new RuntimeException(gripe);
        }
        return velocityEngine;
    }

    private void applyDefaultConfiguration(ServletContext context, Properties p) {
        if (p.getProperty("resource.loader") == null) {
            p.setProperty("resource.loader", "wwfile, wwclass");
        }
        if (context.getRealPath("") != null) {
            p.setProperty("wwfile.resource.loader.description", "Velocity File Resource Loader");
            p.setProperty("wwfile.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            p.setProperty("wwfile.resource.loader.path", context.getRealPath(""));
            p.setProperty("wwfile.resource.loader.modificationCheckInterval", "2");
            p.setProperty("wwfile.resource.loader.cache", "true");
        } else {
            String prop = p.getProperty("resource.loader");
            if (prop.indexOf("wwfile,") != -1) {
                prop = VelocityManager.replace(prop, "wwfile,", "");
            } else if (prop.indexOf(", wwfile") != -1) {
                prop = VelocityManager.replace(prop, ", wwfile", "");
            } else if (prop.indexOf("wwfile") != -1) {
                prop = VelocityManager.replace(prop, "wwfile", "");
            }
            p.setProperty("resource.loader", prop);
        }
        p.setProperty("wwclass.resource.loader.description", "Velocity Classpath Resource Loader");
        p.setProperty("wwclass.resource.loader.class", "com.opensymphony.webwork.views.velocity.WebWorkResourceLoader");
        p.setProperty("wwclass.resource.loader.modificationCheckInterval", "2");
        p.setProperty("wwclass.resource.loader.cache", "true");
        StringBuffer sb = new StringBuffer();
        this.addDirective(sb, ApplyDecoratorDirective.class);
        this.addDirective(sb, DecoratorParamDirective.class);
        this.addDirective(sb, ActionDirective.class);
        this.addDirective(sb, BeanDirective.class);
        this.addDirective(sb, CheckBoxDirective.class);
        this.addDirective(sb, CheckBoxListDirective.class);
        this.addDirective(sb, ComboBoxDirective.class);
        this.addDirective(sb, ComponentDirective.class);
        this.addDirective(sb, DatePickerDirective.class);
        this.addDirective(sb, DivDirective.class);
        this.addDirective(sb, DoubleSelectDirective.class);
        this.addDirective(sb, FileDirective.class);
        this.addDirective(sb, FormDirective.class);
        this.addDirective(sb, HeadDirective.class);
        this.addDirective(sb, HiddenDirective.class);
        this.addDirective(sb, AnchorDirective.class);
        this.addDirective(sb, I18nDirective.class);
        this.addDirective(sb, IncludeDirective.class);
        this.addDirective(sb, LabelDirective.class);
        this.addDirective(sb, PanelDirective.class);
        this.addDirective(sb, ParamDirective.class);
        this.addDirective(sb, PasswordDirective.class);
        this.addDirective(sb, PushDirective.class);
        this.addDirective(sb, PropertyDirective.class);
        this.addDirective(sb, RadioDirective.class);
        this.addDirective(sb, SelectDirective.class);
        this.addDirective(sb, SetDirective.class);
        this.addDirective(sb, SubmitDirective.class);
        this.addDirective(sb, TabbedPanelDirective.class);
        this.addDirective(sb, TextAreaDirective.class);
        this.addDirective(sb, TextDirective.class);
        this.addDirective(sb, TextFieldDirective.class);
        this.addDirective(sb, TokenDirective.class);
        this.addDirective(sb, URLDirective.class);
        this.addDirective(sb, WebTableDirective.class);
        this.addDirective(sb, ActionErrorDirective.class);
        this.addDirective(sb, ActionMessageDirective.class);
        this.addDirective(sb, FieldErrorDirective.class);
        this.addDirective(sb, OptionTransferSelectDirective.class);
        String directives = sb.toString();
        String userdirective = p.getProperty("userdirective");
        userdirective = userdirective == null || userdirective.trim().equals("") ? directives : userdirective.trim() + "," + directives;
        p.setProperty("userdirective", userdirective);
    }

    private void addDirective(StringBuffer sb, Class clazz) {
        sb.append(clazz.getName()).append(",");
    }

    private static final String replace(String string, String oldString, String newString) {
        if (string == null) {
            return null;
        }
        if (newString == null) {
            return string;
        }
        int i = 0;
        if ((i = string.indexOf(oldString, i)) >= 0) {
            char[] string2 = string.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(string2.length);
            buf.append(string2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = string.indexOf(oldString, i)) > 0) {
                buf.append(string2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(string2, j, string2.length - j);
            return buf.toString();
        }
        return string;
    }
}

