/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScopeInterceptor
implements Interceptor,
PreResultListener {
    private static final Log LOG = LogFactory.getLog(ScopeInterceptor.class);
    String[] application = null;
    String[] session = null;
    String key;
    String type = null;
    String sessionReset = "session.reset";
    boolean reset = false;
    private static final Object NULL = new Object(){

        public String toString() {
            return "NULL";
        }
    };
    private static Map locks = new IdentityHashMap();

    public void setApplication(String s) {
        if (s != null) {
            this.application = s.split(" *, *");
        }
    }

    public void setSession(String s) {
        if (s != null) {
            this.session = s.split(" *, *");
        }
    }

    private String getKey(ActionInvocation invocation) {
        ActionProxy proxy = invocation.getProxy();
        if (this.key == null || "CLASS".equals(this.key)) {
            this.key = "webwork.ScopeInterceptor:" + proxy.getAction().getClass();
        } else if ("ACTION".equals(this.key)) {
            this.key = "webwork.ScopeInterceptor:" + proxy.getNamespace() + ":" + proxy.getActionName();
        }
        return this.key;
    }

    private static final Object nullConvert(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o == NULL) {
            return null;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void lock(Object o, ActionInvocation invocation) throws Exception {
        Object object = o;
        synchronized (object) {
            int count = 3;
            Object previous = null;
            while (true) {
                Object v = locks.get(o);
                previous = v;
                if (v == null) break;
                if (previous == invocation) {
                    return;
                }
                if (count-- <= 0) {
                    locks.remove(o);
                    o.notify();
                    throw new RuntimeException("Deadlock in session lock");
                }
                o.wait(10000L);
            }
            locks.put(o, invocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void unlock(Object o) {
        Object object = o;
        synchronized (object) {
            locks.remove(o);
            o.notify();
        }
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        HttpSession ses = ServletActionContext.getRequest().getSession();
        ScopeInterceptor.unlock(ses);
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Object attribute;
        String string;
        int i;
        invocation.addPreResultListener((PreResultListener)this);
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpSession ses = request.getSession(true);
        ScopeInterceptor.lock(ses, invocation);
        String key = this.getKey(invocation);
        ServletContext app = ServletActionContext.getServletContext();
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope interceptor before");
        }
        if (this.application != null) {
            for (i = 0; i < this.application.length; ++i) {
                string = this.application[i];
                attribute = app.getAttribute(key + string);
                if (attribute == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("application scoped variable set " + string + " = " + String.valueOf(attribute));
                }
                stack.setValue(string, ScopeInterceptor.nullConvert(attribute));
            }
        }
        if (request.getParameter(this.sessionReset) != null) {
            return;
        }
        if (this.reset) {
            return;
        }
        if (this.session != null && !"start".equals(this.type)) {
            for (i = 0; i < this.session.length; ++i) {
                string = this.session[i];
                attribute = ses.getAttribute(key + string);
                if (attribute == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("session scoped variable set " + string + " = " + String.valueOf(attribute));
                }
                stack.setValue(string, ScopeInterceptor.nullConvert(attribute));
            }
        }
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        HttpSession ses = ServletActionContext.getRequest().getSession();
        String key = this.getKey(invocation);
        ServletContext app = ServletActionContext.getServletContext();
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        if (this.application != null) {
            for (int i = 0; i < this.application.length; ++i) {
                String string = this.application[i];
                Object value = stack.findValue(string);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("application scoped variable saved " + string + " = " + String.valueOf(value));
                }
                app.setAttribute(key + string, ScopeInterceptor.nullConvert(value));
            }
        }
        boolean ends = "end".equals(this.type);
        if (this.session != null) {
            for (int i = 0; i < this.session.length; ++i) {
                String string = this.session[i];
                if (ends) {
                    ses.removeAttribute(key + string);
                    continue;
                }
                Object value = stack.findValue(string);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("session scoped variable saved " + string + " = " + String.valueOf(value));
                }
                ses.setAttribute(key + string, ScopeInterceptor.nullConvert(value));
            }
        }
        ScopeInterceptor.unlock(ses);
        if (LOG.isDebugEnabled()) {
            LOG.debug("scope interceptor after (before result)");
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (!"start".equals(type = type.toLowerCase()) && !"end".equals(type)) {
            throw new IllegalArgumentException("Only start or end are allowed arguments for type");
        }
        this.type = type;
    }

    public String getSessionReset() {
        return this.sessionReset;
    }

    public void setSessionReset(String sessionReset) {
        this.sessionReset = sessionReset;
    }

    public void destroy() {
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        String result = null;
        HttpSession ses = ServletActionContext.getRequest().getSession();
        this.before(invocation);
        try {
            result = invocation.invoke();
            this.after(invocation, result);
        }
        finally {
            ScopeInterceptor.unlock(ses);
        }
        return result;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }
}

