/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.mapper;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapper;
import com.opensymphony.xwork.ObjectFactory;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionMapperFactory {
    protected static final Log LOG = LogFactory.getLog(ActionMapperFactory.class);
    private static final HashMap classMap = new HashMap();

    public static ActionMapper getMapper() {
        HashMap hashMap = classMap;
        synchronized (hashMap) {
            String clazz = (String)Configuration.get("webwork.mapper.class");
            try {
                ActionMapper mapper = (ActionMapper)classMap.get(clazz);
                if (mapper == null) {
                    mapper = (ActionMapper)ObjectFactory.getObjectFactory().buildBean(clazz, null);
                    classMap.put(clazz, mapper);
                }
                return mapper;
            }
            catch (Exception e) {
                String msg = "Could not create ActionMapper: WebWork will *not* work!";
                LOG.fatal(msg, e);
                throw new RuntimeException(msg, e);
            }
        }
    }
}

