/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.webwork.components.Include;
import com.opensymphony.webwork.components.UIBean;
import com.opensymphony.webwork.components.template.BaseTemplateEngine;
import com.opensymphony.webwork.components.template.Template;
import com.opensymphony.webwork.components.template.TemplateRenderingContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JspTemplateEngine
extends BaseTemplateEngine {
    private static final Log LOG = LogFactory.getLog(JspTemplateEngine.class);

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Template template = templateContext.getTemplate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to render template " + template + ", repeating through parents until we succeed");
        }
        UIBean tag = templateContext.getTag();
        OgnlValueStack stack = templateContext.getStack();
        stack.push((Object)tag);
        PageContext pageContext = (PageContext)stack.getContext().get("com.opensymphony.xwork.dispatcher.PageContext");
        List templates = template.getPossibleTemplates(this);
        Exception exception = null;
        boolean success = false;
        Iterator iterator = templates.iterator();
        while (iterator.hasNext()) {
            Template t = (Template)iterator.next();
            try {
                Include.include(this.getFinalTemplateName(t), (Writer)pageContext.getOut(), pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
                success = true;
                break;
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (!success) {
            LOG.error("Could not render JSP template " + templateContext.getTemplate());
            if (exception != null) {
                throw exception;
            }
            return;
        }
        stack.pop();
    }

    protected String getSuffix() {
        return "jsp";
    }
}

