/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.sso.saml.MoPluginException;
import com.miniorange.sso.saml.bamboo.MoPluginHandler;
import com.miniorange.sso.saml.bamboo.MoSAMLSettings;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoPostLogoutRulesAction
extends BambooActionSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoPostLogoutRulesAction.class);
    private Boolean postLogoutSettingsSubmitted;
    private String customLogoutURL;
    private Boolean enableLogoutTemplate;
    private String logoutTemplate;
    private String xsrfToken;
    private PluginLicenseManager pluginLicenseManager;
    private MoSAMLSettings settings;
    private MoPluginHandler moPluginHandler;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;

    public MoPostLogoutRulesAction(MoSAMLSettings settings, MoPluginHandler moPluginHandler, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        String string = this.logoutTemplate = StringUtils.equals((CharSequence)this.logoutTemplate, null) ? this.settings.getLogoutTemplate() : this.logoutTemplate;
        if (!BooleanUtils.toBoolean((Boolean)this.postLogoutSettingsSubmitted)) {
            return;
        }
        if (super.hasActionErrors()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeSAMLConfig();
        }
    }

    public String execute() throws Exception {
        try {
            LOGGER.info("MoPostLogoutRulesAction doExecute Submitted: ");
            HttpServletRequest request = ServletActionContext.getRequest();
            HttpServletResponse response = ServletActionContext.getResponse();
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            UserProfile user = this.userManager.getRemoteUser();
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                if (!this.settings.isValidLicense().booleanValue()) {
                    LOGGER.error("No valid license found");
                    return "upm";
                }
                if (BooleanUtils.toBoolean((Boolean)this.postLogoutSettingsSubmitted)) {
                    this.validate();
                    MoPluginHandler.savePostLogoutSettings(this.customLogoutURL, this.enableLogoutTemplate, this.logoutTemplate);
                    this.addActionMessage(this.getText("samlsso.success.config"));
                    LOGGER.debug("settings saved successfully");
                }
                this.initializeSAMLConfig();
                return "success";
            }
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
            return null;
        }
        catch (MoPluginException e) {
            this.addActionError(e.getMessage());
            return "input";
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving your details.", (Throwable)e);
            this.addActionError(e.getMessage());
            return "input";
        }
    }

    private void initializeSAMLConfig() {
        this.customLogoutURL = this.settings.getCustomLogoutURL();
        this.enableLogoutTemplate = this.settings.getEnableLogoutTemplate();
        this.logoutTemplate = this.settings.getLogoutTemplate();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getPostLogoutSettingsSubmitted() {
        return this.postLogoutSettingsSubmitted;
    }

    public void setPostLogoutSettingsSubmitted(Boolean postLogoutSettingsSubmitted) {
        this.postLogoutSettingsSubmitted = postLogoutSettingsSubmitted;
    }

    public String getCustomLogoutURL() {
        return this.customLogoutURL;
    }

    public void setCustomLogoutURL(String customLogoutURL) {
        this.customLogoutURL = customLogoutURL;
    }

    public Boolean getEnableLogoutTemplate() {
        return this.enableLogoutTemplate;
    }

    public void setEnableLogoutTemplate(Boolean enableLogoutTemplate) {
        this.enableLogoutTemplate = enableLogoutTemplate;
    }

    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    public MoSAMLSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoSAMLSettings settings) {
        this.settings = settings;
    }

    public MoPluginHandler getMoPluginHandler() {
        return this.moPluginHandler;
    }

    public void setMoPluginHandler(MoPluginHandler moPluginHandler) {
        this.moPluginHandler = moPluginHandler;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }
}

