/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.util;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlHelper {
    private static final Log LOG = LogFactory.getLog(UrlHelper.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String AMP = "&";

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params) {
        return UrlHelper.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        String result;
        StringBuffer link = new StringBuffer();
        boolean changedScheme = false;
        int httpPort = 80;
        try {
            httpPort = Integer.parseInt((String)Configuration.get("webwork.url.http.port"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        int httpsPort = 443;
        try {
            httpsPort = Integer.parseInt((String)Configuration.get("webwork.url.https.port"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = request.getRequestURI();
                link.append(uri.substring(0, uri.lastIndexOf(47)));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        String continueId = (String)ActionContext.getContext().get((Object)"__continue");
        if (continueId != null) {
            if (params == null) {
                params = Collections.singletonMap("__continue", continueId);
            } else {
                params.put("__continue", continueId);
            }
        }
        UrlHelper.buildParametersString(params, link);
        try {
            result = encodeResult ? response.encodeURL(link.toString()) : link.toString();
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static void buildParametersString(Map params, StringBuffer link) {
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(AMP);
            }
            Iterator iter = params.entrySet().iterator();
            String[] valueHolder = new String[1];
            while (iter.hasNext()) {
                String[] values;
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    values = (String[])value;
                } else {
                    valueHolder[0] = value.toString();
                    values = valueHolder;
                }
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != null) {
                        link.append(name);
                        link.append('=');
                        link.append(UrlHelper.translateAndEncode(values[i]));
                    }
                    if (i >= values.length - 1) continue;
                    link.append("&amp;");
                }
                if (!iter.hasNext()) continue;
                link.append("&amp;");
            }
        }
    }

    public static String translateAndEncode(String input) {
        OgnlValueStack valueStack = ServletActionContext.getContext().getValueStack();
        String output = TextParseUtil.translateVariables((String)input, (OgnlValueStack)valueStack);
        try {
            return URLEncoder.encode(output, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Could not encode URL parameter '" + input + "', returning value un-encoded");
            return output;
        }
    }
}

