/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.stores;

import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResourceStoreClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog(ResourceStoreClassLoader.class);
    private final ResourceStore store;
    private final ClassLoader parent;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore pStore) {
        super(pParent);
        this.parent = pParent;
        this.store = pStore;
    }

    private Class fastFindClass(String name) {
        byte[] clazzBytes = this.store.read(name);
        if (clazzBytes != null) {
            log.debug("found class " + name + " (" + clazzBytes.length + " bytes)");
            return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
                log.debug("loaded from parent: " + name);
            } else {
                log.debug("loaded from store: " + name);
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }
}

