/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.util.classloader.listeners;

import com.opensymphony.webwork.util.classloader.ReloadingClassLoader;
import com.opensymphony.webwork.util.classloader.monitor.FilesystemAlterationListener;
import com.opensymphony.webwork.util.classloader.stores.ResourceStore;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingListener
implements FilesystemAlterationListener {
    private static final Log log = LogFactory.getLog(ReloadingListener.class);
    private final Collection created = new ArrayList();
    private final Collection changed = new ArrayList();
    private final Collection deleted = new ArrayList();
    private final ResourceStore store;

    public ReloadingListener(ResourceStore pStore) {
        this.store = pStore;
    }

    public void onStart(File repository) {
        this.created.clear();
        this.changed.clear();
        this.deleted.clear();
    }

    public void onStop(File pRepository) {
        byte[] bytes;
        File file;
        Iterator it;
        boolean reload = false;
        log.debug("created:" + this.created.size() + " changed:" + this.changed.size() + " deleted:" + this.deleted.size());
        if (this.deleted.size() > 0) {
            it = this.deleted.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                this.store.remove(ReloadingClassLoader.clazzName(pRepository, file));
            }
            reload = true;
        }
        if (this.created.size() > 0) {
            it = this.created.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                try {
                    bytes = IOUtils.toByteArray((Reader)new FileReader(file));
                    this.store.write(ReloadingClassLoader.clazzName(pRepository, file), bytes);
                }
                catch (Exception e) {
                    log.error("could not load " + file, e);
                }
            }
        }
        if (this.changed.size() > 0) {
            it = this.changed.iterator();
            while (it.hasNext()) {
                file = (File)it.next();
                try {
                    bytes = IOUtils.toByteArray((Reader)new FileReader(file));
                    this.store.write(ReloadingClassLoader.clazzName(pRepository, file), bytes);
                }
                catch (Exception e) {
                    log.error("could not load " + file, e);
                }
            }
            reload = true;
        }
        this.notifyOfCheck(reload);
    }

    public void onCreateFile(File file) {
        if (file.getName().endsWith(".class")) {
            this.created.add(file);
        }
    }

    public void onChangeFile(File file) {
        if (file.getName().endsWith(".class")) {
            this.changed.add(file);
        }
    }

    public void onDeleteFile(File file) {
        if (file.getName().endsWith(".class")) {
            this.deleted.add(file);
        }
    }

    public void onCreateDirectory(File file) {
    }

    public void onChangeDirectory(File file) {
    }

    public void onDeleteDirectory(File file) {
    }

    protected void notifyOfCheck(boolean pReload) {
        if (pReload) {
            log.debug("reload required");
        } else {
            log.debug("no reload required");
        }
    }
}

