/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.filter.PageFilter;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeMarkerPageFilter
extends PageFilter {
    private static final Log LOG = LogFactory.getLog(FreeMarkerPageFilter.class);
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this.filterConfig = filterConfig;
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            FreemarkerManager fmm = FreemarkerManager.getInstance();
            ServletContext servletContext = this.filterConfig.getServletContext();
            ActionContext ctx = ServletActionContext.getActionContext(req);
            if (ctx == null) {
                OgnlValueStack vs = new OgnlValueStack();
                vs.getContext().putAll(DispatcherUtils.getInstance().createContextMap(req, res, null, servletContext));
                ctx = new ActionContext(vs.getContext());
                if (ctx.getActionInvocation() == null) {
                    ActionSupport action = new ActionSupport();
                    vs.push((Object)action);
                    ctx.setActionInvocation((ActionInvocation)new DummyActionInvocation(action));
                }
            }
            Configuration config = fmm.getConfiguration(servletContext);
            Template template = config.getTemplate(decorator.getPage());
            SimpleHash model = fmm.buildTemplateModel(ctx.getValueStack(), null, servletContext, req, res, config.getObjectWrapper());
            model.put("page", (Object)page);
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                model.put("head", (Object)htmlPage.getHead());
            }
            model.put("title", (Object)page.getTitle());
            model.put("body", (Object)page.getBody());
            template.process((Object)model, (Writer)res.getWriter());
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error(msg, e);
            throw new ServletException(msg, (Throwable)e);
        }
    }

    static class DummyActionInvocation
    implements ActionInvocation {
        ActionSupport action;

        public DummyActionInvocation(ActionSupport action) {
            this.action = action;
        }

        public Object getAction() {
            return this.action;
        }

        public boolean isExecuted() {
            return false;
        }

        public ActionContext getInvocationContext() {
            return null;
        }

        public ActionProxy getProxy() {
            return null;
        }

        public Result getResult() throws Exception {
            return null;
        }

        public String getResultCode() {
            return null;
        }

        public void setResultCode(String resultCode) {
        }

        public OgnlValueStack getStack() {
            return null;
        }

        public void addPreResultListener(PreResultListener listener) {
        }

        public String invoke() throws Exception {
            return null;
        }

        public String invokeActionOnly() throws Exception {
            return null;
        }
    }
}

