/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.util;

import com.opensymphony.webwork.portlet.util.FileUnzipper;
import com.opensymphony.webwork.portlet.util.Unzipper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractUnzipper
implements Unzipper {
    protected static Log log = LogFactory.getLog(FileUnzipper.class);
    private static final int BUFFER_SIZE = 10240;
    protected File destDir;

    public abstract File unzipFileInArchive(String var1) throws Exception;

    public abstract void unzip() throws Exception;

    protected File saveEntry(InputStream is, ZipEntry entry) throws Exception {
        File file = new File(this.destDir, entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            File dir = new File(file.getParent());
            dir.mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            AbstractUnzipper.pump(is, fos);
            fos.flush();
            fos.close();
        }
        return file;
    }

    private static void pump(InputStream is, OutputStream os) throws IOException {
        int lengthRead;
        byte[] buffer = new byte[10240];
        while ((lengthRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, lengthRead);
        }
    }
}

