/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.UIBean;
import com.opensymphony.webwork.util.TokenHelper;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Token
extends UIBean {
    public static final String TEMPLATE = "token";

    public Token(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected void evaluateExtraParams() {
        String tokenName;
        super.evaluateExtraParams();
        Map parameters = this.getParameters();
        if (parameters.containsKey("name")) {
            tokenName = (String)parameters.get("name");
        } else {
            if (this.name == null) {
                tokenName = "webwork.token";
            } else {
                tokenName = this.findString(this.name);
                if (tokenName == null) {
                    tokenName = this.name;
                }
            }
            this.addParameter("name", tokenName);
        }
        String token = this.buildToken(tokenName);
        this.addParameter(TEMPLATE, token);
        this.addParameter("tokenNameField", "webwork.token.name");
    }

    public String getTokenNameField() {
        return "webwork.token.name";
    }

    private String buildToken(String name) {
        Map context = this.stack.getContext();
        Object myToken = context.get(name);
        if (myToken == null) {
            myToken = TokenHelper.setToken(name, this.request);
            context.put(name, myToken);
        }
        return myToken.toString();
    }
}

