/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.sso.saml.bamboo.servlet;

import com.miniorange.sso.saml.bamboo.MoPluginConfigurationsHandler;
import com.miniorange.sso.saml.bamboo.servlet.MoMetadataServlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoDownloadPluginConfiguration
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoMetadataServlet.class);
    private MoPluginConfigurationsHandler moPluginConfigurationsHandler;

    public MoDownloadPluginConfiguration(MoPluginConfigurationsHandler moPluginConfigurationsHandler) {
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Download app configuration: doGet() called");
        try {
            String jsonConfigurations = this.moPluginConfigurationsHandler.generateConfigurationsJson();
            LOGGER.debug("Downloading json Configurations file.");
            response.setHeader("Content-Disposition", "attachment; filename=\"app_configurations.json\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/json");
            response.getOutputStream().write(jsonConfigurations.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
            PrintWriter writer = response.getWriter();
            writer.print("An error occurred while generating the configuration file.");
            writer.close();
        }
    }

    public MoPluginConfigurationsHandler getMoPluginConfigurationsHandler() {
        return this.moPluginConfigurationsHandler;
    }

    public void setMoPluginConfigurationsHandler(MoPluginConfigurationsHandler moPluginConfigurationsHandler) {
        this.moPluginConfigurationsHandler = moPluginConfigurationsHandler;
    }
}

