<meta name="decorator" content="atl.general"/>
    <style>
        <#include "/css/knowledgebase.css" parse=true>
    </style>

    <script>
        AJS.$(function () {
            AJS.$(".aui-nav li").removeClass("aui-nav-selected");
            AJS.$("#mo-knowledge-base").addClass("aui-nav-selected");
        });

        function alterKnowledgeBaseView(viewName) {
            document.querySelectorAll('.view-section').forEach(section => {
                section.classList.remove('active');
            });

            ['documentation_tab', 'videos_tab','handbook_tab','faq_tab'].forEach(id => {
                const tab = document.getElementById(id);
                if (tab) {
                    tab.classList.remove('aui-nav-selected');
                }
            });

            document.getElementById(viewName + 'View').classList.add('active');
            document.getElementById(viewName + '_tab').classList.add('active');
            document.getElementById(viewName + '_tab').classList.add('aui-nav-selected');
        }

        document.addEventListener('DOMContentLoaded', function() {
            alterKnowledgeBaseView('documentation');
        });
    </script>

<#include "*/header.ftl" parse=true>

<div style="padding: 20px; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif; background: var(--background-primary);">
    <div class="aui-page-panel-inner">
        <div id="mo-configure" class="aui-tabs horizontal-tabs" role="application">
            <nav class="aui-navgroup aui-navgroup-horizontal">
                <div class="aui-navgroup-inner">
                    <div class="aui-navgroup-primary">
                        <div id="oauth-navigation-links" style="font-size: 17px">
                            <ul class="aui-nav">
                                <li id="documentation_tab" onclick="alterKnowledgeBaseView('documentation')">
                                    <a href="#"><strong>Documentation</strong></a>
                                </li>
                                <li id="videos_tab" onclick="alterKnowledgeBaseView('videos')">
                                    <a href="#"><strong>Videos</strong></a>
                                </li>
                                <li id="handbook_tab">
                                    <a href="https://developers.miniorange.com/docs/atlassian/oauth-sso-2.0/oauth-openid-sso-feature-document" target="_blank"><strong>Handbook</strong></a>
                                </li>
                                <li id="faq_tab" onclick="alterKnowledgeBaseView('faq')">
                                    <a href="#"><strong>FAQs</strong></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </div>

    <div id="documentationView" class="view-section active">
        <div style="margin-top: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px; gap: 12px;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <svg width="16" height="22" viewBox="0 0 16 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3.86857 11.427H12.1314V10.2842H3.86857V11.427ZM3.86857 14.5916H12.1314V13.4487H3.86857V14.5916ZM3.86857 17.7573H8.70286V16.6145H3.86857V17.7573ZM1.84571 21.3607C1.32 21.3607 0.881143 21.1847 0.529143 20.8327C0.177143 20.4807 0.000761905 20.0415 0 19.515V2.63502C0 2.10931 0.176381 1.67045 0.529143 1.31845C0.881905 0.96645 1.32114 0.790069 1.84686 0.789307H10.8571L16 5.93216V19.515C16 20.0407 15.824 20.48 15.472 20.8327C15.12 21.1855 14.6804 21.3615 14.1531 21.3607H1.84571ZM10.2857 6.50359V1.93216H1.84686C1.67086 1.93216 1.50933 2.00531 1.36229 2.15159C1.21524 2.29788 1.1421 2.45902 1.14286 2.63502V19.515C1.14286 19.6903 1.216 19.8514 1.36229 19.9985C1.50857 20.1455 1.66971 20.2186 1.84571 20.2179H14.1543C14.3295 20.2179 14.4907 20.1447 14.6377 19.9985C14.7848 19.8522 14.8579 19.6906 14.8571 19.5139V6.50359H10.2857Z" fill="#0052CC"/>
                    </svg>
                    <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Use Case Documents</h2>
                </div>
            </div>

            <#assign documentationContent = [] />

            <#assign doc1 = {
            "title": "One Simple Change to Make Bamboo Login Effortless and Secure!",
            "description": "Secure Bamboo login with miniOrange OAuth SSO—automate onboarding, streamline access, and ensure compliance with seamless IdP integration.",
            "link": "https://www.miniorange.com/atlassian/oauth-login-user-management-jira-confluence-data-center/"
            } />

            <#assign doc2= {
            "title": "Still Manually Logging Out from Every App? Here's the Smart Fix!",
            "description": "Simplify logouts effortlessly with miniOrange SLO for Bamboo.",
            "link": "https://www.miniorange.com/atlassian/single-logout-jira-confluence-connected-apps"
            } />

            <#assign documentationContent = [doc1, doc2] />

            <div style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 24px;">
                <#foreach content in documentationContent>
                    <div style="border: 1px solid var(--border-color); border-radius: 4px; padding: 24px; transition: all 0.2s ease;" id="mo-card-bg">
                        <div style="display: flex; gap: 8px; margin-bottom: 16px;">
                            <span style="padding: 4px 8px; background: var(--tag-background); border-radius: 3px; font-size: 12px; color: var(--text-secondary);">OAuth</span>
                        </div>
                        <h3 style="font-size: 16px; color: var(--text-primary); margin: 0 0 12px 0;">${content.title}</h3>
                        <p style="font-size: 14px; color: var(--text-secondary); margin: 0 0 16px 0;">${content.description}</p>
                        <div style="display: flex; align-items: center; gap: 8px; font-size: 14px;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                <path d="M4.71796 13.7362C4.41085 13.7362 4.15462 13.6336 3.94929 13.4282C3.74396 13.2229 3.64107 12.9665 3.64062 12.6589V4.14691C3.64062 3.8398 3.74351 3.58358 3.94929 3.37825C4.15507 3.17291 4.41129 3.07002 4.71796 3.06958H8.46129V3.73625H4.71796C4.61529 3.73625 4.52107 3.77891 4.43529 3.86425C4.34951 3.94958 4.30685 4.0438 4.30729 4.14691V12.6596C4.30729 12.7618 4.34996 12.8558 4.43529 12.9416C4.52062 13.0274 4.61462 13.07 4.71729 13.0696H13.2306C13.3328 13.0696 13.4268 13.0269 13.5126 12.9416C13.5984 12.8562 13.6411 12.7622 13.6406 12.6596V8.91558H14.3073V12.6596C14.3073 12.9662 14.2046 13.2222 13.9993 13.4276C13.794 13.6329 13.5375 13.7358 13.23 13.7362H4.71796ZM7.46662 10.3829L6.99462 9.91025L13.1686 3.73625H10.3073V3.06958H14.3073V7.06958H13.6406V4.20825L7.46662 10.3829Z" fill="currentColor"/>
                            </svg>
                            <a href="${content.link}" target="_blank">View Document</a>
                        </div>
                    </div>
                </#foreach>
            </div>
        </div>
    </div>

    <div id="videosView" class="view-section">
        <div class="video-section" style="margin-top: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <svg width="22" height="23" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="none">
                        <path fill="#0000FF" fill-rule="evenodd" d="M5 5a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-1.586l2.293 2.293A1 1 0 0 0 22 16V8a1 1 0 0 0-1.707-.707L18 9.586V8a3 3 0 0 0-3-3H5z" clip-rule="evenodd"/>
                    </svg>
                    <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Use Case Videos</h2>
                </div>
            </div>

            <#assign demoVideo1 = {
            "src": "https://modemo.miniorange.com/static/media/enable-sso-with-oauth-2-0-for-atlassian-sso.2d4cdfc551334981e257.webp",
            "description": "Enable SSO with OAuth 2.0 for Atlassian",
            "link": "https://www.youtube.com/watch?v=YSIpCWzzP2A"
            } />

            <#assign demoVideoContent = [demoVideo1] />


            <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px;">
                <#foreach content in demoVideoContent>
                <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                    <div style="border: 1px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background);">
                        <div style="position: relative;">
                            <img src="${content.src}" alt="${content.description}" style="width: 100%; height: 100px; object-fit: cover;">
                        </div>
                        <div style="padding: 12px;">
                            <p style="font-weight: bold;font-size: 12px; color: var(--text-secondary); margin: 0 0 12px 0; line-height: 1.4;">${content.description}</p>
                        </div>
                    </div>
                </a>
                </#foreach>
            </div>
        </div>

        <div class="video-section" style="margin-top: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 24px;">
                <div style="display: flex; align-items: center; gap: 8px;">
                    <svg width="22" height="23" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="none">
                        <path fill="#0000FF" fill-rule="evenodd" d="M5 5a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h10a3 3 0 0 0 3-3v-1.586l2.293 2.293A1 1 0 0 0 22 16V8a1 1 0 0 0-1.707-.707L18 9.586V8a3 3 0 0 0-3-3H5z" clip-rule="evenodd"/>
                    </svg>
                    <h2 style="font-size: 20px; color: var(--text-primary); margin: 0;">Setup Videos</h2>
                </div>
            </div>

            <#assign setupVideo1 = {
            "src": "https://i.ytimg.com/vi/dZflj0IIPTI/maxresdefault.jpg",
            "description": "Bamboo Single Sign On With Custom OpenID",
            "link": "https://www.youtube.com/watch?v=dZflj0IIPTI&t=4s"
            } />

            <#assign setupVideo2 = {
            "src": "https://i.ytimg.com/vi/Z3K_zKIiQSI/maxresdefault.jpg",
            "description": "Bamboo Single Sign On With Custom OAuth",
            "link": "https://www.youtube.com/watch?v=Z3K_zKIiQSI"
            } />

            <#assign setupVideoContent = [setupVideo1, setupVideo2] />


            <div style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 16px;">
                <#foreach content in setupVideoContent>
                    <a href="${content.link}" target="_blank" style="text-decoration: none; display: block; color: inherit;">
                        <div style="border: 1px solid var(--border-color); border-radius: 4px; overflow: hidden; background: var(--card-background);">
                            <div style="position: relative;">
                                <img src="${content.src}" alt="${content.description}" style="width: 100%; height: 100px; object-fit: cover;">
                            </div>
                            <div style="padding: 12px;">
                                <p style="font-weight: bold;font-size: 12px; color: var(--text-secondary); margin: 0 0 12px 0; line-height: 1.4;">${content.description}</p>
                            </div>
                        </div>
                    </a>
                </#foreach>
            </div>
        </div>
    </div>

    <div id="faqView" class="view-section">
        <#include "/templates/faqs.ftl" parse=true>
    </div>
</div>
