const faqsData = [
    {
        heading: "How do I configure the logout endpoint for Keycloak?",
        summary: "Use the Keycloak version specific URL formats. For Keycloak <18, use the /auth path in the logout URL. For Keycloak >=18, omit it. For more details -",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/logout-endpoint-keycloak/"
    },
    {
        heading: 'How do I fix the "Invalid parameter: id_token_hint" error?',
        summary: "This error usually means the id_token used to validate the logout request is no longer available, either because the session expired or the token was deleted from the database. To resolve this, ensure the Logout Endpoint and \"Send ID Token\" settings are properly configured correctly for Custom OpenId. A new session login typically resolves the issue.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/handling-invalid-parameter-id-token-hint-error/"
    },
    {
        heading: "Why does SSO fail even though the test configuration works?",
        summary: "This usually happens due to missing users, attributes, or access restrictions. Ensure user creation is enabled, required attributes (email/username) are present, group/domain permissions are correct, and your license is valid.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/test-configuration-works-sso-failed/"
    },
    {
        heading: "How can I prevent new users from being created during SSO?",
        summary: "Disable the Allow User Creation option in the provider's Advanced Settings. This blocks automatic account creation during SSO, allowing only pre-existing users to log in.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/login-existing-users-without-creating-new-users/"
    },
    {
        heading: "Why am I unable to fetch groups from the Azure AD provider?",
        summary: "Make sure your Azure AD app has the User.Read and Directory.Read.All OAuth scopes granted. Verify group access in the Test Configuration and confirm these permissions are enabled in your Azure AD app settings.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/not-able-fetch-groups-azure-ad-provider/"
    },
    {
        heading: "How do I capture logs for the Bamboo OAuth Client app?",
        summary: "Enable debug logging for com.miniorange.oauth, reproduce the SSO issue, and collect the logs. Then generate a Support Zip from Troubleshooting Tools, which includes Bamboo logs needed for analysis or support.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/get-jira-oauth-client-plugin-logs/"
    },
    {
        heading: "How do I transfer app settings from staging to production?",
        summary: "Export the settings from the staging environment and import them into production using the app's backup & restore tab. This transfers all app configurations easily.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/can-transfer-app-settings-one-staging-production/"
    },
    {
        heading: "How do I choose the right Group Mapping method in the OAuth plugin?",
        summary: "Use On-The-Fly Group Mapping to auto-create and assign groups based on the IdP response. Choose Manual Mapping for full control—ideal when group names differ between the IdP and the application.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/jira-oauth-group-mapping-options-miniorange/"
    },
    {
        heading: "How do I fix a redirect loop when SSO fails in Bamboo?",
        summary: "A redirect loop usually occurs when Auto-Redirect is enabled and SSO fails. Use the Emergency URL to log in locally, then disable Auto-Redirect in Sign-In Settings. If the Emergency URL isn't active, enable it via the REST API.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/jira-oauth-sso-redirection-issues-fix-miniorange/"
    },
    {
        heading: "How do I change the UserInfo endpoint to use a custom Okta Authorization Server?",
        summary: "Switch to Custom OIDC Provider in the plugin settings, then enter your custom Authorization, Token, and UserInfo endpoints. Make sure your Okta authorization server has the correct scopes and access policies configured.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/configure-custom-okta-authorization-server-userinfo-endpoint/"
    },
    {
        heading: "How do I resolve MO_OAUTH_ERROR_00007 with Microsoft Azure AD?",
        summary: "This error occurs due to a misconfigured token endpoint. Set up Azure AD as a Custom OpenID Provider, and manually enter the Authorization, Token, and UserInfo endpoints—especially for non-default tenants or B2C environments.",
        readMoreLink: "https://faq.miniorange.com/knowledgebase/fix-mo-oauth-error-00007-microsoft-azure-ad/"
    },
];

var faqsPerPage = 8;
var currentPage = 1;

function getFaqSearchInputValue() {
    var searchInput = document.getElementById('faq-search');
    return searchInput ? searchInput.value.trim().toLowerCase() : '';
}

function displayFilteredFaqs(searchTerm, page) {
    var content = document.getElementById('faq-content');
    var noResults = document.querySelector('.faq-no-results');
    if (!content) return;
    content.innerHTML = '';

    var faqs = faqsData;
    if (typeof searchTerm === 'undefined') searchTerm = getFaqSearchInputValue();
    if (typeof page === 'undefined') page = currentPage;
    if (searchTerm) {
        faqs = faqs.filter(function(faq) {
            return (
                faq.heading.toLowerCase().includes(searchTerm) ||
                faq.summary.toLowerCase().includes(searchTerm)
            );
        });
    }

    var totalPages = Math.ceil(faqs.length / faqsPerPage);
    if (faqs.length === 0) {
        if (noResults) noResults.style.display = '';
        return;
    } else {
        if (noResults) noResults.style.display = 'none';
    }

    if (page < 1) page = 1;
    if (page > totalPages) page = totalPages;
    currentPage = page;

    var startIdx = (page - 1) * faqsPerPage;
    var endIdx = startIdx + faqsPerPage;
    var faqsToShow = faqs.slice(startIdx, endIdx);

    var col1 = document.createElement('div');
    col1.className = 'faq-column';
    var col2 = document.createElement('div');
    col2.className = 'faq-column';
    faqsToShow.forEach(function(faq, idx) {
        var item = document.createElement('div');
        item.className = 'faq-item';
        item.innerHTML =
            '<div class="faq-question"><h3>' + faq.heading + '</h3><span class="faq-icon"></span></div>' +
            '<div class="faq-answer" style="max-height:0;overflow:hidden;transition:max-height 0.4s cubic-bezier(0.4,0,0.2,1),padding 0.4s;">'
            + '<p>' + faq.summary + '</p>' +
            '<a href="' + faq.readMoreLink + '" target="_blank">Read more</a></div>';
        var question = item.querySelector('.faq-question');
        var answer = item.querySelector('.faq-answer');
        question.onclick = function() {
            var isActive = item.classList.toggle('active');
            if (isActive) {
                answer.style.maxHeight = answer.scrollHeight + 32 + 'px';
                answer.style.padding = '0 16px 16px';
            } else {
                answer.style.maxHeight = '0';
                answer.style.padding = '0 16px';
            }
        };
        answer.style.padding = '0 16px';
        if (idx < Math.ceil(faqsToShow.length / 2)) {
            col1.appendChild(item);
        } else {
            col2.appendChild(item);
        }
    });
    var row = document.createElement('div');
    row.style.display = 'grid';
    row.style.gridTemplateColumns = '1fr 1fr';
    row.style.gap = '32px';
    row.appendChild(col1);
    row.appendChild(col2);
    content.appendChild(row);

    var pagination = document.createElement('div');
    pagination.className = 'faq-pagination';
    pagination.style.textAlign = 'center';
    pagination.style.margin = '24px 0';

    var prevBtn = document.createElement('button');
    prevBtn.textContent = 'Previous';
    prevBtn.disabled = (page === 1);
    prevBtn.onclick = function() { displayFilteredFaqs(searchTerm, page - 1); };
    pagination.appendChild(prevBtn);

    for (var i = 1; i <= totalPages; i++) {
        var pageBtn = document.createElement('button');
        pageBtn.textContent = i;
        if (i === page) pageBtn.className = 'active';
        pageBtn.onclick = (function(i) {
            return function() { displayFilteredFaqs(searchTerm, i); };
        })(i);
        pagination.appendChild(pageBtn);
    }

    var nextBtn = document.createElement('button');
    nextBtn.textContent = 'Next';
    nextBtn.disabled = (page === totalPages);
    nextBtn.onclick = function() { displayFilteredFaqs(searchTerm, page + 1); };
    pagination.appendChild(nextBtn);

    content.appendChild(pagination);
}

document.addEventListener('DOMContentLoaded', function() {
    displayFilteredFaqs();
    initializeFaqSearchHandler();
});

function initializeFaqSearchHandler() {
    var searchInput = document.getElementById('faq-search');
    if (!searchInput) return;
    var debounceTimeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(function() {
            displayFilteredFaqs(getFaqSearchInputValue(), 1);
        }, 200);
    });
}

