const faqsData=[{heading:"How do I configure the logout endpoint for Keycloak?",summary:"Use the Keycloak version specific URL formats. For Keycloak <18, use the /auth path in the logout URL. For Keycloak >=18, omit it. For more details -",readMoreLink:"https://faq.miniorange.com/knowledgebase/logout-endpoint-keycloak/"},{heading:'How do I fix the "Invalid parameter: id_token_hint" error?',summary:'This error usually means the id_token used to validate the logout request is no longer available, either because the session expired or the token was deleted from the database. To resolve this, ensure the Logout Endpoint and "Send ID Token" settings are properly configured correctly for Custom OpenId. A new session login typically resolves the issue.',readMoreLink:"https://faq.miniorange.com/knowledgebase/handling-invalid-parameter-id-token-hint-error/"},{heading:"Why does SSO fail even though the test configuration works?",summary:"This usually happens due to missing users, attributes, or access restrictions. Ensure user creation is enabled, required attributes (email/username) are present, group/domain permissions are correct, and your license is valid.",readMoreLink:"https://faq.miniorange.com/knowledgebase/test-configuration-works-sso-failed/"},{heading:"How can I prevent new users from being created during SSO?",summary:"Disable the Allow User Creation option in the provider's Advanced Settings. This blocks automatic account creation during SSO, allowing only pre-existing users to log in.",readMoreLink:"https://faq.miniorange.com/knowledgebase/login-existing-users-without-creating-new-users/"},{heading:"Why am I unable to fetch groups from the Azure AD provider?",summary:"Make sure your Azure AD app has the User.Read and Directory.Read.All OAuth scopes granted. Verify group access in the Test Configuration and confirm these permissions are enabled in your Azure AD app settings.",readMoreLink:"https://faq.miniorange.com/knowledgebase/not-able-fetch-groups-azure-ad-provider/"},{heading:"How do I capture logs for the Bamboo OAuth Client app?",summary:"Enable debug logging for com.miniorange.oauth, reproduce the SSO issue, and collect the logs. Then generate a Support Zip from Troubleshooting Tools, which includes Bamboo logs needed for analysis or support.",readMoreLink:"https://faq.miniorange.com/knowledgebase/get-jira-oauth-client-plugin-logs/"},{heading:"How do I transfer app settings from staging to production?",summary:"Export the settings from the staging environment and import them into production using the app's backup & restore tab. This transfers all app configurations easily.",readMoreLink:"https://faq.miniorange.com/knowledgebase/can-transfer-app-settings-one-staging-production/"},{heading:"How do I choose the right Group Mapping method in the OAuth plugin?",summary:"Use On-The-Fly Group Mapping to auto-create and assign groups based on the IdP response. Choose Manual Mapping for full control—ideal when group names differ between the IdP and the application.",readMoreLink:"https://faq.miniorange.com/knowledgebase/jira-oauth-group-mapping-options-miniorange/"},{heading:"How do I fix a redirect loop when SSO fails in Bamboo?",summary:"A redirect loop usually occurs when Auto-Redirect is enabled and SSO fails. Use the Emergency URL to log in locally, then disable Auto-Redirect in Sign-In Settings. If the Emergency URL isn't active, enable it via the REST API.",readMoreLink:"https://faq.miniorange.com/knowledgebase/jira-oauth-sso-redirection-issues-fix-miniorange/"},{heading:"How do I change the UserInfo endpoint to use a custom Okta Authorization Server?",summary:"Switch to Custom OIDC Provider in the plugin settings, then enter your custom Authorization, Token, and UserInfo endpoints. Make sure your Okta authorization server has the correct scopes and access policies configured.",readMoreLink:"https://faq.miniorange.com/knowledgebase/configure-custom-okta-authorization-server-userinfo-endpoint/"},{heading:"How do I resolve MO_OAUTH_ERROR_00007 with Microsoft Azure AD?",summary:"This error occurs due to a misconfigured token endpoint. Set up Azure AD as a Custom OpenID Provider, and manually enter the Authorization, Token, and UserInfo endpoints—especially for non-default tenants or B2C environments.",readMoreLink:"https://faq.miniorange.com/knowledgebase/fix-mo-oauth-error-00007-microsoft-azure-ad/"},];var faqsPerPage=8;var currentPage=1;function getFaqSearchInputValue(){var a=document.getElementById("faq-search");return a?a.value.trim().toLowerCase():""}function displayFilteredFaqs(f,n){var m=document.getElementById("faq-content");var o=document.querySelector(".faq-no-results");if(!m){return}m.innerHTML="";var b=faqsData;if(typeof f==="undefined"){f=getFaqSearchInputValue()}if(typeof n==="undefined"){n=currentPage}if(f){b=b.filter(function(i){return(i.heading.toLowerCase().includes(f)||i.summary.toLowerCase().includes(f))})}var k=Math.ceil(b.length/faqsPerPage);if(b.length===0){if(o){o.style.display=""}return}else{if(o){o.style.display="none"}}if(n<1){n=1}if(n>k){n=k}currentPage=n;var p=(n-1)*faqsPerPage;var c=p+faqsPerPage;var d=b.slice(p,c);var l=document.createElement("div");l.className="faq-column";var j=document.createElement("div");j.className="faq-column";d.forEach(function(t,i){var u=document.createElement("div");u.className="faq-item";u.innerHTML='<div class="faq-question"><h3>'+t.heading+'</h3><span class="faq-icon"></span></div><div class="faq-answer" style="max-height:0;overflow:hidden;transition:max-height 0.4s cubic-bezier(0.4,0,0.2,1),padding 0.4s;"><p>'+t.summary+'</p><a href="'+t.readMoreLink+'" target="_blank">Read more</a></div>';var s=u.querySelector(".faq-question");var v=u.querySelector(".faq-answer");s.onclick=function(){var w=u.classList.toggle("active");if(w){v.style.maxHeight=v.scrollHeight+32+"px";v.style.padding="0 16px 16px"}else{v.style.maxHeight="0";v.style.padding="0 16px"}};v.style.padding="0 16px";if(i<Math.ceil(d.length/2)){l.appendChild(u)}else{j.appendChild(u)}});var r=document.createElement("div");r.style.display="grid";r.style.gridTemplateColumns="1fr 1fr";r.style.gap="32px";r.appendChild(l);r.appendChild(j);m.appendChild(r);var q=document.createElement("div");q.className="faq-pagination";q.style.textAlign="center";q.style.margin="24px 0";var e=document.createElement("button");e.textContent="Previous";e.disabled=(n===1);e.onclick=function(){displayFilteredFaqs(f,n-1)};q.appendChild(e);for(var h=1;h<=k;h++){var g=document.createElement("button");g.textContent=h;if(h===n){g.className="active"}g.onclick=(function(s){return function(){displayFilteredFaqs(f,s)}})(h);q.appendChild(g)}var a=document.createElement("button");a.textContent="Next";a.disabled=(n===k);a.onclick=function(){displayFilteredFaqs(f,n+1)};q.appendChild(a);m.appendChild(q)}document.addEventListener("DOMContentLoaded",function(){displayFilteredFaqs();initializeFaqSearchHandler()});function initializeFaqSearchHandler(){var a=document.getElementById("faq-search");if(!a){return}var b;a.addEventListener("input",function(){clearTimeout(b);b=setTimeout(function(){displayFilteredFaqs(getFaqSearchInputValue(),1)},200)})};