/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class MoOAuthHttpUtils {
    private static Log LOGGER = LogFactory.getLog(MoOAuthHttpUtils.class);
    public static final String CONTENT_TYPE_JSON = "application/json";

    public static String sendPostRequest(String url, List<NameValuePair> data, String contentType, HashMap headers) {
        try {
            LOGGER.debug((Object)("HttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data));
            CloseableHttpClient httpClient = MoOAuthHttpUtils.getHttpClient();
            LOGGER.debug((Object)("httpClient : " + httpClient));
            LOGGER.debug((Object)("Hitting URL : " + url));
            HttpPost postRequest = new HttpPost(url);
            LOGGER.debug((Object)("Post Request : " + postRequest.toString()));
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data);
            entity.setContentType(contentType);
            postRequest.setEntity((HttpEntity)entity);
            LOGGER.debug((Object)("Executing post request : " + postRequest.toString()));
            return MoOAuthHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error in sending post request, " + e.toString()));
            e.printStackTrace();
            return "Failed";
        }
    }

    public static String sendPostRequest(String url, String data, String contentType, HashMap headers) {
        try {
            LOGGER.debug((Object)("MoHttpUtils sendPostRequest Sending POST request to " + url + " with payload " + data));
            CloseableHttpClient httpClient = MoOAuthHttpUtils.getHttpClient();
            HttpPost postRequest = new HttpPost(url);
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        postRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            StringEntity input = new StringEntity(data);
            input.setContentType(contentType);
            postRequest.setEntity((HttpEntity)input);
            return MoOAuthHttpUtils.executePostRequest(httpClient, postRequest);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error in sending post request, " + e.toString()));
            e.printStackTrace();
            return "Failed";
        }
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
            LOGGER.debug((Object)("Response for HTTP Request: " + response.toString() + " and Status Code: " + response.getStatusLine().getStatusCode()));
            if (response.getEntity() != null) {
                String output;
                LOGGER.debug((Object)"Response Entity found. Reading Response payload.");
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                LOGGER.debug((Object)("Response payload: " + status));
                httpClient.close();
                LOGGER.debug((Object)("Status" + status));
                return status;
            }
            LOGGER.debug((Object)"Response Entity NOT found. Returning EMPTY string.");
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error in executing post request, " + e.toString()));
            e.printStackTrace();
            return "Failed";
        }
    }

    private static CloseableHttpClient getHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOGGER.debug((Object)"sending SSL context as true");
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
        BasicHttpClientConnectionManager ccm = new BasicHttpClientConnectionManager((Lookup)registry);
        builder.setConnectionManager((HttpClientConnectionManager)ccm);
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        CloseableHttpClient httpclient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).setConnectionManager((HttpClientConnectionManager)ccm).build();
        LOGGER.debug((Object)("httpclient : " + httpclient));
        return httpclient;
    }

    public static String sendGetRequestWithHeaders(String url, HashMap headers) {
        try {
            String output;
            CloseableHttpClient httpClient = MoOAuthHttpUtils.getHttpClient();
            HttpGet getRequest = new HttpGet(url);
            LOGGER.debug((Object)("Sending HTTP Request to URL " + url));
            if (headers != null) {
                Iterator iterator = headers.entrySet().iterator();
                if (!headers.isEmpty()) {
                    while (iterator.hasNext()) {
                        Map.Entry pairs = iterator.next();
                        getRequest.setHeader(pairs.getKey().toString(), pairs.getValue().toString());
                    }
                }
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            LOGGER.debug((Object)("Response for HTTP Request to URL " + url + " response: " + response.toString() + " \n status code: " + response.getStatusLine().getStatusCode()));
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 300) {
                LOGGER.debug((Object)"Response status code out of range 200-300");
                return "Failed";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String responseString = "";
            while ((output = br.readLine()) != null) {
                responseString = responseString + output;
            }
            LOGGER.debug((Object)("Response string HTTP Request to URL " + url + "\n response string: \n " + responseString));
            httpClient.getConnectionManager().shutdown();
            return responseString;
        }
        catch (Exception e) {
            return "Failed";
        }
    }

    public static void setCookie(String cookieName, String cookieValue, HttpServletResponse response) {
        Cookie newCookie = new Cookie(cookieName, cookieValue);
        newCookie.setPath("/");
        response.addCookie(newCookie);
    }

    public static Cookie getCookie(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void removeCookie(String cookieName, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = MoOAuthHttpUtils.getCookie(cookieName, request);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }
}

