/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.constants;

public class OAuthPluginExceptionConstant {

    public static enum OAuthPluginException {
        INVALID_SIGNATURE("MO_OAUTH_ERROR_00001", "The JWT token either expired or its signature is invalid.", "Please check the configured Public Key/Certificate or the JWT Token sent in the request."),
        INVALID_ISSUER("MO_OAUTH_ERROR_00002", "The issuer in the token does not match the configured issuer.", "Verify that the 'Issuer' value in your IdP matches the one configured in the plugin settings."),
        USER_CREATION_DISABLED("MO_OAUTH_ERROR_00003", "SSO failed because no existing account was found in the user list.", "Automatic user creation is disabled. Enable it in the plugin settings or manually create the user account."),
        MULTIPLE_USER_EMAIL("MO_OAUTH_ERROR_00004", "Multiple users have the same email address. Cannot proceed with login.", "More than one user in the application has the same email address. Please merge or differentiate the accounts to ensure unique identity."),
        TOKEN_SIGNATURE_INVALID("MO_OAUTH_ERROR_00005", "The token signature could not be validated.", "Please verify your JWKS endpoint or check your network settings."),
        INVALID_CLIENT("MO_OAUTH_ERROR_00006", "Invalid client credentials. Check Client ID and Secret.", "Please confirm that the client ID and secret match those provided by your Identity Provider."),
        INVALID_ENDPOINT_CONFIGURED("MO_OAUTH_ERROR_00007", "Invalid or unreachable authorization/token endpoint.", "Please check if all the configurations are correct."),
        INVALID_TOKEN("MO_OAUTH_ERROR_00008", "Error validating the Signature or Issuer in the Response.", "Please check if the configured public key is correct"),
        INVALID_SCOPE("MO_OAUTH_ERROR_00009", "The configured scopes are invalid or not permitted.", "Ensure the scopes are correctly spelled, permitted by the provider, and separated by proper delimiters. Refer to your IdP documentation."),
        INVALID_STATE_PARAMETER("MO_OAUTH_ERROR_00010", "Invalid or missing state parameter.", "Please check if the state parameter value you have entered is correct."),
        INVALID_NONCE("MO_OAUTH_ERROR_00011", "Invalid or reused nonce value.", "Please check if the nonce value you have entered is correct."),
        USER_NOT_ALLOWED("MO_OAUTH_ERROR_00012", "This user does not have permission to access the application.", "Verify that the user is added to a group with access to Bamboo application."),
        CANT_SIGNIN_CHECK_CONFIGURATION("MO_OAUTH_ERROR_00013", "Sign-in failed. Please check your plugin configuration.", "Check the Identity Provider configuration, client credentials, and endpoint URLs in the plugin settings."),
        INVALID_PKCE("MO_OAUTH_ERROR_00014", "Missing or invalid PKCE code challenge.", "PKCE challenge is missing or invalid. If your IdP enforces PKCE, enable it in the plugin\u2019s advanced settings."),
        NO_LICENSE_FOUND("MO_OAUTH_ERROR_00015", "The plugin license is missing or invalid.", "Please check if you have configured valid license for the plugin."),
        TOKEN_MISSING("MO_OAUTH_ERROR_00016", "No access/id token found in the response.", "Unable to find token"),
        CANT_FIND_APPLICATION("MO_OAUTH_ERROR_00017", "Application not found. Please verify the configuration.", "Please check your plugin configuration."),
        USER_IS_DEACTIVATED("MO_OAUTH_ERROR_00018", "This user is deactivated. Can't create user session.", "User is deactivated in the directory. Please reactivate the user or contact your admin for help."),
        INVALID_SSO_REQUEST("MO_OAUTH_ERROR_00019", "Invalid SSO Request,Could not create User Session", "Please contact administrator"),
        INVALID_USER_PROFILE_MAPPING("MO_OAUTH_ERROR_00020", "User profile mapping error. Please review your attribute settings.", "Please check the plugin configuration."),
        PUBLIC_KEY_OR_CERTIFICATE_NOT_CONFIGURED("MO_OAUTH_ERROR_00021", "No public key/certificate is configured to validate the token.", "Please check the plugin configuration."),
        JWT_AUTHENTICATION_DISABLED("MO_OAUTH_ERROR_00022", "JWT Authentication is currently disabled in the plugin.", "Please check the plugin configuration"),
        NO_PROVIDER_IS_ENABLED("MO_OAUTH_ERROR_00023", "No OAUTH/OIDC provider is enabled", "Please check the plugin configuration"),
        DOMAIN_NOT_ALLOWED("MO_OAUTH_ERROR_00024", "You are not allowed to log into the application.", "The user\u2019s email domain is not in the allowed list. Add the domain to the plugin\u2019s Domain Allowlist settings."),
        UNABLE_TO_CREATE_USER("MO_OAUTH_ERROR_00025", "SSO failed because no existing account was found in the user list.", "User creation failed due to missing group mapping. Check if the SSO user has groups mapped in the plugin."),
        CANNOT_CREATE_USER("MO_OAUTH_ERROR_00026", "SSO failed because no existing account was found in the user list.", "The plugin is unable to create a new user in the external directory. Check directory permissions or sync settings."),
        INVALID_USER_INFO_ENDPOINT("MO_OAUTH_ERROR_00027", "Invalid or unreachable user info endpoint.", "Please check if all the configurations are correct."),
        UNKNOWN("An unknown error occurred", "", "");

        String errorCode;
        String errorMessage;
        String resolution;

        private OAuthPluginException(String errorCode, String errorMessage, String resolution) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            this.resolution = resolution;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getResolution() {
            return this.resolution;
        }

        public void setResolution(String resolution) {
            this.resolution = resolution;
        }
    }
}

