/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginConfigurationsHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class MoOAuthUploadConfigurationsServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthUploadConfigurationsServlet.class);
    private MoOAuthSettings settings;
    private MoOAuthPluginConfigurationsHandler pluginConfigurationsHandler;
    private String xsrfToken;
    private UserManager userManager;

    public MoOAuthUploadConfigurationsServlet(MoOAuthSettings settings, MoOAuthPluginConfigurationsHandler pluginConfigurationsHandler) {
        this.settings = settings;
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referer = request.getHeader("referer");
        if (this.settings.getPluginApiAccessRestriction().booleanValue() && !StringUtils.startsWith((CharSequence)referer, (CharSequence)this.settings.getBaseUrl())) {
            LOGGER.error((Object)"Access Denied. API Restriction is enabled and request is not originated from the Bamboo.");
            response.sendError(403, "Access Denied. You are not allowed to access this page.");
            return;
        }
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        LOGGER.info((Object)"MoOAuthUploadConfigurationServlet: doPost  called");
        MoOAuthSettings.isPluginConfigurationFileUploaded = Boolean.TRUE;
        try {
            this.handleUploadConfigurations(request);
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.settings.setConfigurationStatus("An error occurred while saving your details.Please check logs for more info.");
            response.sendRedirect(this.settings.getImportExportPageUrl());
        }
    }

    private void handleUploadConfigurations(HttpServletRequest request) throws IOException {
        LOGGER.info((Object)"handleUploadConfigurations called");
        String fileContents = "";
        MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
        UploadedFile[] files = wrapper.getFiles("configFile");
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UploadedFile file = files[i];
                if (!file.isFile()) continue;
                try {
                    fileContents = FileUtils.readFileToString((File)file.getContent());
                    if (StringUtils.isEmpty((CharSequence)fileContents)) {
                        this.settings.setConfigurationStatus("Empty file uploaded");
                        LOGGER.error((Object)"Empty file uploaded");
                        return;
                    }
                    this.pluginConfigurationsHandler.importConfigurations((File)file.getContent());
                    this.settings.setConfigurationStatus("success");
                    return;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    LOGGER.debug((Object)("JSONException message = " + e.getMessage()));
                    this.settings.setConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
                    continue;
                }
                catch (MoOAuthPluginException e) {
                    e.printStackTrace();
                    LOGGER.debug((Object)("Exception message = " + e.getMessage()));
                    this.settings.setConfigurationStatus(e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.debug((Object)("exception message = " + e.getMessage()));
                    LOGGER.error((Object)"Invalid file is provided. Could not parse app configuration file.");
                    this.settings.setConfigurationStatus("Invalid file is  provided. Could not parse app configuration file.");
                    return;
                }
            }
        }
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public MoOAuthPluginConfigurationsHandler getPluginConfigurationsHandler() {
        return this.pluginConfigurationsHandler;
    }

    public void setPluginConfigurationsHandler(MoOAuthPluginConfigurationsHandler pluginConfigurationsHandler) {
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
    }
}

