/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.oauth.bamboo.MoOAuthManager;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class MoOAuthLogoutServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoOAuthLogoutServlet.class);
    private MoOAuthSettings settings;
    private MoOAuthManager oauthManager;
    private final TemplateRenderer renderer;

    public MoOAuthLogoutServlet(MoOAuthSettings settings, MoOAuthManager oAuthManager, TemplateRenderer renderer) {
        this.settings = settings;
        this.oauthManager = oAuthManager;
        this.renderer = renderer;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        LOGGER.debug("MoOAuthLogoutServlet doGet called");
        HttpSession session = req.getSession();
        Cookie logoutCookie = MoOAuthHttpUtils.getCookie("mo.bamboo-oauth.logoutcookie", req);
        if (logoutCookie != null) {
            MoOAuthHttpUtils.removeCookie("mo.bamboo-oauth.logoutcookie", req, res);
            session.invalidate();
            if (StringUtils.isNotEmpty((CharSequence)this.settings.getSingleLogoutURL())) {
                LOGGER.debug("Redirect to single logout url: " + this.settings.getSingleLogoutURL());
                if (this.settings.getAppName().equals("Okta") || this.settings.getAppName().equals("Keycloak")) {
                    String id_token_logout_url = "";
                    Cookie id_token_cookie = MoOAuthHttpUtils.getCookie("id_token_cookie", req);
                    String id_token = "";
                    if (id_token_cookie != null) {
                        id_token = id_token_cookie.getValue();
                    }
                    id_token_logout_url = this.settings.getSingleLogoutURL().contains("?") ? this.settings.getSingleLogoutURL() + "&id_token_hint=" + id_token : this.settings.getSingleLogoutURL() + "?id_token_hint=" + id_token;
                    LOGGER.debug("Redirect to OIDC single logout url : " + id_token_logout_url);
                    MoOAuthManager.httpRedirect(res, id_token_logout_url);
                } else {
                    LOGGER.debug("Redirect to single logout url : " + this.settings.getSingleLogoutURL());
                    MoOAuthManager.httpRedirect(res, this.settings.getSingleLogoutURL());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)this.settings.getCustomLogoutURL())) {
                MoOAuthManager.httpRedirect(res, this.settings.getCustomLogoutURL());
            } else if (this.settings.getEnableLogoutTemplate().booleanValue()) {
                this.redirectToLogoutTemplate(res);
            } else {
                MoOAuthManager.httpRedirect(res, this.settings.getBaseUrl());
            }
        } else {
            MoOAuthManager.httpRedirect(res, this.settings.getBaseUrl());
        }
    }

    private void redirectToLogoutTemplate(HttpServletResponse response) throws IOException {
        try {
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("baseURL", this.settings.getBaseUrl());
            StringBuffer result = new StringBuffer(this.renderer.renderFragment(this.settings.getLogoutTemplate(), context));
            response.setContentType("text/html;charset=utf-8");
            response.getWriter().write(result.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            MoOAuthManager.httpRedirect(response, this.settings.getLoginPageUrl());
        }
    }
}

