/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.miniorange.oauth.bamboo.MoOAuthPluginConfigurationsHandler;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
public class MoOAuthCreateUserServlet
extends HttpServlet {
    private Log LOGGER = LogFactory.getLog(MoOAuthCreateUserServlet.class);
    private BambooUserManager bambooUserManager;
    private BambooPermissionManager bambooPermissionManager;
    private MoOAuthPluginConfigurationsHandler moOAuthPluginConfigurationsHandler;

    public MoOAuthCreateUserServlet(BambooUserManager bambooUserManager, BambooPermissionManager bambooPermissionManager, MoOAuthPluginConfigurationsHandler moOAuthPluginConfigurationsHandler) {
        this.bambooUserManager = bambooUserManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.moOAuthPluginConfigurationsHandler = moOAuthPluginConfigurationsHandler;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.LOGGER.debug((Object)"POST: User create servlet");
        String actioneType = req.getParameter("action");
        this.LOGGER.debug((Object)("action to perform : " + actioneType));
        if (StringUtils.equals((CharSequence)actioneType, (CharSequence)"createUser")) {
            this.streamResponse(resp, this.createUser(req));
        } else if (StringUtils.equals((CharSequence)actioneType, (CharSequence)"saveUser")) {
            this.streamResponse(resp, this.saveUser(req));
        } else if (StringUtils.equals((CharSequence)actioneType, (CharSequence)"updateGroups")) {
            this.streamResponse(resp, this.addOrRemoveUserToGroups(req));
        } else if (StringUtils.equals((CharSequence)actioneType, (CharSequence)"createGroup")) {
            this.streamResponse(resp, this.createGroup(req));
        } else if (StringUtils.equals((CharSequence)actioneType, (CharSequence)"resetSettings")) {
            this.moOAuthPluginConfigurationsHandler.clearPluginSettings();
        }
    }

    public BambooUser createUser(HttpServletRequest req) {
        this.LOGGER.debug((Object)"Creating new users");
        BambooUser createdBambooUser = null;
        String username = req.getParameter("username");
        String email = req.getParameter("email");
        String fullName = req.getParameter("fullname");
        String password = this.getRandomPassword();
        String groupListJson = req.getParameter("groups");
        this.LOGGER.debug((Object)"Parameter received in Create user servlet");
        this.LOGGER.debug((Object)(username + " " + email + " " + fullName + " " + password + " " + groupListJson));
        List<String> groupsToAssign = this.parseGroups(groupListJson);
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)email)) {
            this.LOGGER.debug((Object)"Calling add user function");
            createdBambooUser = this.bambooUserManager.addUser(username, password, email, fullName, "", groupsToAssign);
        }
        return createdBambooUser;
    }

    public BambooUser saveUser(HttpServletRequest req) {
        this.LOGGER.debug((Object)"Updating existing users profile.");
        BambooUser createdBambooUser = null;
        String username = req.getParameter("username");
        String email = req.getParameter("email");
        String fullName = req.getParameter("fullname");
        User user = this.bambooUserManager.getUser(username);
        DefaultUser defaultUser = new DefaultUser(user);
        defaultUser.setFullName(fullName);
        defaultUser.setEmail(email);
        this.bambooUserManager.saveUser((User)defaultUser);
        createdBambooUser = this.bambooUserManager.getBambooUser(user);
        return createdBambooUser;
    }

    public BambooUser createGroup(HttpServletRequest req) {
        this.LOGGER.info((Object)"Creating New group");
        String username = req.getParameter("username");
        String groupToCreate = req.getParameter("group_to_create");
        this.bambooUserManager.createGroup(groupToCreate);
        User user = this.bambooUserManager.getUser(username);
        return this.bambooUserManager.getBambooUser(user);
    }

    public BambooUser addOrRemoveUserToGroups(HttpServletRequest req) {
        this.LOGGER.debug((Object)"Updating groups of the user ");
        BambooUser createdBambooUser = null;
        String username = req.getParameter("username");
        this.LOGGER.debug((Object)("Bamboo user : " + username));
        List<String> groupsToAssign = this.parseGroups(req.getParameter("groups"));
        this.LOGGER.debug((Object)("group to assign to the user : " + groupsToAssign.toString()));
        List existingGroupsOfUser = new ArrayList();
        existingGroupsOfUser = this.bambooUserManager.getGroupNamesAsList((User)this.bambooUserManager.getBambooUser(username));
        this.LOGGER.debug((Object)("Existing groups of the user : " + existingGroupsOfUser));
        if (!groupsToAssign.isEmpty()) {
            for (String newGroups : groupsToAssign) {
                if (existingGroupsOfUser.contains(newGroups)) continue;
                this.LOGGER.debug((Object)("Adding user: " + username + " to group : " + newGroups));
                this.bambooUserManager.addMembership(newGroups, username);
            }
        }
        for (String groups : existingGroupsOfUser) {
            if (groupsToAssign.contains(groups)) continue;
            this.LOGGER.debug((Object)("Removing user: " + username + " from group : " + groups));
            this.bambooUserManager.removeMembership(groups, username);
        }
        User user = this.bambooUserManager.getUser(username);
        createdBambooUser = this.bambooUserManager.getBambooUser(user);
        this.LOGGER.debug((Object)("Bamboo user : " + createdBambooUser.toString()));
        return createdBambooUser;
    }

    public List<String> parseGroups(String groupListJson) {
        if (StringUtils.isBlank((CharSequence)groupListJson)) {
            return new ArrayList<String>();
        }
        Gson gson = new Gson();
        JsonParser parser = new JsonParser();
        JsonArray groupListJsonArray = parser.parse(groupListJson).getAsJsonArray();
        Type listType = new TypeToken<List<String>>(){}.getType();
        List groupsToAssign = (List)gson.fromJson((JsonElement)groupListJsonArray, listType);
        return groupsToAssign;
    }

    public void streamResponse(HttpServletResponse resp, BambooUser createdBambooUser) throws IOException {
        try {
            this.LOGGER.debug((Object)"streamResponse : Forming response");
            String attrsJSON = createdBambooUser.getName();
            this.LOGGER.debug((Object)("Response attribute : " + attrsJSON));
            resp.setContentType("text/plain");
            resp.getOutputStream().write(attrsJSON.getBytes());
            resp.getOutputStream().close();
        }
        catch (Exception e) {
            this.LOGGER.error((Object)"Exception occurred while getting bamboo user.");
        }
    }

    public String getRandomPassword() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }
}

