/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.bamboo.action.MoOAuthAction;
import com.miniorange.oauth.bamboo.dto.TokenResponse;
import com.miniorange.oauth.bamboo.factory.IProtocolAction;
import com.miniorange.oauth.utils.MoOAuthHttpUtils;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class MoOAuthUserManager {
    private static BambooUserManager bambooUserManager;
    private static Log LOGGER;
    private static MoOAuthSettings settings;
    private static JsonParser parser;
    private static Gson gson;

    public MoOAuthUserManager(BambooUserManager bambooUserManager, MoOAuthSettings settings) {
        MoOAuthUserManager.bambooUserManager = bambooUserManager;
        MoOAuthUserManager.settings = settings;
    }

    public static BambooUser createAPICall(String actionType, String userIdentity, String email, String fullName, List<String> groupsToAssign) {
        BambooUser createdBambooUser = null;
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", actionType));
        postParameters.add((NameValuePair)new BasicNameValuePair("username", userIdentity));
        postParameters.add((NameValuePair)new BasicNameValuePair("email", email));
        postParameters.add((NameValuePair)new BasicNameValuePair("fullname", fullName));
        postParameters.add((NameValuePair)new BasicNameValuePair("groups", gson.toJson(groupsToAssign)));
        String username = MoOAuthHttpUtils.sendPostRequest(settings.getCreateUserUrl(), postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("user created " + username));
        if (StringUtils.isNotBlank((CharSequence)username)) {
            createdBambooUser = bambooUserManager.getBambooUser(username);
        }
        return createdBambooUser;
    }

    public static BambooUser saveAPICall(String actionType, String userIdentity, String email, String fullName) {
        BambooUser savedUser = null;
        User user = bambooUserManager.getUser(userIdentity);
        DefaultUser defaultUser = new DefaultUser(user);
        defaultUser.setFullName(fullName);
        defaultUser.setEmail(email);
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", actionType));
        postParameters.add((NameValuePair)new BasicNameValuePair("username", userIdentity));
        postParameters.add((NameValuePair)new BasicNameValuePair("email", email));
        postParameters.add((NameValuePair)new BasicNameValuePair("fullname", fullName));
        String username = MoOAuthHttpUtils.sendPostRequest(settings.getCreateUserUrl(), postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("user saved " + username));
        if (StringUtils.isNotBlank((CharSequence)username)) {
            savedUser = bambooUserManager.getBambooUser(username);
        }
        return savedUser;
    }

    public static void groupUpdateAPICall(String actionType, String userIdentity, List<String> groupsToAssign) {
        LOGGER.debug((Object)"groupUpdateAPICall: Preparing post parameter for REST Call");
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", actionType));
        postParameters.add((NameValuePair)new BasicNameValuePair("username", userIdentity));
        postParameters.add((NameValuePair)new BasicNameValuePair("groups", gson.toJson(groupsToAssign)));
        LOGGER.debug((Object)("Post parameters : " + postParameters.toString()));
        String username = MoOAuthHttpUtils.sendPostRequest(settings.getCreateUserUrl(), postParameters, "application/x-www-form-urlencoded", null);
        LOGGER.debug((Object)("user updated " + username));
    }

    public static void groupCreateAPICall(String actionType, String userIdentity, String groupsToCreate) {
        LOGGER.debug((Object)"groupCreateAPICall");
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        postParameters.add((NameValuePair)new BasicNameValuePair("action", actionType));
        postParameters.add((NameValuePair)new BasicNameValuePair("username", userIdentity));
        postParameters.add((NameValuePair)new BasicNameValuePair("group_to_create", groupsToCreate));
        String username = MoOAuthHttpUtils.sendPostRequest(settings.getCreateUserUrl(), postParameters, "application/x-www-form-urlencoded", null);
    }

    public static String fetchUserInfo(HttpServletRequest request, IProtocolAction protocolAction) {
        String accessTokenResponse = MoOAuthUserManager.getAndSetAccessAndRefreshToken(request, protocolAction);
        if (StringUtils.equals((CharSequence)accessTokenResponse, (CharSequence)"invalid_token")) {
            return "invalid_token";
        }
        try {
            JsonObject responseJson = JsonParser.parseString(accessTokenResponse).getAsJsonObject();
            String error = responseJson.has("error") ? responseJson.get("error").getAsString() : "";
            HashMap<String, String> errorMapping = new HashMap<String, String>();
            errorMapping.put("invalid_client", "unauthorized_client");
            errorMapping.put("unauthorized_client", "unauthorized_client");
            errorMapping.put("incorrect_client_credentials", "unauthorized_client");
            errorMapping.put("invalid_grant", "invalid_grant");
            errorMapping.put("invalid_scope", "invalid_scope");
            errorMapping.put("HTTP 405 Method Not Allowed", "token_endpoint");
            String mappedError = (String)errorMapping.get(error);
            if (mappedError != null) {
                return mappedError;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        TokenResponse response = protocolAction.sendUserInfoRequest(accessTokenResponse, settings);
        return response.getResponse();
    }

    public static String fetchGroupInfo(JsonObject userInfodata, HttpServletRequest request, String email, String id, MoOAuthSettings settings, IProtocolAction protocolAction, MoOAuthUtils oauthUtils) throws JsonParseException {
        LOGGER.debug((Object)"Fetch Group Info");
        String refreshToken = MoOAuthUserManager.getSessionAttribute("refresh_token", request);
        String accessToken = MoOAuthUserManager.getSessionAttribute("access_token", request);
        LOGGER.debug((Object)("refresh token : " + refreshToken + "\naccess token : " + accessToken));
        if (protocolAction instanceof MoOAuthAction) {
            ((MoOAuthAction)protocolAction).setRefreshToken(refreshToken);
            ((MoOAuthAction)protocolAction).setAccessToken(accessToken);
        }
        TokenResponse tokenResponse = protocolAction.sendGroupInfoRequest(userInfodata, request, email, id, settings, oauthUtils);
        return tokenResponse.getResponse();
    }

    public static String getAndSetAccessAndRefreshToken(HttpServletRequest request, IProtocolAction protocolAction) {
        String id_token;
        TokenResponse tokenResponse = protocolAction.sendTokenRequest(settings, request.getParameter("code"), request.getSession());
        String accessTokenResponse = tokenResponse.getResponse();
        if (StringUtils.isBlank((CharSequence)accessTokenResponse) || accessTokenResponse.contains("errorCode")) {
            LOGGER.debug((Object)("Access Token : " + tokenResponse));
            return "";
        }
        JsonObject checkErrorObj = JsonParser.parseString(tokenResponse.getResponse()).getAsJsonObject();
        if (checkErrorObj.has("error")) {
            LOGGER.debug((Object)("Error : " + checkErrorObj.get("error").getAsString()));
            return tokenResponse.getResponse();
        }
        String accessToken = "";
        String refreshToken = "";
        if (StringUtils.isNotBlank((CharSequence)accessTokenResponse)) {
            if (checkErrorObj.get("access_token") != null) {
                accessToken = checkErrorObj.get("access_token").getAsString();
            }
            if (checkErrorObj.get("refresh_token") != null) {
                refreshToken = checkErrorObj.get("refresh_token").getAsString();
            }
            LOGGER.debug((Object)("Access Token : " + accessToken));
            LOGGER.debug((Object)("Refress Token : " + refreshToken));
        } else if (StringUtils.isEmpty((CharSequence)accessTokenResponse) || StringUtils.isBlank((CharSequence)accessTokenResponse) || accessTokenResponse.equals("Failed")) {
            LOGGER.error((Object)"An error occured while fetching the access token. Please check configured the access token enpoint");
            return "error";
        }
        if (MoOAuthUtils.isOpenIdProtocol(settings.getAppName()) && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{settings.getPublicKey()}) && (id_token = new JSONObject(tokenResponse.getResponse()).optString("id_token")) != null) {
            LOGGER.debug((Object)("ID Token = " + id_token));
            String[] id_token_parts = id_token.split("\\.");
            DecodedJWT jwt = JWT.decode(id_token);
            String algorithm = jwt.getAlgorithm();
            PublicKey publicKey = MoOAuthUserManager.getPublicKeyObjectFromConfiguredKey(settings.getPublicKey());
            Boolean isValid = MoOAuthUserManager.verifyTokenSignature(jwt, publicKey, algorithm);
            if (!BooleanUtils.toBoolean((Boolean)isValid)) {
                LOGGER.error((Object)"Signature Validation Failed!");
                return "invalid_token";
            }
            LOGGER.debug((Object)"Signature Validation Successfully");
        }
        HttpSession session_refresh_token = request.getSession();
        session_refresh_token.setAttribute("refresh_token", (Object)refreshToken);
        LOGGER.debug((Object)("refresh token : " + MoOAuthUserManager.getSessionAttribute("refresh_token", request)));
        HttpSession session_access_token = request.getSession();
        session_access_token.setAttribute("access_token", (Object)accessToken);
        LOGGER.debug((Object)("access token : " + MoOAuthUserManager.getSessionAttribute("access_token", request)));
        return accessTokenResponse;
    }

    public static PublicKey getPublicKeyObjectFromConfiguredKey(String configuredKey) {
        LOGGER.debug((Object)"Getting public key object from configured key");
        PublicKey publicKey = null;
        try {
            configuredKey = MoOAuthUtils.deserializePublicKey(configuredKey);
            LOGGER.debug((Object)("Deserialize public Key : " + configuredKey));
            byte[] publicBytes = Base64.decodeBase64(configuredKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(keySpec);
            LOGGER.debug((Object)("Public Key : " + publicKey.toString()));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"An error occured while generating public key object from configured key ", (Throwable)e);
        }
        return publicKey;
    }

    public static Boolean verifyTokenSignature(DecodedJWT JWTToken, PublicKey publicKey, String signatureAlgorithm) {
        try {
            LOGGER.debug((Object)("Public Key's Algorithm :  " + publicKey.getAlgorithm()));
            LOGGER.debug((Object)("Algorithm used to sign JWT : " + signatureAlgorithm));
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)signatureAlgorithm, (CharSequence)"RS512")) {
                algorithm = Algorithm.RSA512((RSAPublicKey)publicKey);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)signatureAlgorithm, (CharSequence)"RSA384")) {
                algorithm = Algorithm.RSA384((RSAPublicKey)publicKey);
            }
            LOGGER.debug((Object)("Algorithm object : " + algorithm.getName()));
            LOGGER.debug((Object)("Public Cert : " + publicKey.toString()));
            JWTVerifier verifier = JWT.require(algorithm).build();
            DecodedJWT verifiedJWT = verifier.verify(JWTToken.getToken());
            LOGGER.debug((Object)("decoded JWT Token : " + verifiedJWT.getToken()));
            LOGGER.debug((Object)"Signature Verified");
            return true;
        }
        catch (JWTVerificationException e) {
            LOGGER.error((Object)"Singnature verification failed ", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unknown exception occurs while verifying Singnature ", (Throwable)e);
            return false;
        }
    }

    public static byte[] base64UrlDecodeToBytes(String input) {
        Base64 decoder = new Base64(-1, null, true);
        byte[] decodedBytes = decoder.decode(input);
        return decodedBytes;
    }

    private static boolean verifyUsingPublicKey(byte[] data, byte[] signature, PublicKey pubKey) throws GeneralSecurityException {
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(pubKey);
        sig.update(data);
        return sig.verify(signature);
    }

    private static String getSessionAttribute(String attributeName, HttpServletRequest request) {
        HttpSession session = request.getSession();
        String token = (String)session.getAttribute(attributeName);
        return token;
    }

    static {
        LOGGER = LogFactory.getLog(MoOAuthUserManager.class);
        parser = new JsonParser();
        gson = new Gson();
    }
}

