/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo;

import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoOAuthPluginHandler {
    private static Log LOGGER = LogFactory.getLog(MoOAuthPluginHandler.class);
    private static MoOAuthSettings settings;
    private static BambooUserManager bambooUserManager;

    public MoOAuthPluginHandler(MoOAuthSettings settings, BambooUserManager bambooUserManager) {
        MoOAuthPluginHandler.settings = settings;
        MoOAuthPluginHandler.bambooUserManager = bambooUserManager;
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex(stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public static void saveOAuthConfiguration(String appName, String customAppName, String clientID, String clientSecret, String scope, String authorizeEndpoint, String accessTokenEndpoint, String userInfoEndpoint, String fetchGroupsEndpoint, Boolean useStateParameter, Boolean enableCheckIssuerFor, String checkIssuerFor, String customIssuerValue, String singleLogoutURL, Boolean nonceCheck, String publicKey, Boolean acrValueCheck, Boolean enablePKCESupport, HashMap<String, String> oauth_request_parameters, String sendTokenAuthParameterIn) {
        LOGGER.info((Object)"Saving OAuthConfiguration");
        LOGGER.debug((Object)("customAppName: " + customAppName + ", clientID: " + clientID + ", clientSecret: " + clientSecret + ", scope" + scope + ", authorizeEndpoint: " + authorizeEndpoint + ", accessTokenEndpoint: " + accessTokenEndpoint + ", userInfoEndpoint: " + userInfoEndpoint + ", fetchGroupsEndpoint: " + fetchGroupsEndpoint + ", useStateParameter: " + BooleanUtils.toBoolean((Boolean)useStateParameter) + ", enableCheckIssuerFor: " + BooleanUtils.toBoolean((Boolean)enableCheckIssuerFor) + ", checkIssuerFor: " + checkIssuerFor + ", customIssuerValue" + customIssuerValue + ", singleLogoutURL: " + singleLogoutURL + ", publicKey " + publicKey + "sendTokenAuthParameterIn" + sendTokenAuthParameterIn));
        settings.setAppName(appName);
        settings.setCustomAppName(customAppName);
        settings.setClientID(clientID);
        settings.setClientSecret(clientSecret);
        settings.setScope(scope);
        settings.setAuthorizeEndpoint(authorizeEndpoint);
        settings.setAccessTokenEndpoint(accessTokenEndpoint);
        settings.setUserInfoEndpoint(userInfoEndpoint);
        settings.setFetchGroupsEndpoint(fetchGroupsEndpoint);
        settings.setUseStateParameter(BooleanUtils.toBoolean((Boolean)useStateParameter));
        settings.setEnableCheckIssuerFor(BooleanUtils.toBoolean((Boolean)enableCheckIssuerFor));
        settings.setCheckIssuerFor(checkIssuerFor);
        settings.setCustomIssuerValue(customIssuerValue);
        settings.setSingleLogoutURL(singleLogoutURL);
        settings.setPublicKey(publicKey);
        settings.setNonceCheck(nonceCheck);
        settings.setACRValueCheck(acrValueCheck);
        settings.setEnablePKCESupport(enablePKCESupport);
        settings.setOauth_request_parameters(oauth_request_parameters);
        settings.setSendTokenAuthParameterIn(sendTokenAuthParameterIn);
    }

    public static void saveOAuthConfiguration(String appName, String appHostedOn, String clientID, String clientSecret, String scope, String tenantID, String hostName, String realmName, String domainName, Boolean enableCheckIssuerFor, String checkIssuerFor, String customIssuerValue, String singleLogoutURL, Boolean useStateParameter, Boolean nonceCheck, String publicKey, Boolean acrValueCheck, Boolean enablePKCESupport, HashMap<String, String> oauth_request_parameters) {
        LOGGER.debug((Object)("saveOAuthConfiguration saving info, appName: " + appName + ", clientID: " + clientID + "clientSecret: " + clientSecret + "scope: " + scope));
        settings.setAppName(appName);
        settings.setCustomAppName(MoOAuthUtils.sanitizeText(appName));
        domainName = MoOAuthUtils.sanitizeText(domainName);
        if (MoOAuthUtils.isOpenIdProtocol(appName)) {
            settings.setPublicKey(publicKey);
            settings.setEnableCheckIssuerFor(BooleanUtils.toBoolean((Boolean)enableCheckIssuerFor));
            settings.setCheckIssuerFor(checkIssuerFor);
            settings.setCustomIssuerValue(customIssuerValue);
        }
        if (StringUtils.equals((CharSequence)appName, (CharSequence)"Google")) {
            LOGGER.info((Object)"Setting Google App Endpoints...!");
            settings.setAccessTokenEndpoint("https://www.googleapis.com/oauth2/v3/token");
            settings.setAuthorizeEndpoint("https://accounts.google.com/o/oauth2/auth");
            settings.setUserInfoEndpoint("https://www.googleapis.com/oauth2/v1/userinfo?alt=json&");
            settings.setFetchGroupsEndpoint("https://www.googleapis.com/admin/directory/v1/groups");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Facebook")) {
            LOGGER.info((Object)"Setting Facebook App Endpoints...!");
            settings.setAccessTokenEndpoint("https://graph.facebook.com/v2.8/oauth/access_token");
            settings.setAuthorizeEndpoint("https://www.facebook.com/dialog/oauth");
            settings.setUserInfoEndpoint("https://graph.facebook.com/me/?fields=id,name,email,age_range,first_name,gender,last_name,link&access_token=");
            settings.setFetchGroupsEndpoint("https://graph.facebook.com/v2.8/");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"GitHub")) {
            LOGGER.debug((Object)"Setting Github App Endpoints...!");
            settings.setAccessTokenEndpoint("https://github.com/login/oauth/access_token");
            settings.setAuthorizeEndpoint("https://github.com/login/oauth/authorize");
            settings.setUserInfoEndpoint("https://api.github.com/user");
            settings.setFetchGroupsEndpoint("");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"GitHub Enterprise")) {
            LOGGER.debug((Object)"Setting Github Enterprise App Endpoints...!");
            settings.setAccessTokenEndpoint("https://github.com/login/oauth/access_token");
            settings.setAuthorizeEndpoint("https://github.com/login/oauth/authorize");
            settings.setUserInfoEndpoint("https://api.github.com/user");
            settings.setFetchGroupsEndpoint("");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Azure AD")) {
            LOGGER.info((Object)"Setting Azure AD App Endpoints...!");
            settings.setTenantID(tenantID);
            settings.setAccessTokenEndpoint("https://login.microsoftonline.com/" + settings.getTenantID() + "/oauth2/token");
            settings.setAuthorizeEndpoint("https://login.microsoftonline.com/" + settings.getTenantID() + "/oauth2/v2.0/authorize");
            settings.setUserInfoEndpoint("https://graph.microsoft.com/v1.0/me");
            settings.setFetchGroupsEndpoint("https://graph.microsoft.com/v1.0/me/memberOf");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Azure B2C")) {
            LOGGER.info((Object)"Setting AzureB2C App Endpoints...!");
            settings.setTenantID(tenantID);
            settings.setAccessTokenEndpoint("https://login.microsoftonline.com/" + settings.getTenantID() + "/oauth2/token");
            settings.setAuthorizeEndpoint("https://login.microsoftonline.com/" + settings.getTenantID() + "/oauth2/authorize");
            settings.setUserInfoEndpoint("https://graph.microsoft.com/v1.0/me");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Slack")) {
            LOGGER.info((Object)"Setting Slack App Endpoints...!");
            settings.setAccessTokenEndpoint("https://slack.com/api/oauth.access");
            settings.setAuthorizeEndpoint("https://slack.com/oauth/authorize");
            settings.setUserInfoEndpoint("https://slack.com/api/users.identity?token=");
            settings.setFetchGroupsEndpoint("https://slack.com/api/usergroups.list");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Discord")) {
            LOGGER.info((Object)"Setting Discord App Endpoints...!");
            settings.setAccessTokenEndpoint("https://discordapp.com/api/oauth2/token");
            settings.setAuthorizeEndpoint("https://discordapp.com/api/oauth2/authorize");
            settings.setUserInfoEndpoint("https://discordapp.com/api/users/@me");
            settings.setFetchGroupsEndpoint("");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"GitLab")) {
            settings.setAppHostedOn(appHostedOn);
            if (StringUtils.equals((CharSequence)appHostedOn, (CharSequence)"self-hosted")) {
                LOGGER.info((Object)"Setting Gitlab App Self Hosted Endpoints...!");
                settings.setDomainName(domainName);
                String baseURL = StringUtils.stripEnd((String)domainName, (String)"/");
                String GITLAB_AUTHORIZE_ENDPOINT = baseURL + "/oauth/authorize";
                String GITLAB_ACCESS_TOKEN_ENDPOINT = baseURL + "/oauth/token";
                String GITLAB_USER_INFO_ENDPOINT = baseURL + "/api/v4/user";
                String GITLAB_FETCH_GROUPS_ENDPOINT = baseURL + "/api/v4/groups";
                LOGGER.debug((Object)("Gitlab Server Hosting URL : " + baseURL));
                LOGGER.debug((Object)("Authorize Endpoint : " + GITLAB_AUTHORIZE_ENDPOINT));
                LOGGER.debug((Object)("Access Token Endpoint : " + GITLAB_ACCESS_TOKEN_ENDPOINT));
                LOGGER.debug((Object)("User Info Endpoint : " + GITLAB_USER_INFO_ENDPOINT));
                LOGGER.debug((Object)("Groups Endpoint : " + GITLAB_FETCH_GROUPS_ENDPOINT));
                settings.setAuthorizeEndpoint(GITLAB_AUTHORIZE_ENDPOINT);
                settings.setAccessTokenEndpoint(GITLAB_ACCESS_TOKEN_ENDPOINT);
                settings.setUserInfoEndpoint(GITLAB_USER_INFO_ENDPOINT);
                settings.setFetchGroupsEndpoint(GITLAB_FETCH_GROUPS_ENDPOINT);
            } else {
                settings.setDomainName("");
                LOGGER.info((Object)"Setting Gitlab App Cloud Endpoints...!");
                settings.setAccessTokenEndpoint("https://gitlab.com/oauth/token");
                settings.setAuthorizeEndpoint("https://gitlab.com/oauth/authorize");
                settings.setUserInfoEndpoint("https://gitlab.com/api/v4/user");
                settings.setFetchGroupsEndpoint("https://gitlab.com/api/v4/groups");
            }
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Meetup")) {
            LOGGER.info((Object)"Setting Meetup App Endpoints...!");
            settings.setAccessTokenEndpoint("https://secure.meetup.com/oauth2/access");
            settings.setAuthorizeEndpoint("https://secure.meetup.com/oauth2/authorize");
            settings.setUserInfoEndpoint("https://api.meetup.com/2/member/self/");
            settings.setFetchGroupsEndpoint("https://api.meetup.com/self/groups");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Keycloak")) {
            LOGGER.info((Object)"Setting KeyCloak App Endpoints...!");
            settings.setHostName(hostName);
            settings.setRealmName(realmName.trim());
            settings.setAccessTokenEndpoint(hostName + "/auth/realms/" + settings.getRealmName().replace(" ", "%20") + "/protocol/openid-connect/token");
            settings.setAuthorizeEndpoint(hostName + "/auth/realms/" + realmName + "/protocol/openid-connect/auth");
            settings.setUserInfoEndpoint(hostName + "/auth/realms/" + settings.getRealmName().replace(" ", "%20") + "/protocol/openid-connect/userinfo");
            settings.setFetchGroupsEndpoint("");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"AWS Cognito")) {
            LOGGER.info((Object)"Setting AWS Cognito App Endpoints...!");
            settings.setDomainName(domainName);
            settings.setAuthorizeEndpoint("https://" + settings.getDomainName() + "/oauth2/authorize");
            settings.setAccessTokenEndpoint("https://" + settings.getDomainName() + "/oauth2/token");
            settings.setEnableCheckIssuerFor(enableCheckIssuerFor);
            settings.setCheckIssuerFor(checkIssuerFor);
            settings.setCustomIssuerValue(customIssuerValue);
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"ADFS")) {
            LOGGER.info((Object)"Setting ADFS App Endpoints...!");
            settings.setDomainName(domainName);
            settings.setAuthorizeEndpoint("https://" + settings.getDomainName() + "/adfs/oauth2/authorize?");
            settings.setAccessTokenEndpoint("https://" + settings.getDomainName() + "/adfs/oauth2/token");
            settings.setEnableCheckIssuerFor(enableCheckIssuerFor);
            settings.setCheckIssuerFor(checkIssuerFor);
            settings.setCustomIssuerValue(customIssuerValue);
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Okta")) {
            LOGGER.debug((Object)"Setting Okta App Endpoints...!");
            settings.setDomainName(domainName);
            settings.setAuthorizeEndpoint("https://" + settings.getDomainName() + "/oauth2/default/v1/authorize");
            settings.setAccessTokenEndpoint("https://" + settings.getDomainName() + "/oauth2/default/v1/token");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Salesforce")) {
            LOGGER.debug((Object)"Setting Salesforce App Endpoints...!");
            settings.setDomainName(domainName);
            settings.setAuthorizeEndpoint("https://" + settings.getDomainName() + "/services/oauth2/authorize");
            settings.setAccessTokenEndpoint("https://" + settings.getDomainName() + "/services/oauth2/token");
            settings.setUserInfoEndpoint("https://" + settings.getDomainName() + "/services/oauth2/userinfo");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"Gluu Server")) {
            LOGGER.debug((Object)"Setting Gluu Server App Endpoints...!");
            settings.setDomainName(domainName);
            settings.setAuthorizeEndpoint(settings.getDomainName() + "/oxauth/restv1/authorize");
            settings.setAccessTokenEndpoint(settings.getDomainName() + "/oxauth/restv1/token");
            settings.setUserInfoEndpoint(settings.getDomainName() + "/oxauth/restv1/userinfo");
        } else if (StringUtils.equals((CharSequence)appName, (CharSequence)"miniOrange")) {
            LOGGER.debug((Object)"Setting miniOrange Server App Endpoints...!");
            settings.setDomainName(domainName);
            LOGGER.debug((Object)("domain name::" + domainName));
            settings.setAuthorizeEndpoint("https://" + settings.getDomainName() + "/moas/idp/openidsso");
            settings.setAccessTokenEndpoint("https://" + settings.getDomainName() + "/moas/rest/oauth/token");
            settings.setUserInfoEndpoint("https://" + settings.getDomainName() + "/moas/rest/oauth/getuserinfo");
        }
        settings.setClientID(MoOAuthUtils.sanitizeText(clientID));
        settings.setClientSecret(MoOAuthUtils.sanitizeText(clientSecret));
        if (StringUtils.equals((CharSequence)appName, (CharSequence)"Keycloak")) {
            settings.setScope("openid");
        } else {
            settings.setScope(MoOAuthUtils.sanitizeText(scope));
        }
        settings.setSingleLogoutURL(MoOAuthUtils.sanitizeText(singleLogoutURL));
        settings.setNonceCheck(nonceCheck);
        settings.setOauth_request_parameters(oauth_request_parameters);
        settings.setUseStateParameter(useStateParameter);
        settings.setACRValueCheck(acrValueCheck);
        settings.setEnablePKCESupport(enablePKCESupport);
    }

    public static void saveSigninSettings(String loginButtonText, String relayState, Boolean disableDefaultLogin, Boolean enableBackdoor, Boolean enableAutoRedirectDelay, String autoRedirectDelayInterval, String allowedDomains, String ssoButtonLocation, Boolean customLoginTemplate, String loginTemplate, Boolean enableLogoutTemplate, String logoutTemplate, String customLogoutURL, Boolean enableErrorMsgTemplate, String errorMsgTemplate, Boolean pluginApiAccessRestriction, Boolean restrictBackdoor, List<String> backdoorGroupsList, String backdoorKey, String backdoorValue, Boolean enableDebugLogs, Boolean allowPasswordReset, Boolean enableForSoftware, Boolean hideDefaultLogin, Boolean enableAutoLogin, Boolean forceReAuthentication, Boolean autoActivateUser) {
        LOGGER.info((Object)"Saving SignIn Settings");
        LOGGER.debug((Object)("LoginButtonText: " + loginButtonText + "relayState" + relayState + "disableDefaultLogin : " + BooleanUtils.toBoolean((Boolean)disableDefaultLogin) + "enableBackdoor : " + BooleanUtils.toBoolean((Boolean)enableBackdoor) + "enableAutoRedirectDelay : " + BooleanUtils.toBoolean((Boolean)enableAutoRedirectDelay) + "autoRedirectDelayInterval :" + autoRedirectDelayInterval + "allowedDomains: " + allowedDomains + "ssoButtonLocation: " + ssoButtonLocation + "pluginApiAccessRestriction: " + BooleanUtils.toBoolean((Boolean)pluginApiAccessRestriction) + "customLoginTemplate:" + BooleanUtils.toBoolean((Boolean)customLoginTemplate) + " allowPasswordReset " + allowPasswordReset + " loginTemplate " + loginTemplate + "enableForSoftware " + enableForSoftware + "enableAutoLogin " + enableAutoLogin + "forceReAuthentication " + forceReAuthentication));
        settings.setLoginButtonText(MoOAuthUtils.sanitizeText(loginButtonText));
        settings.setRelayState(MoOAuthUtils.sanitizeText(relayState));
        settings.setDefaultLoginDisabled(BooleanUtils.toBoolean((Boolean)disableDefaultLogin));
        settings.setBackdoorEnabled(BooleanUtils.toBoolean((Boolean)enableBackdoor));
        settings.setEnableAutoRedirectDelay(BooleanUtils.toBoolean((Boolean)enableAutoRedirectDelay));
        settings.setAutoRedirectDelayInterval(autoRedirectDelayInterval);
        settings.setAllowedDomains(allowedDomains);
        settings.setSsoButtonLocation(ssoButtonLocation);
        settings.setCustomLoginTemplate(customLoginTemplate);
        settings.setLoginTemplate(loginTemplate);
        settings.setEnableLogoutTemplate(enableLogoutTemplate);
        settings.setLogoutTemplate(logoutTemplate);
        settings.setCustomLogoutURL(MoOAuthUtils.sanitizeText(customLogoutURL));
        settings.setEnableErrorMsgTemplate(enableErrorMsgTemplate);
        settings.setErrorMsgTemplate(errorMsgTemplate);
        settings.setPluginApiAccessRestriction(pluginApiAccessRestriction);
        settings.setAutoActivateUser(autoActivateUser);
        settings.setRestrictBackdoor(restrictBackdoor);
        settings.setBackdoorGroups(backdoorGroupsList);
        settings.setBackdoorKey(backdoorKey);
        settings.setBackdoorValue(backdoorValue);
        settings.setAllowPasswordReset(allowPasswordReset);
        settings.setEnableDebugLogs(enableDebugLogs);
        settings.setEnableForSoftware(enableForSoftware);
        settings.setHideDefaultLogin(hideDefaultLogin);
        settings.setEnableAutoLogin(enableAutoLogin);
        settings.setForceReAuthentication(forceReAuthentication);
    }

    public static void saveRoleMapping(String roleAttribute, Boolean createUsersIfRoleMapped, Boolean keepExistingUserRoles, HashMap<String, String> roleMapping, String defaultGroup, List<String> defaultGroupsList, Boolean restrictUserCreation, String enableDefaultGroupsFor, Boolean assignDirectoryDefaultGroups, Boolean onTheFlyGroupCreation, List<String> onTheFlyDoNotRemoveGroupsList, Boolean onTheFlyAssignNewGroupsOnly, Boolean onTheFlyCreateNewGroups, String onTheFlyFilterIDPGroupsOption, String onTheFlyFilterIDPGroupsKey, Boolean groupRegexPatternEnabled, String regexPatternForGroup, String regexGroups, String testRegex, Boolean excludeGroupsRegexPattern, String regexPatternForExcludeGroups) {
        LOGGER.info((Object)"Saving Group Mapping Configuration");
        LOGGER.debug((Object)("roleAttribute = " + roleAttribute + " createUsersIfRoleMapped = " + BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped) + " keepExistingUserRoles = " + BooleanUtils.toBoolean((Boolean)keepExistingUserRoles) + " roleMapping = " + roleMapping + " defaultGroup = " + defaultGroup + " defaultGroupsList = " + defaultGroupsList + " restrictUserCreation = " + BooleanUtils.toBoolean((Boolean)restrictUserCreation) + " enableDefaultGroupsFor = " + enableDefaultGroupsFor + " onTheFlyGroupCreation = " + BooleanUtils.toBoolean((Boolean)onTheFlyGroupCreation) + " onTheFlyDoNotRemoveGroupsList = " + onTheFlyDoNotRemoveGroupsList + " onTheFlyAssignNewGroupsOnly = " + BooleanUtils.toBoolean((Boolean)onTheFlyAssignNewGroupsOnly) + "onTheFlyCreateNewGroups = " + BooleanUtils.toBoolean((Boolean)onTheFlyCreateNewGroups) + ", onTheFlyFilterIDPGroupOption=" + onTheFlyFilterIDPGroupsOption + ", onTheFlyFilterIDPGroupsKey=" + onTheFlyFilterIDPGroupsKey + " groupRegexPatternEnabled = " + groupRegexPatternEnabled + " regexPatternForGroup = " + regexPatternForGroup + " regexGroups " + regexGroups + " testRegex " + testRegex + ", excludeGroupsRegexPattern = " + excludeGroupsRegexPattern + ", regexPatternForExcludeGroups = " + regexPatternForExcludeGroups));
        settings.setRoleAttribute(roleAttribute);
        settings.setCreateUsersIfRoleMapped(BooleanUtils.toBoolean((Boolean)createUsersIfRoleMapped));
        settings.setKeepExistingUserRoles(BooleanUtils.toBoolean((Boolean)keepExistingUserRoles));
        settings.setRoleMapping(roleMapping);
        settings.setDefaultGroup(defaultGroup);
        settings.setDefaultGroupsList(defaultGroupsList);
        settings.setRestrictUserCreation(BooleanUtils.toBoolean((Boolean)restrictUserCreation));
        settings.setEnableDefaultGroupsFor(enableDefaultGroupsFor);
        settings.setAssignDirectoryDefaultGroups(assignDirectoryDefaultGroups);
        settings.setOnTheFlyGroupMapping(BooleanUtils.toBoolean((Boolean)onTheFlyGroupCreation));
        settings.setOnTheFlyDoNotRemoveGroups(onTheFlyDoNotRemoveGroupsList);
        settings.setOnTheFlyAssignNewGroupsOnly(BooleanUtils.toBoolean((Boolean)onTheFlyAssignNewGroupsOnly));
        settings.setOnTheFlyCreateNewGroups(BooleanUtils.toBoolean((Boolean)onTheFlyCreateNewGroups));
        settings.setOnTheFlyFilterIDPGroupsOption(onTheFlyFilterIDPGroupsOption);
        settings.setOnTheFlyFilterIDPGroupsKey(onTheFlyFilterIDPGroupsKey);
        settings.setGroupRegexPatternEnabled(groupRegexPatternEnabled);
        settings.setRegexPatternForGroup(regexPatternForGroup);
        settings.setRegexGroups(regexGroups);
        settings.setTestRegex(testRegex);
        settings.setExcludeGroupsRegexPattern(excludeGroupsRegexPattern);
        settings.setRegexPatternForExcludeGroups(regexPatternForExcludeGroups);
    }

    public static void saveAttributeMapping(String usernameAttribute, String emailAttribute, String regexPattern, Boolean regexPatternEnabled, String fullNameAttribute, Boolean useSeparateNameAttributes, String firstNameAttribute, String lastNameAttribute, Boolean keepExistingUserAttributes, String loginUserAttribute) {
        LOGGER.info((Object)"Saving Attribute Mapping");
        LOGGER.debug((Object)("UserName Attribute: " + usernameAttribute + " email Attribute: " + emailAttribute + " Full Name Attribute: " + fullNameAttribute + "Is Separate Attributes: " + BooleanUtils.toBoolean((Boolean)useSeparateNameAttributes) + " First Name Attribute: " + firstNameAttribute + " Last Name Attribute: " + lastNameAttribute + "Keep existing user attributes: " + BooleanUtils.toBoolean((Boolean)keepExistingUserAttributes) + " loginUserAttribute " + loginUserAttribute));
        settings.setUsernameAttribute(usernameAttribute);
        settings.setEmailAttribute(emailAttribute);
        settings.setRegexPatternEnabled(BooleanUtils.toBoolean((Boolean)regexPatternEnabled));
        if (BooleanUtils.toBoolean((Boolean)regexPatternEnabled)) {
            settings.setRegexPattern(regexPattern);
        }
        settings.setKeepExistingUserAttributes(BooleanUtils.toBoolean((Boolean)keepExistingUserAttributes));
        settings.setFirstNameAttribute(firstNameAttribute);
        settings.setLastNameAttribute(lastNameAttribute);
        settings.setFullNameAttribute(fullNameAttribute);
        settings.setUseSeparateNameAttributes(BooleanUtils.toBoolean((Boolean)useSeparateNameAttributes));
        settings.setLoginUserAttribute(loginUserAttribute);
    }

    public static void saveDefaultConfiguration() {
        LOGGER.info((Object)"Saving Default Configurations");
        MoOAuthPluginHandler.saveOAuthConfiguration("", "", "", "", "", "", "", "", "", Boolean.TRUE, Boolean.TRUE, "", "", "", Boolean.FALSE, "", Boolean.FALSE, Boolean.TRUE, new HashMap<String, String>(), "HttpBody");
        MoOAuthPluginHandler.saveOAuthConfiguration("", "", "", "", "", "", "", "", "", Boolean.TRUE, "", "", "", Boolean.TRUE, Boolean.FALSE, "", Boolean.FALSE, Boolean.TRUE, new HashMap<String, String>());
        MoOAuthPluginHandler.saveAttributeMapping("", "", "", Boolean.FALSE, "", Boolean.FALSE, "", "", Boolean.TRUE, "username");
        MoOAuthPluginHandler.saveRoleMapping("", Boolean.FALSE, Boolean.TRUE, new HashMap<String, String>(), settings.getDefaultGroup(), Arrays.asList(settings.getDefaultGroup()), Boolean.FALSE, "newUsers", Boolean.FALSE, Boolean.FALSE, new ArrayList<String>(), Boolean.TRUE, Boolean.TRUE, "None", "", Boolean.FALSE, "", "", "", Boolean.FALSE, "");
        MoOAuthPluginHandler.saveSigninSettings("", "", Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, "5", "", "", Boolean.FALSE, "", Boolean.FALSE, "", "", Boolean.FALSE, "", Boolean.FALSE, Boolean.FALSE, new ArrayList<String>(), "oauth_sso", "false", Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, settings.getForceReAuthentication(), Boolean.FALSE);
    }

    public Boolean isUserPresentInGroups(String username, List<String> groups) {
        LOGGER.debug((Object)("Testing for user " + username));
        try {
            BambooUser bambooUser = bambooUserManager.getBambooUser(username);
            List existingGroupsOfUser = new ArrayList();
            existingGroupsOfUser = bambooUserManager.getGroupNamesAsList((User)bambooUser);
            if (bambooUser != null) {
                for (String group : groups) {
                    if (!existingGroupsOfUser.contains(group)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error((Object)e.getMessage());
            return false;
        }
        return false;
    }

    public static URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public MoOAuthSettings getSettings() {
        return settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        MoOAuthPluginHandler.settings = settings;
    }

    public static BambooUserManager getBambooUserManager() {
        return bambooUserManager;
    }

    public static void setBambooUserManager(BambooUserManager bambooUserManager) {
        MoOAuthPluginHandler.bambooUserManager = bambooUserManager;
    }

    public static String getGroupNameFromRegex(Matcher matcher, String replaceWith) {
        LOGGER.debug((Object)"forming String According To Groupname and replaceWith");
        StringBuffer groupname = new StringBuffer("");
        try {
            String[] groupPositions;
            for (String position : groupPositions = StringUtils.split((String)replaceWith, (char)'$')) {
                LOGGER.debug((Object)("position " + position));
                LOGGER.debug((Object)("Group name " + matcher.group(Integer.parseInt(position.trim()))));
                groupname.append(matcher.group(Integer.parseInt(position.trim())));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while applying regex on username. Kindly check Regex configuration.", (Throwable)e);
        }
        return groupname.toString();
    }
}

