<script>
    <#if (action.hasActionMessages())>
        <#foreach actionMessage in action.actionMessages>
            AJS.flag({
                title: 'Success!',
                type: 'success',
                close: 'auto',
                body: '<p>${actionMessage}</p><br/>'
            });
        </#foreach>
    </#if>
    <#if action.hasActionErrors() >
        <#foreach error in action.actionErrors >
            AJS.flag({
                title: 'Error!',
                type: 'error',
                close : 'auto',
                body: '<p>${error}</p><br/>'
            });
        </#foreach>
    </#if>

</script>

<style>

    :root {
            --link-color: blue !important;
    }
    html[data-color-mode='dark'] {
        --link-color: #439bff !important;
    }

    .aui-page-header{
        background-color:#f5f5f5 !important;
    }
    html[data-color-mode='dark'] .aui-page-header{
        background-color: #2B2F33 !important;
    }

    .offset {
        color: white;
        border-radius: 50px;
        padding: 12px 25px;
        background-color: #0052cc;
        position: fixed;
        right: 20px;
        bottom: 50px;
        font-size: 16px !important ;
        font-weight: 600;
        font-family:-apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen, Ubuntu, Fira Sans, Droid Sans, Helvetica Neue, sans-serif;
        z-index: 1;
    }
    html[data-color-mode='dark'] .offset {
        color: #1d2125;
        border-radius: 50px;
        padding: 12px 25px;
        background-color: #579dff;
        position: fixed;
        right: 20px;
        bottom: 50px;
        font-size: 16px !important ;
        font-weight: 600;
        font-family:-apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Oxygen, Ubuntu, Fira Sans, Droid Sans, Helvetica Neue, sans-serif;
        z-index: 1;
    }

    .contact-us {
        background: #fff;
        padding-top: 0.5em;
        padding-left: 1em;
        padding-right: 1em;
        padding-bottom: 0.5em;
        box-shadow: 0 5px 18px 3px rgba(0,0,0,.1);
    }
    html[data-color-mode='dark'] .contact-us {
        background: #1d2125;
    }

    .feedback_float {
        cursor: pointer;
        transform: rotate(-90deg);
        padding: 15px;
        position: fixed;
        width: auto;
        height: auto;
        top: 340px;
        right: -25px;
        color: #FFF;
        background: chocolate;
        text-align: center;
        border-radius: 8px;
        border-width: 0px;
        z-index: 10000;
    }

    .feedback_panel {
        background-color: #fff;
        display: inline-block;
        height: auto;
        position: fixed;
        top: 125px;
        width: 320px;
        float: right;
        height: auto;
        min-height: 459px;
        right: -335px;
        z-index: 10000;
        border-radius: 8px;
        border-style: groove;
    }

    .form-element {
        background-color: #f4f5f7;
        border-radius: 5px;
        border: 1px solid #dfe1e6;
        box-shadow: none;
        box-sizing: border-box;
        color: #172b4d;
        font-family: inherit;
        font-size: 14px;
        line-height: 20px;
        max-width: 100%;
        outline: none;
        padding: 9px 7px;
        transition: background-color .2s ease-in-out, border-color .2s ease-in-out;
        width: 100%;
    }

    #widget-header {
        border-radius: 5px 5px 0 0;
        height: 40px;
        max-height: 40px;
        min-height: 40px;
        display: flex;
        align-items: center;
        background-color: #0052cc;
        position: relative;
    }

    #widget-header .header-text, .header-close-icon-container {
        color: #fff;
        padding: 10px;
        display: inline-block;
        white-space: nowrap;
        overflow: hidden;
        flex-grow: 1;
        text-overflow: ellipsis;
        text-align: center;
    }

    .background.diamond {
        font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Noto Sans, Oxygen, Ubuntu, Droid Sans, Helvetica Neue, sans-serif;
    }

    .form-labels {
        color: #6b778c;
        display: block;
        font-size: 12px;
        font-weight: 600;
        line-height: 1;
        padding: 0;
        margin-bottom: 6px;
        font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Noto Sans, Oxygen, Ubuntu, Droid Sans, Helvetica Neue, sans-serif;
    }
</style>
<div class="aui-page-panel">
    <div class="aui-page-panel-inner">
        <section id="content" role="main">
            <header class="aui-page-header">
                <div class="aui-page-header-inner">
                    <div class="aui-page-header-image">
                    	<span class="aui-avatar aui-avatar-large">
                        	<span class="aui-avatar-inner">
                            	<img src="/rest/plugins/1.0/com.miniorange.oauth.bamboo-oauth-key/media/plugin-logo">
                        	</span>
                    	</span>
                    </div>
                    <div class="aui-page-header-main">
                        <h1>miniOrange OAuth Configuration</h1>
                        <div class="aui-buttons">
                            <a href="/plugins/servlet/upm" target="_blank" class="aui-button aui-button-subtle" style="color:var(--link-color)"><span class="aui-icon aui-icon-small aui-iconfont-addon" style="color: var(--link-color);vertical-align: middle"></span><span style="vertical-align:middle">Manage apps</span></a>
                            <a href="https://forum.miniorange.com/forum/single-sign-on/" target="_blank" class="aui-button aui-button-subtle" style="color:var(--link-color)"><span class="aui-icon aui-icon-small aui-iconfont-vid-raised-hand" style="color: var(--link-color);vertical-align: middle"></span><span style="vertical-align:middle">Ask Us On Forum</span></a>
                        	<a href="https://faq.miniorange.com/kb/atlassian/" target="_blank" class="aui-button aui-button-subtle" style="color: var(--link-color)"><span class="aui-icon aui-icon-small aui-iconfont-question-circle" style="color:var(--link-color);vertical-align: middle"></span><span style="vertical-align:middle">&nbsp;Frequently Asked Questions</span></a>
                            <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/66" target="_blank" class="aui-button aui-button-subtle" style="color: var(--link-color)"><span class="aui-icon aui-icon-small aui-iconfont-video-filled" style="color:var(--link-color);vertical-align: middle"></span><span style="vertical-align:middle">&nbsp;Request a Demo</span></a>
                        </div>
                    </div>
                    <div style="float:right" >
                                <div class="contact-us" id="contact-us" aria-controls="support_div_dialog">
                                    <div class="contact-us-heading"><h3> Contact us:</h3><div>
                                        <ul style="list-style-type:none; padding-left: 0;">
                                            <li>
                                                <span class="aui-icon aui-icon-small aui-iconfont-email">Contact-us email</span>
                                                <span><a href="mailto:support-atlassian@miniorange.atlassian.net">support-atlassian@miniorange.atlassian.net</a></span>
                                            </li>
                                            <li>
                                                <span class="aui-icon aui-icon-small aui-iconfont-vid-hang-up">Contact-us phone</span>
                                                <span>+1 978 658 9387</span>
                                            </li>
                                            <li>
                                                <span class="aui-icon aui-icon-small aui-iconfont-video-filled"">Contact-us meet</span>
                                                <span><a href="https://calendly.com/shweta-vispute" target="_blank">Free setup assistance</a></span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                    </div>
                </div>
            </header>

            <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6/create/15" target="_blank">
                <div class="header" id="miniOrangeSupport">
                miniOrange Support
                </div>
            </a>
            <script>
                     var helpButton = document.getElementById("miniOrangeSupport");
                     var offset = helpButton.offsetTop;
                     helpButton.classList.add("offset");
            </script>
            <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
                <div class="aui-navgroup-inner">
                    <div class="aui-navgroup-primary">
                        <ul class="aui-nav">
                            <li id="configureoauth"><a href="configure.action">Configure OAuth</a></li>
                            <li id="userprofile"><a href="attributemappingconfig.action">User Profile</a></li>
                            <li id="usergroups"><a href="groupmappingconfig.action">User Groups</a></li>
                            <li id="signinsettings"><a href="signinsettings.action">Sign In Settings</a></li>
                            <li id="importexport"><a href="importexport.action">Backup/Restore Configurations</a></li>
                        </ul>
                    </div>
                    <span style="float:right;margin-right:25px;margin-top: 4px;">
                            <a href="contactus.action"><input type="button" class="aui-button aui-button-primary" value="Troubleshooting"></a>
                     </span>
                </div>
            </nav>

            <div class="aui-tabs horizontal-tabs" id="tabs-example1" role="application">
                <div class="aui-message aui-message-info info closeable shadowed">
                    <p style="font:message-box">Feeling stuck? Our experts are here to help. <a href="https://calendly.com/shweta-vispute" target="_blank">Click here</a> to book a consultation to get the help you need.
                </div>
				<#if ( !settings.isLicenseDefine() )>
				<div class="aui-message aui-message-warning warning closeable shadowed">
                    <p class="title">
                        <strong>Warning!</strong>
                    </p>
                    <p>No license found for app. Single Sign-On will not work unless app license is applied.</p>
                    <p>If you've already generated a license
                        <a href="https://my.atlassian.com/product" target="_blank" style = "color : #439bff ;">click here</a> to access it and update it in License key box on
                        <a href="/plugins/servlet/upm" target="_blank">
                            <b>Manage apps</b>
                        </a> page.
                    </p>
                </div>
                </#if>


                