/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class MoOAuthSignInSettingsAction
extends BambooActionSupport {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthSignInSettingsAction.class);
    private String loginButtonText;
    private Boolean signinSettingsSubmitted;
    private String relayState;
    private String allowedDomains;
    private String xsrfToken;
    private Boolean enableBackdoor;
    private Boolean disableDefaultLogin;
    private Boolean enableAutoRedirectDelay;
    private String autoRedirectDelayInterval;
    private String ssoButtonLocation;
    private Boolean customLoginTemplate;
    private String loginTemplate;
    private Boolean enableLogoutTemplate;
    private String logoutTemplate;
    private String customLogoutURL;
    private Boolean enableErrorMsgTemplate;
    private String errorMsgTemplate;
    private Boolean pluginApiAccessRestriction;
    private Boolean autoActivateUser;
    private Boolean allowPasswordReset;
    private Boolean backdoorSubmitted;
    private Boolean restrictBackdoor;
    private List<String> backdoorGroupsList;
    private String[] backdoorGroups;
    private String lowerBuild;
    private ArrayList existingGroups;
    private PluginLicenseManager pluginLicenseManager;
    private MoOAuthSettings settings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String backdoorKey;
    private String backdoorValue;
    private Boolean enableDebugLogs;
    private Boolean enableForSoftware;
    private Boolean hideDefaultLogin;
    private Boolean enableAutoLogin;
    private Boolean isAutoAttemptSuppProvider;
    private String autoCallbackUrl;
    Boolean forceReAuthentication;

    public MoOAuthSignInSettingsAction(MoOAuthSettings settings, UserManager userManager, LoginUriProvider loginUriProvider, BambooUserManager bambooUserManager) {
        this.settings = settings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.bambooUserManager = bambooUserManager;
    }

    public void validate() {
        LOGGER.info((Object)"Sign In Settings Action validate called");
        HttpServletRequest request = ServletActionContext.getRequest();
        if (!BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
            return;
        }
        Boolean error = false;
        ArrayList<String> invalidValues = new ArrayList<String>();
        UrlValidator urlValidator = new UrlValidator(8L);
        if (StringUtils.isNotBlank((CharSequence)this.relayState) && !urlValidator.isValid(this.relayState)) {
            invalidValues.add("relaystate");
        }
        for (String invalidValue : invalidValues) {
            error = true;
            this.addActionError(this.getText("oauth.error.invalid." + invalidValue));
        }
        if (super.hasActionErrors() || error.booleanValue()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
            return;
        }
        super.validate();
    }

    public String execute() throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.info((Object)"SignIn Settings Action doExecute Submitted: ");
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.lowerBuild = "false";
                this.lowerBuild = this.getLowerBuild();
                LOGGER.debug((Object)("signinSettingsSubmitted: " + this.signinSettingsSubmitted));
                LOGGER.debug((Object)("backdoorSubmitted: " + this.backdoorSubmitted));
                this.backdoorGroupsList = new ArrayList<String>();
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (BooleanUtils.toBoolean((Boolean)this.signinSettingsSubmitted)) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.lowerBuild)) {
                        if (this.backdoorGroups != null) {
                            LOGGER.debug((Object)("Backdoor groups-" + this.backdoorGroups.length));
                            this.backdoorGroupsList = new ArrayList<String>(Arrays.asList(this.backdoorGroups));
                        }
                    } else {
                        this.backdoorGroupsList = this.settings.convertArrayToList(StringUtils.split((String)this.backdoorGroups[0], (String)","));
                    }
                    MoOAuthPluginHandler.saveSigninSettings(this.loginButtonText, this.relayState, this.disableDefaultLogin, this.enableBackdoor, this.enableAutoRedirectDelay, this.autoRedirectDelayInterval, this.allowedDomains, this.ssoButtonLocation, this.customLoginTemplate, this.loginTemplate, this.enableLogoutTemplate, this.logoutTemplate, this.customLogoutURL, this.enableErrorMsgTemplate, this.errorMsgTemplate, this.pluginApiAccessRestriction, this.restrictBackdoor, this.backdoorGroupsList, this.backdoorKey, this.backdoorValue, this.enableDebugLogs, this.allowPasswordReset, this.enableForSoftware, this.hideDefaultLogin, this.enableAutoLogin, this.forceReAuthentication, this.autoActivateUser);
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initialize OAuth Config called");
        this.loginButtonText = this.settings.getLoginButtonText();
        this.relayState = this.settings.getRelayState();
        this.disableDefaultLogin = this.settings.getDefaultLoginDisabled();
        this.enableBackdoor = this.settings.getBackdoorEnabled();
        this.enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
        this.autoRedirectDelayInterval = this.settings.getAutoRedirectDelayInterval();
        this.allowedDomains = this.settings.getAllowedDomains();
        this.ssoButtonLocation = this.settings.getSsoButtonLocation();
        this.customLoginTemplate = this.settings.getCustomLoginTemplate();
        this.loginTemplate = this.settings.getLoginTemplate();
        this.enableLogoutTemplate = this.settings.getEnableLogoutTemplate();
        this.logoutTemplate = this.settings.getLogoutTemplate();
        this.customLogoutURL = this.settings.getCustomLogoutURL();
        this.enableErrorMsgTemplate = this.settings.getEnableErrorMsgTemplate();
        this.errorMsgTemplate = this.settings.getErrorMsgTemplate();
        this.pluginApiAccessRestriction = this.settings.getPluginApiAccessRestriction();
        this.autoActivateUser = this.settings.getAutoActivateUser();
        this.restrictBackdoor = this.settings.getRestrictBackdoor();
        this.backdoorGroupsList = this.settings.getBackdoorGroups();
        this.lowerBuild = this.getLowerBuild();
        ArrayList existingGroup = this.getExistingGroups();
        this.backdoorKey = this.settings.getBackdoorKey();
        this.backdoorValue = this.settings.getBackdoorValue();
        this.allowPasswordReset = this.settings.getAllowPasswordReset();
        this.enableDebugLogs = this.settings.getEnableDebugLogs();
        this.enableForSoftware = this.settings.getEnableForSoftware();
        this.hideDefaultLogin = this.settings.getHideDefaultLogin();
        this.isAutoAttemptSuppProvider = this.settings.getIsAutoAttemptSuppProvider(this.settings.getAppName());
        this.enableAutoLogin = this.isAutoAttemptSuppProvider != false ? this.settings.getEnableAutoLogin() : false;
        this.autoCallbackUrl = this.settings.getAutoCallBackUrl();
        this.forceReAuthentication = this.settings.getForceReAuthentication();
    }

    public String getBaseUrl() {
        return this.settings.getBaseUrl();
    }

    @StrutsParameter
    public Boolean getPluginApiAccessRestriction() {
        return this.pluginApiAccessRestriction;
    }

    @StrutsParameter
    public void setPluginApiAccessRestriction(Boolean pluginApiAccessRestriction) {
        this.pluginApiAccessRestriction = pluginApiAccessRestriction;
    }

    @StrutsParameter
    public Boolean getAutoActivateUser() {
        return this.autoActivateUser;
    }

    @StrutsParameter
    public void setAutoActivateUser(Boolean autoActivateUser) {
        this.autoActivateUser = autoActivateUser;
    }

    @StrutsParameter
    public String getErrorMsgTemplate() {
        return this.errorMsgTemplate;
    }

    @StrutsParameter
    public void setErrorMsgTemplate(String errorMsgTemplate) {
        this.errorMsgTemplate = errorMsgTemplate;
    }

    @StrutsParameter
    public Boolean getEnableErrorMsgTemplate() {
        return this.enableErrorMsgTemplate;
    }

    @StrutsParameter
    public void setEnableErrorMsgTemplate(Boolean enableErrorMsgTemplate) {
        this.enableErrorMsgTemplate = enableErrorMsgTemplate;
    }

    @StrutsParameter
    public String getCustomLogoutURL() {
        return this.customLogoutURL;
    }

    @StrutsParameter
    public void setCustomLogoutURL(String customLogoutURL) {
        this.customLogoutURL = customLogoutURL;
    }

    @StrutsParameter
    public Boolean getCustomLoginTemplate() {
        return this.customLoginTemplate;
    }

    @StrutsParameter
    public void setCustomLoginTemplate(Boolean customLoginTemplate) {
        this.customLoginTemplate = customLoginTemplate;
    }

    @StrutsParameter
    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    @StrutsParameter
    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    @StrutsParameter
    public String getLogoutTemplate() {
        return this.logoutTemplate;
    }

    @StrutsParameter
    public void setLogoutTemplate(String logoutTemplate) {
        this.logoutTemplate = logoutTemplate;
    }

    @StrutsParameter
    public Boolean getEnableLogoutTemplate() {
        return this.enableLogoutTemplate;
    }

    @StrutsParameter
    public void setEnableLogoutTemplate(Boolean enableLogoutTemplate) {
        this.enableLogoutTemplate = enableLogoutTemplate;
    }

    @StrutsParameter
    public String getLoginButtonText() {
        return this.loginButtonText;
    }

    @StrutsParameter
    public void setLoginButtonText(String loginButtonText) {
        this.loginButtonText = loginButtonText;
    }

    @StrutsParameter
    public Boolean getSigninSettingsSubmitted() {
        return this.signinSettingsSubmitted;
    }

    @StrutsParameter
    public void setSigninSettingsSubmitted(Boolean signinSettingsSubmitted) {
        this.signinSettingsSubmitted = signinSettingsSubmitted;
    }

    @StrutsParameter
    public String getRelayState() {
        return this.relayState;
    }

    @StrutsParameter
    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    @StrutsParameter
    public String getBackdoorKey() {
        return this.backdoorKey;
    }

    @StrutsParameter
    public void setBackdoorKey(String backdoorKey) {
        this.backdoorKey = backdoorKey;
    }

    @StrutsParameter
    public String getBackdoorValue() {
        return this.backdoorValue;
    }

    @StrutsParameter
    public void setBackdoorValue(String backdoorValue) {
        this.backdoorValue = backdoorValue;
    }

    @StrutsParameter
    public String getSsoButtonLocation() {
        return this.ssoButtonLocation;
    }

    @StrutsParameter
    public void setSsoButtonLocation(String ssoButtonLocation) {
        this.ssoButtonLocation = ssoButtonLocation;
    }

    @StrutsParameter
    public Boolean getEnableBackdoor() {
        return this.enableBackdoor;
    }

    @StrutsParameter
    public void setEnableBackdoor(Boolean enableBackdoor) {
        this.enableBackdoor = enableBackdoor;
    }

    @StrutsParameter
    public Boolean getDisableDefaultLogin() {
        return this.disableDefaultLogin;
    }

    @StrutsParameter
    public void setDisableDefaultLogin(Boolean disableDefaultLogin) {
        this.disableDefaultLogin = disableDefaultLogin;
    }

    @StrutsParameter
    public Boolean getEnableAutoRedirectDelay() {
        return this.enableAutoRedirectDelay;
    }

    @StrutsParameter
    public void setEnableAutoRedirectDelay(Boolean enableAutoRedirectDelay) {
        this.enableAutoRedirectDelay = enableAutoRedirectDelay;
    }

    @StrutsParameter
    public String getAutoRedirectDelayInterval() {
        return this.autoRedirectDelayInterval;
    }

    @StrutsParameter
    public void setAutoRedirectDelayInterval(String autoRedirectDelayInterval) {
        this.autoRedirectDelayInterval = autoRedirectDelayInterval;
    }

    @StrutsParameter
    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    @StrutsParameter
    public void setAllowedDomains(String allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public Boolean getRestrictBackdoor() {
        return this.restrictBackdoor;
    }

    @StrutsParameter
    public void setRestrictBackdoor(Boolean restrictBackdoor) {
        this.restrictBackdoor = restrictBackdoor;
    }

    @StrutsParameter
    public List<String> getBackdoorGroupsList() {
        return this.backdoorGroupsList;
    }

    @StrutsParameter
    public void setBackdoorGroupsList(List<String> backdoorGroupsList) {
        this.backdoorGroupsList = backdoorGroupsList;
    }

    @StrutsParameter
    public String[] getBackdoorGroups() {
        return this.backdoorGroups;
    }

    @StrutsParameter
    public void setBackdoorGroups(String[] backdoorGroups) {
        this.backdoorGroups = backdoorGroups;
    }

    @StrutsParameter
    public String getLowerBuild() {
        this.lowerBuild = Boolean.toString(this.settings.isLowerBuild());
        return this.lowerBuild;
    }

    @StrutsParameter
    public void setLowerBuild(String lowerBuild) {
        this.lowerBuild = lowerBuild;
    }

    @StrutsParameter
    public Boolean getAllowPasswordReset() {
        return this.allowPasswordReset;
    }

    @StrutsParameter
    public void setAllowPasswordReset(Boolean allowPasswordReset) {
        this.allowPasswordReset = allowPasswordReset;
    }

    @StrutsParameter
    public Boolean getEnableAutoLogin() {
        return this.enableAutoLogin;
    }

    @StrutsParameter
    public void setEnableAutoLogin(Boolean enableAutoLogin) {
        this.enableAutoLogin = enableAutoLogin;
    }

    @StrutsParameter
    public String getAutoCallbackUrl() {
        return this.autoCallbackUrl;
    }

    @StrutsParameter
    public void setAutoCallbackUrl(String autoCallbackUrl) {
        this.autoCallbackUrl = autoCallbackUrl;
    }

    @StrutsParameter
    public Boolean getIsAutoAttemptSuppProvider() {
        return this.isAutoAttemptSuppProvider;
    }

    @StrutsParameter
    public void setIsAutoAttemptSuppProvider(Boolean isAutoAttemptSuppProvider) {
        this.isAutoAttemptSuppProvider = isAutoAttemptSuppProvider;
    }

    @StrutsParameter
    public ArrayList getExistingGroups() {
        try {
            Pager groupObjects = this.bambooUserManager.getGroups();
            this.existingGroups = new ArrayList();
            for (Group group : groupObjects) {
                if (this.existingGroups.contains(group.getName().trim())) continue;
                this.existingGroups.add(group.getName().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.existingGroups;
    }

    @StrutsParameter
    public void setExistingGroups(ArrayList existingGroups) {
        this.existingGroups = existingGroups;
    }

    @StrutsParameter
    public Boolean getEnableDebugLogs() {
        return this.enableDebugLogs;
    }

    @StrutsParameter
    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.enableDebugLogs = enableDebugLogs;
    }

    @StrutsParameter
    public Boolean getEnableForSoftware() {
        return this.enableForSoftware;
    }

    @StrutsParameter
    public void setEnableForSoftware(Boolean enableForSoftware) {
        this.enableForSoftware = enableForSoftware;
    }

    @StrutsParameter
    public Boolean getHideDefaultLogin() {
        return this.hideDefaultLogin;
    }

    @StrutsParameter
    public void setHideDefaultLogin(Boolean hideDefaultLogin) {
        this.hideDefaultLogin = hideDefaultLogin;
    }

    @StrutsParameter
    public Boolean getForceReAuthentication() {
        return this.forceReAuthentication;
    }

    @StrutsParameter
    public void setForceReAuthentication(Boolean forceReAuthentication) {
        this.forceReAuthentication = forceReAuthentication;
    }
}

