/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class MoOAuthAttributeMappingAction
extends BambooActionSupport {
    private static final Log LOGGER = LogFactory.getLog(MoOAuthAttributeMappingAction.class);
    private MoOAuthSettings settings;
    private PluginLicenseManager pluginLicenseManager;
    private Boolean attributeMappingSubmitted;
    private String usernameAttribute;
    private Boolean regexPatternEnabled;
    private String regexPattern;
    private String emailAttribute;
    private String fullNameAttribute = "";
    private String firstNameAttribute = "";
    private String lastNameAttribute = "";
    private Boolean useSeparateNameAttributes;
    private Boolean keepExistingUserAttributes;
    private String loginUserAttribute;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String xsrfToken;
    private ArrayList userLoginOptions;

    public MoOAuthAttributeMappingAction(MoOAuthSettings settings, PluginLicenseManager pluginLicenseManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public String execute() throws Exception {
        LOGGER.info((Object)"AttributeMappingConfigurationAction doExecute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                Boolean error;
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted) && !(error = this.Validation(this.usernameAttribute, this.regexPatternEnabled, this.regexPattern)).booleanValue()) {
                    MoOAuthPluginHandler.saveAttributeMapping(this.usernameAttribute, this.emailAttribute, this.regexPattern, this.regexPatternEnabled, this.fullNameAttribute, this.useSeparateNameAttributes, this.firstNameAttribute, this.lastNameAttribute, this.keepExistingUserAttributes, this.loginUserAttribute);
                    LOGGER.info((Object)"attributeMapping saved");
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.debug((Object)("error is : " + e));
                this.addActionError("An error occurred.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initializeOAuthConfig called... ");
        this.usernameAttribute = this.settings.getUsernameAttribute();
        this.emailAttribute = this.settings.getEmailAttribute();
        this.regexPattern = this.settings.getRegexPattern();
        this.regexPatternEnabled = this.settings.getRegexPatternEnabled();
        this.fullNameAttribute = this.settings.getFullNameAttribute();
        this.useSeparateNameAttributes = this.settings.getUseSeparateNameAttributes();
        this.firstNameAttribute = this.settings.getFirstNameAttribute();
        this.lastNameAttribute = this.settings.getLastNameAttribute();
        this.keepExistingUserAttributes = this.settings.getKeepExistingUserAttributes();
        this.loginUserAttribute = this.settings.getLoginUserAttribute();
    }

    private Boolean Validation(String usernameAttribute, Boolean regexPatternEnabled, String regexPattern) {
        LOGGER.info((Object)"Attribute Mapping Configuration Action doValidate");
        Boolean error = false;
        if (!BooleanUtils.toBoolean((Boolean)this.attributeMappingSubmitted)) {
            error = true;
        }
        if (BooleanUtils.toBoolean((Boolean)regexPatternEnabled)) {
            LOGGER.info((Object)"Validating Regular Expression.........");
            if (StringUtils.isBlank((CharSequence)usernameAttribute)) {
                this.addActionError("Enter Username for Regex Pattern");
                LOGGER.error((Object)"Username attribute is empty, please enter the value");
                error = true;
            }
            if (StringUtils.isBlank((CharSequence)regexPattern)) {
                error = true;
                this.addActionError("Please Enter Regular Expression");
            }
            try {
                Pattern.compile(regexPattern);
            }
            catch (PatternSyntaxException exception) {
                error = true;
                this.addActionError("Regular expression is not valid");
            }
        }
        if (BooleanUtils.toBoolean((Boolean)error)) {
            this.initializeOAuthConfig();
        }
        return error;
    }

    @StrutsParameter
    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @StrutsParameter
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @StrutsParameter
    public Boolean getAttributeMappingSubmitted() {
        return this.attributeMappingSubmitted;
    }

    @StrutsParameter
    public void setAttributeMappingSubmitted(Boolean attributeMappingSubmitted) {
        this.attributeMappingSubmitted = attributeMappingSubmitted;
    }

    @StrutsParameter
    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    @StrutsParameter
    public void setUsernameAttribute(String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    @StrutsParameter
    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    @StrutsParameter
    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    @StrutsParameter
    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    @StrutsParameter
    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    @StrutsParameter
    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    @StrutsParameter
    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    @StrutsParameter
    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    @StrutsParameter
    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    @StrutsParameter
    public Boolean getUseSeparateNameAttributes() {
        return this.useSeparateNameAttributes;
    }

    @StrutsParameter
    public void setUseSeparateNameAttributes(Boolean useSeparateNameAttributes) {
        this.useSeparateNameAttributes = useSeparateNameAttributes;
    }

    @StrutsParameter
    public Boolean getKeepExistingUserAttributes() {
        return this.keepExistingUserAttributes;
    }

    @StrutsParameter
    public void setKeepExistingUserAttributes(Boolean keepExistingUserAttributes) {
        this.keepExistingUserAttributes = keepExistingUserAttributes;
    }

    @StrutsParameter
    public String getLoginUserAttribute() {
        return this.loginUserAttribute;
    }

    @StrutsParameter
    public void setLoginUserAttribute(String loginUserAttribute) {
        this.loginUserAttribute = loginUserAttribute;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public ArrayList getUserLoginOptions() {
        this.userLoginOptions = new ArrayList();
        this.userLoginOptions.add("username");
        this.userLoginOptions.add("email");
        return this.userLoginOptions;
    }

    @StrutsParameter
    public void setUserLoginOptions(ArrayList userLoginOptions) {
        this.userLoginOptions = userLoginOptions;
    }

    @StrutsParameter
    public Boolean getRegexPatternEnabled() {
        return this.regexPatternEnabled;
    }

    @StrutsParameter
    public void setRegexPatternEnabled(Boolean regexPatternEnabled) {
        this.regexPatternEnabled = regexPatternEnabled;
    }

    @StrutsParameter
    public String getRegexPattern() {
        return this.regexPattern;
    }

    @StrutsParameter
    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

