/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.oauth.bamboo.action;

import com.atlassian.bamboo.configuration.logs.ConfigureLog4jAction;
import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.miniorange.oauth.MoOAuthPluginException;
import com.miniorange.oauth.bamboo.MoOAuthPluginConstants;
import com.miniorange.oauth.bamboo.MoOAuthPluginHandler;
import com.miniorange.oauth.bamboo.MoOAuthSettings;
import com.miniorange.oauth.utils.MoOAuthUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class MoClientConfigurationAction
extends BambooActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(MoClientConfigurationAction.class);
    private String customAppName;
    private String clientID;
    private String scope;
    private String clientSecret;
    private String authorizeEndpoint;
    private String accessTokenEndpoint;
    private String userInfoEndpoint;
    private String fetchGroupsEndpoint;
    private String singleLogoutURL;
    private String publicKey;
    private Boolean nonceCheck;
    private Boolean isCredentialsVerified;
    private Boolean useStateParameter;
    private Boolean acrValueCheck;
    private Boolean enablePKCESupport;
    private Boolean enableCheckIssuerFor;
    private String checkIssuerFor;
    private String customIssuerValue;
    private String tenantID;
    private String hostName;
    private String realmName;
    private String domainName;
    private String appHostedOn;
    private String appName;
    private Boolean submitted;
    private Boolean deleterefreshtoken;
    private PluginLicenseManager pluginLicenseManager;
    private MoOAuthSettings settings;
    private String xsrfToken;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private String isOpenIdProtocol;
    private String sendTokenAuthParameterIn;
    private ArrayList<String> defaultOpenIdApps = new ArrayList();
    private ArrayList<String> defaultOauthApps = new ArrayList();
    private Map<String, String> oauth_request_parameters;

    public MoClientConfigurationAction(MoOAuthSettings settings, PluginLicenseManager pluginLicenseManager, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginLicenseManager = pluginLicenseManager;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void validate() {
        LOGGER.info((Object)"OAuth Configuration Action validate");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
        Boolean error = false;
        ArrayList<String> invalidValues = new ArrayList<String>();
        UrlValidator urlValidator = new UrlValidator(8L);
        if (StringUtils.isBlank((CharSequence)this.clientID)) {
            invalidValues.add("clientid");
        }
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            invalidValues.add("clientsecret");
        }
        if (StringUtils.isBlank((CharSequence)this.appName)) {
            invalidValues.add("appname");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom App") || StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom OpenID")) {
            if (!urlValidator.isValid(this.authorizeEndpoint)) {
                invalidValues.add("authorizeendpoint");
            }
            if (!urlValidator.isValid(this.accessTokenEndpoint)) {
                invalidValues.add("accesstokenendpoint");
            }
            if (StringUtils.isBlank((CharSequence)this.sendTokenAuthParameterIn) || StringUtils.equalsIgnoreCase((CharSequence)this.sendTokenAuthParameterIn, null)) {
                this.sendTokenAuthParameterIn = this.settings.getSendTokenAuthParameterIn();
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Custom App")) {
            if (!urlValidator.isValid(this.userInfoEndpoint)) {
                invalidValues.add("userinfoendpoint");
            }
            if (StringUtils.isBlank((CharSequence)this.customAppName)) {
                invalidValues.add("customappname");
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Keycloak") && StringUtils.isBlank((CharSequence)this.hostName)) {
            invalidValues.add("hostName");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Keycloak") && StringUtils.isBlank((CharSequence)this.realmName)) {
            invalidValues.add("realmName");
        }
        if ((StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"AWS Cognito") || StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"ADFS")) && StringUtils.isBlank((CharSequence)this.domainName)) {
            invalidValues.add("domainName");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"Azure AD") && StringUtils.isBlank((CharSequence)this.tenantID)) {
            invalidValues.add("tenantid");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"GitLab")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.appHostedOn, (CharSequence)"self-hosted") && StringUtils.isNotBlank((CharSequence)this.domainName)) {
                if (!urlValidator.isValid(this.domainName)) {
                    this.addActionError(this.getText("oauth.error.invalid.domainNameUrl"));
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.appHostedOn, (CharSequence)"self-hosted") && StringUtils.isBlank((CharSequence)this.domainName)) {
                invalidValues.add("domainName");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.singleLogoutURL) && !urlValidator.isValid(this.singleLogoutURL)) {
            invalidValues.add("singleLogoutEndpoint");
        }
        if (MoOAuthUtils.isOpenIdProtocol(this.appName) && StringUtils.isNotBlank((CharSequence)this.publicKey)) {
            String publicCertificate = this.publicKey;
            publicCertificate = MoOAuthUtils.deserializePublicKey(publicCertificate);
            byte[] publicBytes = Base64.decodeBase64(publicCertificate);
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicBytes);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                keyFactory.generatePublic(keySpec);
            }
            catch (GeneralSecurityException e) {
                invalidValues.add("publicKey");
            }
        }
        for (String invalidValue : invalidValues) {
            error = true;
            this.addActionError(this.getText("oauth.error.invalid." + invalidValue));
        }
        if (super.hasActionErrors() || error.booleanValue()) {
            this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
            this.initializeOAuthConfig();
            return;
        }
        super.validate();
    }

    public String execute() throws Exception {
        LOGGER.info((Object)"OAuth Configuration Action doExecute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                LOGGER.debug((Object)("OAuth Configuration Action doExecute Submitted: " + this.submitted));
                this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
                if (!this.settings.isLicenseValid().booleanValue()) {
                    try {
                        response.sendRedirect(this.settings.getManageAddOnURL());
                        return null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (BooleanUtils.toBoolean((Boolean)this.deleterefreshtoken)) {
                    this.settings.setRefreshToken("");
                }
                if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                    if (StringUtils.equals((CharSequence)this.settings.getClientID(), (CharSequence)"")) {
                        MoOAuthPluginHandler.saveDefaultConfiguration();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"OKTA")) {
                        this.useStateParameter = Boolean.TRUE;
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)this.appName, (CharSequence)"miniOrange")) {
                        this.setUseStateParameter(Boolean.TRUE);
                    }
                    HashMap<String, String> oauth_request_parameters = new HashMap<String, String>();
                    int totalOauthParameters = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("totalOauthParameters"), (CharSequence)"0"));
                    for (int i = 0; i < totalOauthParameters; ++i) {
                        String key = request.getParameter("oauthParameterKey[" + i + "]");
                        String value = request.getParameter("oauthParameterValue[" + i + "]");
                        if (!StringUtils.isNotEmpty((CharSequence)key) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                        oauth_request_parameters.put(key.trim(), value.trim());
                    }
                    this.accessTokenEndpoint = this.accessTokenEndpoint.trim().replace(" ", "%20");
                    this.authorizeEndpoint = this.authorizeEndpoint.trim().replace(" ", "%20");
                    this.userInfoEndpoint = this.userInfoEndpoint.trim().replace(" ", "%20");
                    if (StringUtils.equals((CharSequence)this.appName, (CharSequence)"Custom OAuth") || StringUtils.equals((CharSequence)this.appName, (CharSequence)"Custom OpenID")) {
                        MoOAuthPluginHandler.saveOAuthConfiguration(this.appName, this.customAppName, this.clientID, this.clientSecret, this.scope, this.authorizeEndpoint, this.accessTokenEndpoint, this.userInfoEndpoint, this.fetchGroupsEndpoint, this.useStateParameter, this.enableCheckIssuerFor, this.checkIssuerFor, this.customIssuerValue, this.singleLogoutURL, this.nonceCheck, this.publicKey, this.acrValueCheck, this.enablePKCESupport, oauth_request_parameters, this.sendTokenAuthParameterIn);
                    } else {
                        MoOAuthPluginHandler.saveOAuthConfiguration(this.appName, this.appHostedOn, this.clientID, this.clientSecret, this.scope, this.tenantID, this.hostName, this.realmName, this.domainName, this.enableCheckIssuerFor, this.checkIssuerFor, this.customIssuerValue, this.singleLogoutURL, this.useStateParameter, this.nonceCheck, this.publicKey, this.acrValueCheck, this.enablePKCESupport, oauth_request_parameters);
                    }
                    LOGGER.info((Object)"OAuth Configuration saved");
                    this.addActionMessage(this.getText("oauth.success.config"));
                }
                this.initializeOAuthConfig();
                return "success";
            }
            catch (MoOAuthPluginException e) {
                e.printStackTrace();
                this.addActionError(e.getMessage());
                return "input";
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.error((Object)("Error is : " + e));
                this.addActionError("An error occurred while saving your details. Please check logs for more info.");
                return "input";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(MoOAuthPluginHandler.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeOAuthConfig() {
        LOGGER.info((Object)"initializing OAuthConfig");
        this.customAppName = this.settings.getCustomAppName();
        this.appName = this.settings.getAppName();
        this.classifyAppsInOauthAndOpenId();
        if (StringUtils.equals((CharSequence)this.appName, (CharSequence)"Microsoft")) {
            this.customAppName = "Azure AD";
            this.appName = "Azure AD";
            this.settings.setAppName(this.appName);
            this.settings.setCustomAppName(this.customAppName);
        }
        this.isOpenIdProtocol = MoOAuthUtils.isOpenIdProtocol(this.appName) ? "true" : "false";
        this.initializeDebugLogs();
        LOGGER.debug((Object)("isOpenIdProtocol: " + this.isOpenIdProtocol));
        this.appHostedOn = this.settings.getAppHostedOn();
        this.clientID = this.settings.getClientID();
        this.clientSecret = this.settings.getClientSecret();
        this.authorizeEndpoint = this.settings.getAuthorizeEndpoint();
        this.accessTokenEndpoint = this.settings.getAccessTokenEndpoint();
        this.userInfoEndpoint = this.settings.getUserInfoEndpoint();
        this.fetchGroupsEndpoint = this.settings.getFetchGroupsEndpoint();
        this.scope = this.settings.getScope();
        this.isCredentialsVerified = this.settings.getIsCredentialsVerified();
        this.tenantID = this.settings.getTenantID();
        this.hostName = this.settings.getHostName();
        this.realmName = this.settings.getRealmName();
        this.domainName = this.settings.getDomainName();
        this.useStateParameter = this.settings.getUseStateParameter();
        this.enableCheckIssuerFor = this.settings.getEnableCheckIssuerFor();
        this.checkIssuerFor = this.settings.getCheckIssuerFor();
        this.customIssuerValue = this.settings.getCustomIssuerValue();
        this.singleLogoutURL = this.settings.getSingleLogoutURL();
        this.publicKey = StringUtils.trim((String)this.settings.getPublicKey());
        this.nonceCheck = this.settings.getNonceCheck();
        this.acrValueCheck = this.settings.getACRValueCheck();
        this.enablePKCESupport = this.settings.getEnablePKCESupport();
        this.oauth_request_parameters = this.settings.getOauth_request_parameters();
        this.sendTokenAuthParameterIn = this.settings.getSendTokenAuthParameterIn();
        LOGGER.info((Object)"initializeOAuthConfig done....");
    }

    private void initializeDebugLogs() {
        Boolean enableDebugLogs = this.settings.getEnableDebugLogs();
        ConfigureLog4jAction configureLog4jAction = new ConfigureLog4jAction();
        configureLog4jAction.setExtraClassName("com.miniorange.oauth");
        if (enableDebugLogs.booleanValue()) {
            configureLog4jAction.setExtraLevelName("DEBUG");
        } else {
            configureLog4jAction.setExtraLevelName("INFO");
        }
        configureLog4jAction.add();
    }

    private void classifyAppsInOauthAndOpenId() {
        for (MoOAuthPluginConstants.OAuthApps oAuthApps : MoOAuthPluginConstants.OAuthApps.values()) {
            this.defaultOauthApps.add(oAuthApps.getAppName());
        }
        for (Enum enum_ : MoOAuthPluginConstants.OpenIdApps.values()) {
            this.defaultOpenIdApps.add(((MoOAuthPluginConstants.OpenIdApps)enum_).getAppName());
        }
    }

    public void setDefaultOpenIdApps(ArrayList<String> defaultOpenIdApps) {
        this.defaultOpenIdApps = defaultOpenIdApps;
    }

    public void setDefaultOauthApps(ArrayList<String> defaultOauthApps) {
        this.defaultOauthApps = defaultOauthApps;
    }

    @StrutsParameter
    public ArrayList<String> getDefaultOpenIdApps() {
        return this.defaultOpenIdApps;
    }

    @StrutsParameter
    public ArrayList<String> getDefaultOauthApps() {
        return this.defaultOauthApps;
    }

    @StrutsParameter
    public String getCustomAppName() {
        return this.customAppName;
    }

    @StrutsParameter
    public void setCustomAppName(String customAppName) {
        this.customAppName = customAppName;
    }

    @StrutsParameter
    public String getClientID() {
        return this.clientID;
    }

    @StrutsParameter
    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    @StrutsParameter
    public String getScope() {
        return this.scope;
    }

    @StrutsParameter
    public void setScope(String scope) {
        this.scope = scope;
    }

    @StrutsParameter
    public String getClientSecret() {
        return this.clientSecret;
    }

    @StrutsParameter
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @StrutsParameter
    public String getAuthorizeEndpoint() {
        return this.authorizeEndpoint;
    }

    @StrutsParameter
    public void setAuthorizeEndpoint(String authorizeEndpoint) {
        this.authorizeEndpoint = authorizeEndpoint;
    }

    @StrutsParameter
    public String getAccessTokenEndpoint() {
        return this.accessTokenEndpoint;
    }

    @StrutsParameter
    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.accessTokenEndpoint = accessTokenEndpoint;
    }

    @StrutsParameter
    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    @StrutsParameter
    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    @StrutsParameter
    public String getFetchGroupsEndpoint() {
        return this.fetchGroupsEndpoint;
    }

    @StrutsParameter
    public void setFetchGroupsEndpoint(String fetchGroupsEndpoint) {
        this.fetchGroupsEndpoint = fetchGroupsEndpoint;
    }

    @StrutsParameter
    public Boolean getCredentialsVerified() {
        return this.isCredentialsVerified;
    }

    @StrutsParameter
    public void setCredentialsVerified(Boolean credentialsVerified) {
        this.isCredentialsVerified = credentialsVerified;
    }

    @StrutsParameter
    public String getTenantID() {
        return this.tenantID;
    }

    @StrutsParameter
    public void setTenantID(String tenantID) {
        this.tenantID = tenantID;
    }

    @StrutsParameter
    public String getAppName() {
        return this.appName;
    }

    @StrutsParameter
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @StrutsParameter
    public Boolean getSubmitted() {
        return this.submitted;
    }

    @StrutsParameter
    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    @StrutsParameter
    public Boolean getDeleterefreshtoken() {
        return this.deleterefreshtoken;
    }

    @StrutsParameter
    public void setDeleterefreshtoken(Boolean deleterefreshtoken) {
        this.deleterefreshtoken = deleterefreshtoken;
    }

    @StrutsParameter
    public String getXsrfToken() {
        return this.xsrfToken;
    }

    @StrutsParameter
    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    @StrutsParameter
    public MoOAuthSettings getSettings() {
        return this.settings;
    }

    @StrutsParameter
    public void setSettings(MoOAuthSettings settings) {
        this.settings = settings;
    }

    @StrutsParameter
    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @StrutsParameter
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @StrutsParameter
    public UserManager getUserManager() {
        return this.userManager;
    }

    @StrutsParameter
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @StrutsParameter
    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    @StrutsParameter
    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    @StrutsParameter
    public String getHostName() {
        return this.hostName;
    }

    @StrutsParameter
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @StrutsParameter
    public String getRealmName() {
        return this.realmName;
    }

    @StrutsParameter
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    @StrutsParameter
    public String getDomainName() {
        return this.domainName;
    }

    @StrutsParameter
    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    @StrutsParameter
    public Boolean getUseStateParameter() {
        return this.useStateParameter;
    }

    @StrutsParameter
    public void setUseStateParameter(Boolean useStateParameter) {
        this.useStateParameter = useStateParameter;
    }

    @StrutsParameter
    public Boolean getEnableCheckIssuerFor() {
        return this.enableCheckIssuerFor;
    }

    @StrutsParameter
    public void setEnableCheckIssuerFor(Boolean enableCheckIssuerFor) {
        this.enableCheckIssuerFor = enableCheckIssuerFor;
    }

    @StrutsParameter
    public String getCheckIssuerFor() {
        return this.checkIssuerFor;
    }

    @StrutsParameter
    public void setCheckIssuerFor(String checkIssuerFor) {
        this.checkIssuerFor = checkIssuerFor;
    }

    @StrutsParameter
    public String getCustomIssuerValue() {
        return this.customIssuerValue;
    }

    @StrutsParameter
    public void setCustomIssuerValue(String customIssuerValue) {
        this.customIssuerValue = customIssuerValue;
    }

    @StrutsParameter
    public String getSingleLogoutURL() {
        return this.singleLogoutURL;
    }

    @StrutsParameter
    public void setSingleLogoutURL(String singleLogoutURL) {
        this.singleLogoutURL = singleLogoutURL;
    }

    @StrutsParameter
    public String getAppHostedOn() {
        return this.appHostedOn;
    }

    @StrutsParameter
    public void setAppHostedOn(String appHostedOn) {
        this.appHostedOn = appHostedOn;
    }

    @StrutsParameter
    public String getPublicKey() {
        return this.publicKey;
    }

    @StrutsParameter
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    @StrutsParameter
    public Boolean getNonceCheck() {
        return this.nonceCheck;
    }

    @StrutsParameter
    public void setNonceCheck(Boolean nonceCheck) {
        this.nonceCheck = nonceCheck;
    }

    @StrutsParameter
    public String getIsOpenIdProtocol() {
        return this.isOpenIdProtocol;
    }

    @StrutsParameter
    public void setIsOpenIdProtocol(String isOpenIdProtocol) {
        this.isOpenIdProtocol = isOpenIdProtocol;
    }

    @StrutsParameter
    public Boolean getAcrValueCheck() {
        return this.acrValueCheck;
    }

    @StrutsParameter
    public void setAcrValueCheck(Boolean acrValueCheck) {
        this.acrValueCheck = acrValueCheck;
    }

    @StrutsParameter
    public Boolean getEnablePKCESupport() {
        return this.enablePKCESupport;
    }

    @StrutsParameter
    public void setEnablePKCESupport(Boolean enablePKCESupport) {
        this.enablePKCESupport = enablePKCESupport;
    }

    @StrutsParameter
    public Map<String, String> getOauth_request_parameters() {
        return this.oauth_request_parameters;
    }

    @StrutsParameter
    public void setOauth_request_parameters(Map<String, String> oauth_request_parameters) {
        this.oauth_request_parameters = oauth_request_parameters;
    }

    @StrutsParameter
    public String getSendTokenAuthParameterIn() {
        return this.sendTokenAuthParameterIn;
    }

    @StrutsParameter
    public void setSendTokenAuthParameterIn(String sendTokenAuthParameterIn) {
        this.sendTokenAuthParameterIn = sendTokenAuthParameterIn;
    }
}

